/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.util;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.regex.Pattern;

public interface Oid {
    public static final int OID_LENGTH = 24;
    public static final int[] _CC_EXTRA;
    public static final int _CC_RANGE = 65;
    public static final int _CC_0 = 48;
    public static final int _CC_A = 65;
    public static final int _CC_a = 97;
    public static final int _INT_LEN = 5;
    public static final int _CHAR_PER_INT = 5;
    public static final Pattern _oidPattern;
    public static final SecureRandom _random;

    public static String nextOid() {
        int[] values = Oid.getRandomInts(5);
        if (!1.$assertionsDisabled && values.length != 5) {
            throw new AssertionError();
        }
        ArrayList<Integer> bytes = new ArrayList<Integer>();
        int i2 = values.length;
        block0: while (--i2 >= 0) {
            int val = values[i2];
            if (val < 0) {
                val = -val;
            }
            int j = 5;
            while (true) {
                bytes.add(Oid._escOid(val % 65));
                if (bytes.size() >= 24) break block0;
                if (--j == 0) continue block0;
                val = (int)Math.ceil((double)val / 65.0);
            }
        }
        int[] arr = bytes.stream().mapToInt(i -> i).toArray();
        return new String(arr, 0, arr.length);
    }

    public static String mergeOid(String oid1, String oid2) {
        return oid1.substring(0, 12) + oid2.substring(0, 12);
    }

    public static boolean isValidOid(String value) {
        return value.length() == 24 && _oidPattern.matcher(value).find();
    }

    public static int[] getRandomInts(int length) {
        int[] values = new int[length];
        int i = length;
        while (--i >= 0) {
            values[i] = _random.nextInt(Integer.MAX_VALUE);
        }
        return values;
    }

    public static int _escOid(int v) {
        if (v < 10) {
            return 48 + v;
        }
        if ((v -= 10) < 26) {
            return 65 + v;
        }
        if ((v -= 26) < 26) {
            return 97 + v;
        }
        return _CC_EXTRA[v - 26];
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        _CC_EXTRA = new int[]{45, 46, 95};
        _oidPattern = Pattern.compile("^[-0-9a-zA-Z._]*$");
        _random = new SecureRandom();
    }
}

