/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl.imexp;

import io.keikai.model.CellRegion;
import io.keikai.model.SAutoFilter;
import io.keikai.model.SBook;
import io.keikai.model.SBorder;
import io.keikai.model.SCFValueObject;
import io.keikai.model.SCellStyle;
import io.keikai.model.SChart;
import io.keikai.model.SChartAxis;
import io.keikai.model.SColor;
import io.keikai.model.SColorFilter;
import io.keikai.model.SColorScale;
import io.keikai.model.SColumnArray;
import io.keikai.model.SConditionalFormatting;
import io.keikai.model.SConditionalFormattingRule;
import io.keikai.model.SCustomFilter;
import io.keikai.model.SCustomFilters;
import io.keikai.model.SDataBar;
import io.keikai.model.SDataValidation;
import io.keikai.model.SDynamicFilter;
import io.keikai.model.SExtraStyle;
import io.keikai.model.SFill;
import io.keikai.model.SFont;
import io.keikai.model.SIconSet;
import io.keikai.model.SPicture;
import io.keikai.model.SRichText;
import io.keikai.model.SSheet;
import io.keikai.model.STable;
import io.keikai.model.STableColumn;
import io.keikai.model.STableStyle;
import io.keikai.model.STableStyleElem;
import io.keikai.model.STableStyleInfo;
import io.keikai.model.STop10Filter;
import io.keikai.model.SWorkbookProtection;
import io.keikai.model.ViewAnchor;
import io.keikai.model.chart.SChartData;
import io.keikai.model.chart.SGeneralChartData;
import io.keikai.model.impl.AbstractBookAdv;
import io.keikai.model.impl.AbstractChartAdv;
import io.keikai.model.impl.AbstractColorAdv;
import io.keikai.model.impl.AbstractDataValidationAdv;
import io.keikai.model.impl.AbstractFillAdv;
import io.keikai.model.impl.AbstractFontAdv;
import io.keikai.model.impl.AbstractSeriesAdv;
import io.keikai.model.impl.ObjectRefImpl;
import io.keikai.model.impl.SheetImpl;
import io.keikai.model.impl.WorkbookProtectionImpl;
import io.keikai.model.impl.chart.AreaChartDataImpl;
import io.keikai.model.impl.chart.BarChartDataImpl;
import io.keikai.model.impl.chart.BubbleChartDataImpl;
import io.keikai.model.impl.chart.CategoryAxisImpl;
import io.keikai.model.impl.chart.DateAxisImpl;
import io.keikai.model.impl.chart.GeneralChartDataImpl;
import io.keikai.model.impl.chart.LineChartDataImpl;
import io.keikai.model.impl.chart.SeriesImpl;
import io.keikai.model.impl.chart.ValueAxisImpl;
import io.keikai.model.sys.EngineFactory;
import io.keikai.model.sys.dependency.ObjectRef;
import io.keikai.model.sys.dependency.Ref;
import io.keikai.model.sys.formula.EvaluationResult;
import io.keikai.model.sys.formula.FormulaEngine;
import io.keikai.model.sys.formula.FormulaEvaluationContext;
import io.keikai.model.sys.formula.FormulaExpression;
import io.keikai.model.util.Strings;
import io.keikai.range.impl.imexp.AbstractExcelExporter;
import io.keikai.range.impl.imexp.BookHelper;
import io.keikai.range.impl.imexp.PoiEnumConversion;
import io.keikai.range.impl.imexp.UnitUtil;
import io.keikai.util.Converter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Color;
import org.apache.poi.ss.usermodel.ConditionalFormatting;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.CustomFilter;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DxfCellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xddf.usermodel.XDDFColor;
import org.apache.poi.xddf.usermodel.XDDFFillProperties;
import org.apache.poi.xddf.usermodel.XDDFShapeProperties;
import org.apache.poi.xddf.usermodel.XDDFSolidFillProperties;
import org.apache.poi.xddf.usermodel.chart.AxisCrosses;
import org.apache.poi.xddf.usermodel.chart.AxisLabelAlignment;
import org.apache.poi.xddf.usermodel.chart.AxisPosition;
import org.apache.poi.xddf.usermodel.chart.BarDirection;
import org.apache.poi.xddf.usermodel.chart.BarGrouping;
import org.apache.poi.xddf.usermodel.chart.ChartTypes;
import org.apache.poi.xddf.usermodel.chart.DisplayBlanks;
import org.apache.poi.xddf.usermodel.chart.Grouping;
import org.apache.poi.xddf.usermodel.chart.MarkerStyle;
import org.apache.poi.xddf.usermodel.chart.XDDFArea3DChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFAreaChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFBar3DChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFBarChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFBubbleChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryAxisHelper;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFChart;
import org.apache.poi.xddf.usermodel.chart.XDDFChartAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFChartLegend;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFDateAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFDateAxisHelper;
import org.apache.poi.xddf.usermodel.chart.XDDFLine3DChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFLineChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFValueAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFValueAxisHelper;
import org.apache.poi.xddf.usermodel.chart.XDDFView3D;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.model.StylesTableHelper;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFChart;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFColorFilter;
import org.apache.poi.xssf.usermodel.XSSFConditionalFormatting;
import org.apache.poi.xssf.usermodel.XSSFConditionalFormattingHelper;
import org.apache.poi.xssf.usermodel.XSSFCustomFilters;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFDxfCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDynamicFilter;
import org.apache.poi.xssf.usermodel.XSSFFilterColumn;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRichTextStringHelper;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFSheetHelper;
import org.apache.poi.xssf.usermodel.XSSFTable;
import org.apache.poi.xssf.usermodel.XSSFTableColumn;
import org.apache.poi.xssf.usermodel.XSSFTableColumnHelper;
import org.apache.poi.xssf.usermodel.XSSFTableStyle;
import org.apache.poi.xssf.usermodel.XSSFTableStyleInfo;
import org.apache.poi.xssf.usermodel.XSSFTop10Filter;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbookHelper;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellFill;
import org.apache.xmlbeans.XmlCursor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTAutoFilter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellAlignment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCfRule;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCfvo;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCol;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColorFilter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColorScale;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTConditionalFormatting;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDataBar;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTExtension;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTExtensionList;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFilter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFilterColumn;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFilters;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFont;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTIconSet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTOutlinePr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRst;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSelection;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetFormatPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTable;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableStyle;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableStyleElement;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableStyles;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXf;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCfType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCfvoType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STConditionalFormattingOperator;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STHorizontalAlignment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STIconSetType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPatternType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STTableStyleType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STTimePeriod;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STVerticalAlignment;
import org.zkoss.util.Pair;

public class ExcelXlsxExporter
extends AbstractExcelExporter {
    private static final long serialVersionUID = 20141231175402L;

    @Override
    protected void exportColumnArray(SSheet sheet, Sheet poiSheet, SColumnArray columnArr) {
        XSSFSheet xssfSheet = (XSSFSheet)poiSheet;
        this._exportPhase.setPhase("column");
        CTWorksheet ctSheet = xssfSheet.getCTWorksheet();
        if (xssfSheet.getCTWorksheet().sizeOfColsArray() == 0) {
            xssfSheet.getCTWorksheet().addNewCols();
        }
        int defaultWidth = sheet.getDefaultColumnWidth();
        int columnWidth = columnArr.getWidth();
        AbstractBookAdv book = (AbstractBookAdv)sheet.getBook();
        int charWidth = book.getCharWidth();
        CTSheetFormatPr ctSheetFormatPr = ctSheet.getSheetFormatPr();
        if (ctSheetFormatPr == null) {
            ctSheetFormatPr = ctSheet.addNewSheetFormatPr();
        }
        ctSheetFormatPr.setDefaultColWidth(UnitUtil.pxToCTChar(defaultWidth, charWidth));
        CTCol col = ctSheet.getColsArray(0).addNewCol();
        int columnArrIndex = columnArr.getIndex();
        this._exportPhase.setColIndex(columnArrIndex);
        col.setMin((long)(columnArrIndex + 1));
        col.setMax((long)(columnArr.getLastIndex() + 1));
        col.setStyle((long)this.toPOICellStyle(columnArr.getCellStyle()).getIndex());
        col.setCustomWidth(columnArr.isCustomWidth() || columnWidth != defaultWidth);
        col.setWidth(UnitUtil.pxToCTChar(columnWidth, charWidth));
        col.setHidden(columnArr.isHidden());
        col.setBestFit(columnArr.isBestFit());
        if (columnArr.isCollapsed()) {
            col.setCollapsed(true);
        }
        if (columnArr.getOutlineLevel() > 0) {
            short outlineLevel = (short)columnArr.getOutlineLevel();
            col.setOutlineLevel(outlineLevel);
        }
    }

    @Override
    protected Workbook createPoiBook() {
        XSSFWorkbook book = new XSSFWorkbook();
        book.setCellFormulaValidation(false);
        return book;
    }

    @Override
    protected void exportChart(SSheet sheet, Sheet poiSheet) {
        this._exportPhase.setPhase("chart");
        for (SChart chart : sheet.getCharts()) {
            if (chart.isSparkline()) continue;
            XSSFChart poiChart = ((XSSFDrawing)poiSheet.createDrawingPatriarch()).createChart(this.toClientAnchor(chart.getAnchor(), sheet));
            this.plotPoiChart(chart, poiChart);
            List<SChartData> chartSeries = ((AbstractChartAdv)chart).getChartData();
            boolean isCombo = chartSeries.size() > 1;
            for (SChartData chartData : chartSeries) {
                this.fillPoiChartData((XSSFSheet)poiSheet, poiChart, chart, chartData, chart.isThreeD(), isCombo);
            }
        }
    }

    @Override
    protected void exportPicture(SSheet sheet, Sheet poiSheet) {
        this._exportPhase.setPhase("picture");
        for (SPicture picture : sheet.getPictures()) {
            int poiPictureIndex = (Integer)this.exportedPicDataMap.get(picture.getPictureData().getIndex());
            poiSheet.createDrawingPatriarch().createPicture(this.toClientAnchor(picture.getAnchor(), sheet), poiPictureIndex);
        }
    }

    protected void fillPoiChartData(XSSFSheet poiSheet, XSSFChart poiChart, SChart chart, SChartData schartData, boolean isThreeD, boolean isCombo) {
        if (!(schartData instanceof SGeneralChartData)) {
            return;
        }
        XDDFChartAxis bottomAxis = null;
        XDDFValueAxis leftAxis = null;
        if (schartData instanceof GeneralChartDataImpl) {
            Optional<XDDFChartAxis> optionalXDDFChartAxis;
            GeneralChartDataImpl generalChartData = (GeneralChartDataImpl)schartData;
            SChartAxis categoryAxis = generalChartData.getCategoryAxis();
            SChartAxis dateAxis = generalChartData.getDateAxis();
            List<SChartAxis> valueAxes = generalChartData.getValueAxes();
            List poiAxes = poiChart.getAxes();
            ArrayList<Object> axes = new ArrayList<Object>();
            if (categoryAxis != null && (optionalXDDFChartAxis = poiAxes.stream().filter(a -> a.getId() == categoryAxis.getId()).findAny()).isPresent()) {
                bottomAxis = optionalXDDFChartAxis.get();
                axes.add(bottomAxis);
            }
            if (dateAxis != null && (optionalXDDFChartAxis = poiAxes.stream().filter(a -> a.getId() == dateAxis.getId()).findAny()).isPresent()) {
                leftAxis = (XDDFValueAxis)optionalXDDFChartAxis.get();
                axes.add(leftAxis);
            }
            if (valueAxes != null) {
                for (SChartAxis axis : valueAxes) {
                    Optional<XDDFChartAxis> optionalXDDFChartAxis2 = poiAxes.stream().filter(a -> a.getId() == axis.getId()).findAny();
                    if (!optionalXDDFChartAxis2.isPresent()) continue;
                    if (bottomAxis == null && leftAxis != null) {
                        bottomAxis = leftAxis;
                    }
                    leftAxis = (XDDFValueAxis)optionalXDDFChartAxis2.get();
                    axes.add(leftAxis);
                }
            }
            if (poiAxes.isEmpty() && !isCombo) {
                switch (chart.getType()) {
                    case AREA: 
                    case BAR: 
                    case COLUMN: 
                    case LINE: {
                        bottomAxis = poiChart.createCategoryAxis(AxisPosition.BOTTOM);
                        break;
                    }
                    case BUBBLE: 
                    case SCATTER: {
                        bottomAxis = poiChart.createValueAxis(AxisPosition.BOTTOM);
                    }
                }
                if (bottomAxis != null) {
                    leftAxis = poiChart.createValueAxis(AxisPosition.LEFT);
                    XDDFValueAxisHelper.setDelete((XDDFValueAxis)leftAxis, (boolean)true);
                    if (bottomAxis instanceof XDDFValueAxis) {
                        XDDFValueAxisHelper.setDelete((XDDFValueAxis)((XDDFValueAxis)bottomAxis), (boolean)true);
                    } else {
                        XDDFCategoryAxisHelper.setDelete((XDDFCategoryAxis)((XDDFCategoryAxis)bottomAxis), (boolean)true);
                    }
                    bottomAxis.crossAxis((XDDFChartAxis)leftAxis);
                    leftAxis.crossAxis(bottomAxis);
                }
            }
        }
        SChart.ChartType chartType = ((SGeneralChartData)schartData).getType();
        XDDFChartData categoryData = null;
        switch (chartType) {
            case AREA: {
                AreaChartDataImpl areaChartData = (AreaChartDataImpl)schartData;
                Grouping grouping = PoiEnumConversion.toPoiGrouping(areaChartData.getGrouping());
                categoryData = poiChart.createData(isThreeD ? ChartTypes.AREA3D : ChartTypes.AREA, bottomAxis, leftAxis);
                if (isThreeD) {
                    ((XDDFArea3DChartData)categoryData).setGrouping(grouping);
                    break;
                }
                ((XDDFAreaChartData)categoryData).setGrouping(grouping);
                break;
            }
            case BAR: 
            case COLUMN: {
                BarChartDataImpl barChartData = (BarChartDataImpl)schartData;
                Grouping grouping = PoiEnumConversion.toPoiBarGrouping(barChartData.getGrouping());
                BarDirection direction = PoiEnumConversion.toPoiBarDirection(barChartData.getBarDirection());
                categoryData = poiChart.createData(isThreeD ? ChartTypes.BAR3D : ChartTypes.BAR, bottomAxis, leftAxis);
                if (isThreeD) {
                    ((XDDFBar3DChartData)categoryData).setBarGrouping((BarGrouping)grouping);
                    ((XDDFBar3DChartData)categoryData).setBarDirection(direction);
                    break;
                }
                ((XDDFBarChartData)categoryData).setBarGrouping((BarGrouping)grouping);
                ((XDDFBarChartData)categoryData).setBarDirection(direction);
                ((XDDFBarChartData)categoryData).setOverlap(Byte.valueOf((byte)barChartData.getBarOverlap()));
                break;
            }
            case BUBBLE: {
                BubbleChartDataImpl bubbleChartData = (BubbleChartDataImpl)schartData;
                leftAxis.setCrosses(AxisCrosses.AUTO_ZERO);
                XDDFBubbleChartData xyzData = new XDDFBubbleChartData((XDDFChart)poiChart, poiChart.getCTChart().getPlotArea().addNewBubbleChart(), bottomAxis, leftAxis);
                this.fillXYZData(poiSheet, bubbleChartData, xyzData);
                poiChart.plot((XDDFChartData)xyzData);
                break;
            }
            case DOUGHNUT: {
                categoryData = poiChart.createData(ChartTypes.DOUGHNUT, bottomAxis, leftAxis);
                break;
            }
            case LINE: {
                categoryData = poiChart.createData(isThreeD ? ChartTypes.LINE3D : ChartTypes.LINE, bottomAxis, leftAxis);
                break;
            }
            case PIE: {
                categoryData = poiChart.createData(isThreeD ? ChartTypes.PIE3D : ChartTypes.PIE, bottomAxis, leftAxis);
                break;
            }
            case SCATTER: {
                XDDFChartData poiChartData = poiChart.createData(ChartTypes.SCATTER, bottomAxis, leftAxis);
                this.fillXYData(poiSheet, (SGeneralChartData)schartData, poiChartData);
                poiChart.plot(poiChartData);
                break;
            }
        }
        if (categoryData != null) {
            this.fillCategoryData(poiSheet, (SGeneralChartData)schartData, categoryData);
            poiChart.plot(categoryData);
        }
    }

    protected void plotPoiChart(SChart chart, XSSFChart poiChart) {
        AxisPosition position;
        AbstractChartAdv chartAdv = (AbstractChartAdv)chart;
        if (chartAdv.isShowTitle()) {
            poiChart.setTitleText(chart.getTitle());
            Boolean autoTitleDeleted = chartAdv.isAutoTitleDeleted();
            if (autoTitleDeleted != null) {
                poiChart.setAutoTitleDeleted(autoTitleDeleted.booleanValue());
            }
        }
        if (chart.isThreeD()) {
            XDDFView3D view3d = poiChart.getOrAddView3D();
            if (chart.getRotX() != 0) {
                view3d.setXRotationAngle(Byte.valueOf((byte)chart.getRotX()));
            }
            if (chart.getRotY() != 0) {
                view3d.setYRotationAngle(Integer.valueOf(chart.getRotY()));
            }
            if (chart.getPerspective() != 30) {
                view3d.setPerspectiveAngle(Short.valueOf((short)chart.getPerspective()));
            }
            if (chart.getHPercent() != 100) {
                view3d.setHPercent(Integer.valueOf(chart.getHPercent()));
            }
            if (chart.getDepthPercent() != 100) {
                view3d.setDepthPercent(Integer.valueOf(chart.getDepthPercent()));
            }
            if (!chart.isRightAngleAxes()) {
                view3d.setRightAngleAxes(Boolean.valueOf(false));
            }
        }
        if (chart.getLegendPosition() != null) {
            XDDFChartLegend legend = poiChart.getOrAddLegend();
            legend.setPosition(PoiEnumConversion.toPoiLegendPosition(chart.getLegendPosition()));
        }
        for (SChartAxis axis : chart.getCategoryAxises()) {
            CategoryAxisImpl catAx = (CategoryAxisImpl)axis;
            position = catAx.getPosition() != null ? PoiEnumConversion.toPoiAxisPosition(catAx.getPosition()) : AxisPosition.BOTTOM;
            XDDFCategoryAxis poiCatAx = poiChart.createCategoryAxis(position);
            XDDFCategoryAxisHelper.setId((XDDFCategoryAxis)poiCatAx, (long)catAx.getId());
            if (catAx.getMin() != null) {
                poiCatAx.setMinimum(catAx.getMin().doubleValue());
            }
            if (catAx.getMax() != null) {
                poiCatAx.setMaximum(catAx.getMax().doubleValue());
            }
            XDDFCategoryAxisHelper.setDelete((XDDFCategoryAxis)poiCatAx, (!catAx.isVisible() ? 1 : 0) != 0);
            if (catAx.getOrientation() != null) {
                poiCatAx.setOrientation(PoiEnumConversion.toPoiAxisOrientation(catAx.getOrientation()));
            }
            if (catAx.getFormat() != null) {
                poiCatAx.setNumberFormat(catAx.getFormat());
            }
            if (catAx.getTickLabelPosition() != null) {
                poiCatAx.setTickLabelPosition(PoiEnumConversion.toPoiAxisTickLabelPosition(catAx.getTickLabelPosition()));
            }
            if (catAx.getAxisCrosses() != null) {
                poiCatAx.setCrosses(PoiEnumConversion.toPoiAxisCrosses(catAx.getAxisCrosses()));
            }
            if (catAx.getLabelAlign() != null) {
                XDDFCategoryAxisHelper.setLabelAlignment((XDDFCategoryAxis)poiCatAx, (AxisLabelAlignment)PoiEnumConversion.toPoiAxisLabelAlign(catAx.getLabelAlign()));
            }
            if (catAx.hasMajorGridline()) {
                XDDFCategoryAxisHelper.setMajorGridline((XDDFCategoryAxis)poiCatAx, (boolean)catAx.hasMajorGridline());
            }
            XDDFCategoryAxisHelper.setLabelOffset((XDDFCategoryAxis)poiCatAx, (int)catAx.getLabelOffset());
            poiChart.getAxes().stream().filter(v -> v.getId() == catAx.getCrossAxisId()).findAny().ifPresent(v -> {
                v.crossAxis((XDDFChartAxis)poiCatAx);
                poiCatAx.crossAxis(v);
            });
        }
        for (SChartAxis axis : chart.getDateAxises()) {
            DateAxisImpl dateAx = (DateAxisImpl)axis;
            position = dateAx.getPosition() != null ? PoiEnumConversion.toPoiAxisPosition(dateAx.getPosition()) : AxisPosition.BOTTOM;
            XDDFDateAxis poiDateAx = poiChart.createDateAxis(position);
            XDDFDateAxisHelper.setId((XDDFDateAxis)poiDateAx, (long)dateAx.getId());
            if (dateAx.getMin() != null) {
                poiDateAx.setMinimum(dateAx.getMin().doubleValue());
            }
            if (dateAx.getMax() != null) {
                poiDateAx.setMaximum(dateAx.getMax().doubleValue());
            }
            XDDFDateAxisHelper.setDelete((XDDFDateAxis)poiDateAx, (!dateAx.isVisible() ? 1 : 0) != 0);
            if (dateAx.getOrientation() != null) {
                poiDateAx.setOrientation(PoiEnumConversion.toPoiAxisOrientation(dateAx.getOrientation()));
            }
            if (dateAx.getTickLabelPosition() != null) {
                poiDateAx.setTickLabelPosition(PoiEnumConversion.toPoiAxisTickLabelPosition(dateAx.getTickLabelPosition()));
            }
            if (dateAx.getAxisCrosses() != null) {
                poiDateAx.setCrosses(PoiEnumConversion.toPoiAxisCrosses(dateAx.getAxisCrosses()));
            }
            if (dateAx.hasMajorGridline()) {
                XDDFDateAxisHelper.setMajorGridline((XDDFDateAxis)poiDateAx, (boolean)dateAx.hasMajorGridline());
            }
            if (dateAx.getFormat() != null) {
                poiDateAx.setNumberFormat(dateAx.getFormat());
            }
            if (dateAx.getAuto() != null) {
                XDDFDateAxisHelper.setAuto((XDDFDateAxis)poiDateAx, (boolean)dateAx.getAuto());
            }
            if (dateAx.getLblOffset() != null) {
                XDDFDateAxisHelper.setLblOffset((XDDFDateAxis)poiDateAx, (int)dateAx.getLblOffset());
            }
            if (dateAx.getBaseTimeUnit() != null) {
                XDDFDateAxisHelper.setBaseTimeUnit((XDDFDateAxis)poiDateAx, (XDDFDateAxisHelper.TimeUnit)PoiEnumConversion.toPoiTimeUnit(dateAx.getBaseTimeUnit()));
            }
            if (dateAx.getMajorUnit() != null) {
                poiDateAx.setMajorUnit(dateAx.getMajorUnit().doubleValue());
            }
            if (dateAx.getMajorTimeUnit() != null) {
                XDDFDateAxisHelper.setMajorTimeUnit((XDDFDateAxis)poiDateAx, (XDDFDateAxisHelper.TimeUnit)PoiEnumConversion.toPoiTimeUnit(dateAx.getMajorTimeUnit()));
            }
            if (dateAx.getMajorUnit() != null) {
                poiDateAx.setMajorUnit(dateAx.getMajorUnit().doubleValue());
            }
            if (dateAx.getMinorTimeUnit() != null) {
                XDDFDateAxisHelper.setMinorTimeUnit((XDDFDateAxis)poiDateAx, (XDDFDateAxisHelper.TimeUnit)PoiEnumConversion.toPoiTimeUnit(dateAx.getMinorTimeUnit()));
            }
            poiChart.getAxes().stream().filter(v -> v.getId() == dateAx.getCrossAxisId()).findAny().ifPresent(v -> {
                v.crossAxis((XDDFChartAxis)poiDateAx);
                poiDateAx.crossAxis(v);
            });
        }
        for (SChartAxis axis : chart.getValueAxises()) {
            ValueAxisImpl valAx = (ValueAxisImpl)axis;
            position = valAx.getPosition() != null ? PoiEnumConversion.toPoiAxisPosition(valAx.getPosition()) : AxisPosition.LEFT;
            XDDFValueAxis poiValAx = poiChart.createValueAxis(position);
            XDDFValueAxisHelper.setId((XDDFValueAxis)poiValAx, (long)valAx.getId());
            if (valAx.getMin() != null) {
                poiValAx.setMinimum(valAx.getMin().doubleValue());
            }
            if (valAx.getMax() != null) {
                poiValAx.setMaximum(valAx.getMax().doubleValue());
            }
            if (valAx.getOrientation() != null) {
                poiValAx.setOrientation(PoiEnumConversion.toPoiAxisOrientation(valAx.getOrientation()));
            }
            if (valAx.getTickLabelPosition() != null) {
                poiValAx.setTickLabelPosition(PoiEnumConversion.toPoiAxisTickLabelPosition(valAx.getTickLabelPosition()));
            }
            if (valAx.getAxisCrosses() != null) {
                poiValAx.setCrosses(PoiEnumConversion.toPoiAxisCrosses(valAx.getAxisCrosses()));
            }
            if (valAx.getCrossBetween() != null) {
                poiValAx.setCrossBetween(PoiEnumConversion.toPoiAxisBetween(valAx.getCrossBetween()));
            }
            XDDFValueAxisHelper.setDelete((XDDFValueAxis)poiValAx, (!valAx.isVisible() ? 1 : 0) != 0);
            if (valAx.hasMajorGridline()) {
                XDDFValueAxisHelper.setMajorGridline((XDDFValueAxis)poiValAx, (boolean)valAx.hasMajorGridline());
            }
            if (valAx.getFormat() != null) {
                poiValAx.setNumberFormat(valAx.getFormat());
            }
            poiChart.getAxes().stream().filter(v -> v.getId() == valAx.getCrossAxisId()).findAny().ifPresent(v -> {
                v.crossAxis((XDDFChartAxis)poiValAx);
                poiValAx.crossAxis(v);
            });
        }
        poiChart.setPlotOnlyVisibleCells(chart.isPlotOnlyVisibleCells());
        boolean asGap = chart.isEmptyAsGaps();
        poiChart.displayBlanksAs(asGap ? DisplayBlanks.GAP : DisplayBlanks.ZERO);
    }

    protected ClientAnchor toClientAnchor(ViewAnchor viewAnchor, SSheet sheet) {
        ViewAnchor rightBottomAnchor = viewAnchor.getRightBottomAnchor(sheet);
        XSSFClientAnchor clientAnchor = new XSSFClientAnchor(UnitUtil.pxToEmu(viewAnchor.getXOffset()), UnitUtil.pxToEmu(viewAnchor.getYOffset()), UnitUtil.pxToEmu(rightBottomAnchor.getXOffset()), UnitUtil.pxToEmu(rightBottomAnchor.getYOffset()), viewAnchor.getColumnIndex(), viewAnchor.getRowIndex(), rightBottomAnchor.getColumnIndex(), rightBottomAnchor.getRowIndex());
        ViewAnchor.AnchorType anchorType = viewAnchor.getAnchorType();
        if (ViewAnchor.AnchorType.MOVE_DONT_RESIZE.equals((Object)anchorType)) {
            clientAnchor.setAnchorType(ClientAnchor.AnchorType.MOVE_DONT_RESIZE);
        } else if (ViewAnchor.AnchorType.DONT_MOVE_AND_RESIZE.equals((Object)anchorType)) {
            clientAnchor.setAnchorType(ClientAnchor.AnchorType.DONT_MOVE_AND_RESIZE);
        } else {
            clientAnchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
        }
        return clientAnchor;
    }

    protected void fillCategoryData(XSSFSheet sheet, SGeneralChartData chartData, XDDFChartData categoryData) {
        FormulaExpression expression = Optional.ofNullable(((GeneralChartDataImpl)chartData).getCategoriesFormulaExpression()).orElse(chartData.getNumOfSeries() > 0 ? ((SeriesImpl)chartData.getSeries(0)).getValuesFormulaExpression() : null);
        XDDFCategoryDataSource categories = expression == null ? null : ExcelXlsxExporter.getCategoryDataSource(expression, this.sbook, sheet);
        for (int i = 0; i < chartData.getNumOfSeries(); ++i) {
            SeriesImpl series = (SeriesImpl)chartData.getSeries(i);
            XDDFNumericalDataSource<? extends Number> values = ExcelXlsxExporter.getNumericDataSource(series.getXValuesFormulaExpression(), this.sbook, sheet);
            XDDFChartData.Series dataSerie = categoryData.addSeries((XDDFDataSource)categories, values);
            dataSerie.setTitle(series.getName());
            if (categoryData instanceof XDDFLineChartData) {
                ((XDDFLineChartData.Series)dataSerie).setSmooth(Boolean.valueOf(series.isSmooth()));
                if (((LineChartDataImpl)chartData).hasMarker() == Boolean.TRUE) {
                    ((XDDFLineChartData.Series)dataSerie).setMarkerStyle(MarkerStyle.CIRCLE);
                }
            } else if (categoryData instanceof XDDFLine3DChartData) {
                ((XDDFLine3DChartData.Series)dataSerie).setSmooth(Boolean.valueOf(series.isSmooth()));
                if (((LineChartDataImpl)chartData).hasMarker() == Boolean.TRUE) {
                    ((XDDFLine3DChartData.Series)dataSerie).setMarkerStyle(MarkerStyle.CIRCLE);
                }
            }
            if (series.getDefaultColor() != null) {
                XDDFShapeProperties shapeProperties = dataSerie.getShapeProperties();
                if (shapeProperties == null) {
                    shapeProperties = new XDDFShapeProperties();
                }
                shapeProperties.setFillProperties((XDDFFillProperties)new XDDFSolidFillProperties(XDDFColor.from((byte[])series.getDefaultColor().getRGB())));
                dataSerie.setShapeProperties(shapeProperties);
            }
            if (series.getDataPointColors() == null) continue;
            HashMap colors = new HashMap();
            for (Map.Entry<Integer, SColor> color : series.getDataPointColors().entrySet()) {
                dataSerie.getDataPoint((long)color.getKey().intValue()).setFillProperties((XDDFFillProperties)new XDDFSolidFillProperties(XDDFColor.from((byte[])color.getValue().getRGB())));
            }
        }
    }

    protected void fillXYData(XSSFSheet poiSheet, SGeneralChartData chartData, XDDFChartData xyData) {
        for (int i = 0; i < chartData.getNumOfSeries(); ++i) {
            String titleFormula;
            SeriesImpl series = (SeriesImpl)chartData.getSeries(i);
            XDDFCategoryDataSource xValues = ExcelXlsxExporter.getCategoryDataSource(series.getXValuesFormulaExpression(), this.sbook, poiSheet);
            XDDFNumericalDataSource<? extends Number> yValues = ExcelXlsxExporter.getNumericDataSource(series.getYValuesFormulaExpression(), this.sbook, poiSheet);
            XDDFChartData.Series dataSerie = xyData.addSeries((XDDFDataSource)xValues, yValues);
            SeriesImpl seriesAdv = series;
            if (((AbstractSeriesAdv)seriesAdv).getDefaultColor() != null) {
                XDDFShapeProperties shapeProperties = dataSerie.getShapeProperties();
                if (shapeProperties == null) {
                    shapeProperties = new XDDFShapeProperties();
                }
                shapeProperties.setFillProperties((XDDFFillProperties)new XDDFSolidFillProperties(XDDFColor.from((byte[])((AbstractSeriesAdv)seriesAdv).getDefaultColor().getRGB())));
                dataSerie.setShapeProperties(shapeProperties);
            }
            if (!Strings.isBlank(titleFormula = series.getNameFormula()) && !titleFormula.equals("\"\"")) {
                dataSerie.setTitle(series.getName(), new CellReference(series.getNameFormula()));
            } else {
                dataSerie.setTitle(series.getName());
            }
            if (((AbstractSeriesAdv)seriesAdv).getDataPointColors() == null) continue;
            for (Map.Entry<Integer, SColor> color : ((AbstractSeriesAdv)seriesAdv).getDataPointColors().entrySet()) {
                dataSerie.getDataPoint((long)color.getKey().intValue()).setFillProperties((XDDFFillProperties)new XDDFSolidFillProperties(XDDFColor.from((byte[])color.getValue().getRGB())));
            }
        }
    }

    private static XDDFCategoryDataSource getCategoryDataSource(FormulaExpression expression, SBook sBook, XSSFSheet poiSheet) {
        if (expression == null) {
            return null;
        }
        Ref[] areaRefs = expression.getAreaRefs();
        if (areaRefs == null) {
            EvaluationResult evaluationResult = ExcelXlsxExporter.evalDataSourceFormula(expression, sBook, poiSheet);
            if (evaluationResult.getType() == EvaluationResult.ResultType.SUCCESS) {
                return XDDFDataSourcesFactory.fromArray((String[])((List)evaluationResult.getValue()).toArray(new String[0]), (String)expression.getFormulaString());
            }
            return XDDFDataSourcesFactory.fromArray((String[])new String[0], (String)expression.getFormulaString());
        }
        if (areaRefs.length > 1) {
            return XDDFDataSourcesFactory.fromArray((String[])Arrays.stream(areaRefs).map(ref -> poiSheet.getWorkbook().getSheet(ref.getSheetName()).getRow(ref.getRow()).getCell(ref.getColumn()).getStringCellValue()).collect(Collectors.toList()).toArray(new String[0]), (String)expression.getFormulaString());
        }
        return XDDFDataSourcesFactory.fromStringCellRange((XSSFSheet)poiSheet.getWorkbook().getSheet(areaRefs[0].getSheetName()), (CellRangeAddress)new CellRangeAddress(areaRefs[0].getRow(), areaRefs[0].getLastRow(), areaRefs[0].getColumn(), areaRefs[0].getLastColumn()));
    }

    private static XDDFNumericalDataSource<? extends Number> getNumericDataSource(FormulaExpression expression, SBook sBook, XSSFSheet poiSheet) {
        if (expression == null) {
            return null;
        }
        Ref[] areaRefs = expression.getAreaRefs();
        if (areaRefs == null) {
            EvaluationResult evaluationResult = ExcelXlsxExporter.evalDataSourceFormula(expression, sBook, poiSheet);
            if (evaluationResult.getType() == EvaluationResult.ResultType.SUCCESS) {
                return XDDFDataSourcesFactory.fromArray((Number[])((Number[])evaluationResult.getValue()), (String)expression.getFormulaString());
            }
            return XDDFDataSourcesFactory.fromArray((Number[])new Number[0], (String)expression.getFormulaString());
        }
        if (areaRefs.length > 1) {
            return XDDFDataSourcesFactory.fromArray((Number[])Arrays.stream(areaRefs).map(ref -> poiSheet.getWorkbook().getSheet(ref.getSheetName()).getRow(ref.getRow()).getCell(ref.getColumn()).getNumericCellValue()).collect(Collectors.toList()).toArray(new Double[0]), (String)expression.getFormulaString());
        }
        return XDDFDataSourcesFactory.fromNumericCellRange((XSSFSheet)poiSheet.getWorkbook().getSheet(areaRefs[0].getSheetName()), (CellRangeAddress)new CellRangeAddress(areaRefs[0].getRow(), areaRefs[0].getLastRow(), areaRefs[0].getColumn(), areaRefs[0].getLastColumn()));
    }

    private static EvaluationResult evalDataSourceFormula(FormulaExpression formula, SBook sBook, XSSFSheet poiSheet) {
        SSheet sheet = sBook.getSheet(poiSheet.getWorkbook().getSheetIndex(poiSheet.getSheetName()));
        FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
        return fe.evaluate(formula, new FormulaEvaluationContext(sheet, (Ref)new ObjectRefImpl("", poiSheet.getSheetName(), "", ObjectRef.ObjectType.CHART)));
    }

    protected void fillXYZData(XSSFSheet poiSheet, SGeneralChartData chartData, XDDFBubbleChartData xyzData) {
        for (int i = 0; i < chartData.getNumOfSeries(); ++i) {
            SeriesImpl series = (SeriesImpl)chartData.getSeries(i);
            XDDFNumericalDataSource<? extends Number> xValues = ExcelXlsxExporter.getNumericDataSource(series.getXValuesFormulaExpression(), this.sbook, poiSheet);
            XDDFNumericalDataSource<? extends Number> yValues = ExcelXlsxExporter.getNumericDataSource(series.getYValuesFormulaExpression(), this.sbook, poiSheet);
            XDDFNumericalDataSource<? extends Number> zValues = ExcelXlsxExporter.getNumericDataSource(series.getZValuesFormulaExpression(), this.sbook, poiSheet);
            SeriesImpl seriesAdv = series;
            XDDFBubbleChartData.Series dataSerie = (XDDFBubbleChartData.Series)xyzData.addSeries(xValues, yValues);
            dataSerie.setTitle(series.getName());
            dataSerie.setBubbleSizes(zValues);
            if (((AbstractSeriesAdv)seriesAdv).getDefaultColor() != null) {
                XDDFShapeProperties shapeProperties = dataSerie.getShapeProperties();
                if (shapeProperties == null) {
                    shapeProperties = new XDDFShapeProperties();
                }
                shapeProperties.setFillProperties((XDDFFillProperties)new XDDFSolidFillProperties(XDDFColor.from((byte[])((AbstractSeriesAdv)seriesAdv).getDefaultColor().getRGB())));
                dataSerie.setShapeProperties(shapeProperties);
            }
            if (((AbstractSeriesAdv)seriesAdv).getDataPointColors() == null) continue;
            for (Map.Entry<Integer, SColor> color : ((AbstractSeriesAdv)seriesAdv).getDataPointColors().entrySet()) {
                dataSerie.getDataPoint((long)color.getKey().intValue()).setFillProperties((XDDFFillProperties)new XDDFSolidFillProperties(XDDFColor.from((byte[])color.getValue().getRGB())));
            }
        }
    }

    @Override
    protected void exportValidation(SSheet sheet, Sheet poiSheet) {
        this._exportPhase.setPhase("data validation");
        block10: for (SDataValidation validation : sheet.getDataValidations()) {
            int operatorType = PoiEnumConversion.toPoiOperatorType(validation.getOperatorType());
            String formula1 = ((AbstractDataValidationAdv)validation).getEscapedFormula1();
            String formula2 = ((AbstractDataValidationAdv)validation).getEscapedFormula2();
            DataValidationConstraint constraint = null;
            switch (validation.getValidationType()) {
                case TIME: {
                    constraint = poiSheet.getDataValidationHelper().createTimeConstraint(operatorType, formula1, formula2);
                    break;
                }
                case TEXT_LENGTH: {
                    constraint = poiSheet.getDataValidationHelper().createTextLengthConstraint(operatorType, formula1, formula2);
                    break;
                }
                case DATE: {
                    constraint = poiSheet.getDataValidationHelper().createDateConstraint(operatorType, formula1, formula2, "");
                    break;
                }
                case LIST: {
                    constraint = poiSheet.getDataValidationHelper().createFormulaListConstraint(formula1);
                    break;
                }
                case INTEGER: {
                    constraint = poiSheet.getDataValidationHelper().createIntegerConstraint(operatorType, formula1, formula2);
                    break;
                }
                case CUSTOM: {
                    constraint = poiSheet.getDataValidationHelper().createCustomConstraint(formula1);
                    break;
                }
                case DECIMAL: {
                    constraint = poiSheet.getDataValidationHelper().createDecimalConstraint(operatorType, formula1, formula2);
                    break;
                }
                case ANY: {
                    constraint = new XSSFDataValidationConstraint(0, null);
                    break;
                }
                default: {
                    continue block10;
                }
            }
            if (validation.getRegions().isEmpty()) continue;
            CellRangeAddressList rgnList = new CellRangeAddressList();
            for (CellRegion rgn : validation.getRegions()) {
                rgnList.addCellRangeAddress(rgn.getRow(), rgn.getColumn(), rgn.getLastRow(), rgn.getLastColumn());
            }
            DataValidation poiValidation = poiSheet.getDataValidationHelper().createValidation(constraint, rgnList);
            poiValidation.setEmptyCellAllowed(validation.isIgnoreBlank());
            poiValidation.setSuppressDropDownArrow(validation.isInCellDropdown());
            poiValidation.setErrorStyle(PoiEnumConversion.toPoiErrorStyle(validation.getAlertStyle()));
            poiValidation.createErrorBox(validation.getErrorTitle(), validation.getErrorMessage());
            poiValidation.setShowErrorBox(validation.isShowError());
            poiValidation.createPromptBox(validation.getInputTitle(), validation.getInputMessage());
            poiValidation.setShowPromptBox(validation.isShowInput());
            poiSheet.addValidationData(poiValidation);
        }
    }

    @Override
    protected void exportAutoFilter(SSheet sheet, Sheet poiSheet) {
        this._exportPhase.setPhase("auto filter");
        SAutoFilter autoFilter = sheet.getAutoFilter();
        if (autoFilter != null) {
            CellRegion region = autoFilter.getRegion();
            poiSheet.setAutoFilter(new CellRangeAddress(region.getRow(), region.getLastRow(), region.getColumn(), region.getLastColumn()));
            int numberOfColumn = region.getLastColumn() - region.getColumn() + 1;
            this.exportFilterColumns(XSSFSheetHelper.getCTAutoFilter((XSSFSheet)((XSSFSheet)poiSheet)), autoFilter, numberOfColumn);
        }
    }

    @Override
    protected void exportSheetPr(SSheet sheet, Sheet poiSheet) {
        String tabColor = sheet.getTabColor();
        if (tabColor != null && !tabColor.isEmpty()) {
            this._exportPhase.setPhase("tab color");
            ((XSSFSheet)poiSheet).setTabColor(new XSSFColor(UnitUtil.hexToArgbColor(tabColor.substring(1)), null));
        }
        this._exportPhase.setPhase("Outline");
        if (sheet.isApplyStyles()) {
            CTOutlinePr ctOutlinePr;
            CTWorksheet ctWorksheet = ((XSSFSheet)poiSheet).getCTWorksheet();
            CTSheetPr sheetPr = ctWorksheet.getSheetPr();
            if (sheetPr == null) {
                sheetPr = ctWorksheet.addNewSheetPr();
            }
            if ((ctOutlinePr = sheetPr.getOutlinePr()) == null) {
                ctOutlinePr = sheetPr.addNewOutlinePr();
            }
            ctOutlinePr.setApplyStyles(true);
        }
        if (!sheet.isSummaryBelow()) {
            poiSheet.setRowSumsBelow(false);
        }
        if (!sheet.isSummaryRight()) {
            poiSheet.setRowSumsRight(false);
        }
        if (!sheet.isShowOutlineSymbols()) {
            poiSheet.setDisplayGuts(false);
        }
        this._exportPhase.setPhase("sheet");
    }

    @Override
    protected void exportExtLst(SSheet sheet, Sheet poiSheet) {
        this._exportPhase.setPhase("extLst");
        List<SChart> charts = sheet.getCharts();
        for (SChart chart : charts) {
            if (!chart.isSparkline()) continue;
            AbstractChartAdv chartAdv = (AbstractChartAdv)chart;
            ViewAnchor anch = chart.getAnchor();
            XSSFSheetHelper.setSparkline((XSSFSheet)((XSSFSheet)poiSheet), (String)((SGeneralChartData)chart.getData()).getSeries(0).getValuesFormula(), (String)Converter.rangeToA1(anch.getRowIndex(), anch.getColumnIndex()), (String)chart.getType().name(), (boolean)chart.isWinloseSpark(), (boolean)chartAdv.isSparklineFirstPointVisible(), (boolean)chartAdv.isSparklineLastPointVisible(), (boolean)chartAdv.isSparklineHighPointVisible(), (boolean)chartAdv.isSparklineLowPointVisible(), (boolean)chartAdv.isSparklineNegativePointVisible(), (boolean)chartAdv.isSparklineMarkerVisible(), (String)chartAdv.getSparklineSeriesColor().getHtmlColor(), (String)chartAdv.getSparklineFirstPointColor().getHtmlColor(), (String)chartAdv.getSparklineLastPointColor().getHtmlColor(), (String)chartAdv.getSparklineHighPointColor().getHtmlColor(), (String)chartAdv.getSparklineLowPointColor().getHtmlColor(), (String)chartAdv.getSparklineNegativePointColor().getHtmlColor(), (String)chartAdv.getSparklineMarkerColor().getHtmlColor());
        }
    }

    protected void exportFilterColumns(CTAutoFilter poiAutoFilter, SAutoFilter autoFilter, int numberOfColumn) {
        HashMap<String, Object> extra = new HashMap<String, Object>();
        for (int i = 0; i < numberOfColumn; ++i) {
            STop10Filter top10Filter;
            SDynamicFilter dynamicFilter;
            SAutoFilter.NFilterColumn srcFilterColumn = autoFilter.getFilterColumn(i, false);
            if (srcFilterColumn == null) continue;
            XSSFFilterColumn destFilterColumn = null;
            if (poiAutoFilter.sizeOfFilterColumnArray() > i) {
                destFilterColumn = new XSSFFilterColumn(poiAutoFilter.getFilterColumnArray(i));
            } else {
                CTFilterColumn ctFilterColumn = poiAutoFilter.insertNewFilterColumn(i);
                destFilterColumn = new XSSFFilterColumn(ctFilterColumn);
                ctFilterColumn.setColId((long)i);
            }
            String[] criteria1 = null;
            if (srcFilterColumn.getCriteria1() != null) {
                criteria1 = srcFilterColumn.getCriteria1().toArray(new String[0]);
            }
            String[] criteria2 = null;
            if (srcFilterColumn.getCriteria1() != null) {
                criteria2 = srcFilterColumn.getCriteria2().toArray(new String[0]);
            }
            SColorFilter colorFilter = srcFilterColumn.getColorFilter();
            XSSFColorFilter poiFilter = null;
            if (colorFilter != null) {
                SExtraStyle extraStyle = colorFilter.getExtraStyle();
                this.addPOIDxfCellStyle(extraStyle);
                XSSFDxfCellStyle poiCellStyle = (XSSFDxfCellStyle)this.styleTable.get(extraStyle);
                poiFilter = new XSSFColorFilter((DxfCellStyle)poiCellStyle, colorFilter.isByFontColor());
            }
            extra.put("colorFilter", poiFilter);
            SCustomFilters customFilters = srcFilterColumn.getCustomFilters();
            if (customFilters != null) {
                XSSFCustomFilters poiCustomFilters = new XSSFCustomFilters(destFilterColumn);
                poiCustomFilters.setAnd(customFilters.isAnd());
                SCustomFilter srcFilter1 = customFilters.getCustomFilter1();
                SCustomFilter srcFilter2 = customFilters.getCustomFilter2();
                poiCustomFilters.addCustomFilter(this.toPOIOpertor(srcFilter1.getOperator()), srcFilter1.getValue());
                if (srcFilter2 != null) {
                    poiCustomFilters.addCustomFilter(this.toPOIOpertor(srcFilter2.getOperator()), srcFilter2.getValue());
                }
                extra.put("customFilters", poiCustomFilters);
            }
            if ((dynamicFilter = srcFilterColumn.getDynamicFilter()) != null) {
                XSSFDynamicFilter poiDynamicFilter = new XSSFDynamicFilter(destFilterColumn);
                poiDynamicFilter.setProperties(dynamicFilter.getMaxValue(), dynamicFilter.getValue(), dynamicFilter.getType());
                extra.put("dynamicFilter", poiDynamicFilter);
            }
            if ((top10Filter = srcFilterColumn.getTop10Filter()) != null) {
                XSSFTop10Filter poiTop10Filter = new XSSFTop10Filter(destFilterColumn);
                poiTop10Filter.setProperties(top10Filter.isTop(), top10Filter.getValue(), top10Filter.isPercent(), top10Filter.getFilterValue());
                extra.put("top10Filter", poiTop10Filter);
            }
            destFilterColumn.setProperties((Object)criteria1, PoiEnumConversion.toPoiFilterOperator(srcFilterColumn.getOperator()), (Object)criteria2, Boolean.valueOf(srcFilterColumn.isShowButton()), extra);
        }
    }

    private Set getCriteriaSet(Object criteria) {
        HashSet<String> set = new HashSet<String>();
        if (criteria instanceof String[]) {
            String[] strings = (String[])criteria;
            for (int j = 0; j < strings.length; ++j) {
                set.add(strings[j]);
            }
        }
        return set;
    }

    private void _setProperties(CTFilterColumn ctfc, Object criteria1, int filterOp, Object criteria2, Boolean visibleDropDown, Map<String, Object> extra) {
        int _operator = filterOp;
        Set _criteria1 = this.getCriteriaSet(criteria1);
        Set _criteria2 = this.getCriteriaSet(criteria2);
        boolean blank1 = _criteria1.contains("=");
        Pair _colorFilter = (Pair)extra.get("colorFilter");
        if (_colorFilter != null && ctfc.getColorFilter() == null) {
            CTColorFilter ctFilter = ctfc.addNewColorFilter();
            ctFilter.setDxfId((long)((DxfCellStyle)_colorFilter.getX()).getIndex());
            if (((Boolean)_colorFilter.getY()).booleanValue()) {
                ctFilter.setCellColor(false);
            } else if (ctFilter.isSetCellColor()) {
                ctFilter.unsetCellColor();
            }
        }
        if (visibleDropDown != null) {
            if (visibleDropDown.booleanValue()) {
                if (ctfc.isSetHiddenButton()) {
                    ctfc.unsetHiddenButton();
                }
            } else {
                ctfc.setHiddenButton(true);
            }
        }
        if (_criteria1.isEmpty()) {
            if (ctfc.isSetFilters()) {
                ctfc.unsetFilters();
            }
            return;
        }
        switch (_operator) {
            case 7: {
                String[] filters = (String[])criteria1;
                if (ctfc.isSetFilters()) {
                    ctfc.unsetFilters();
                }
                CTFilters cflts = ctfc.addNewFilters();
                if (blank1) {
                    cflts.setBlank(blank1);
                }
                for (int j = 0; j < filters.length; ++j) {
                    CTFilter cflt = cflts.addNewFilter();
                    cflt.setVal(filters[j]);
                }
                break;
            }
        }
    }

    private CustomFilter.Operator toPOIOpertor(SAutoFilter.FilterOp op) {
        return CustomFilter.Operator.valueOf((String)op.name());
    }

    @Override
    protected void exportPassword(SSheet sheet, Sheet poiSheet) {
        String hashValue = ((SheetImpl)sheet).getHashValue();
        if (hashValue != null) {
            String saltValue = ((SheetImpl)sheet).getSaltValue();
            String spinCount = ((SheetImpl)sheet).getSpinCount();
            String algName = ((SheetImpl)sheet).getAlgName();
            XSSFSheetHelper.setSheetPassword((XSSFSheet)((XSSFSheet)poiSheet), (String)saltValue, (String)hashValue, (String)spinCount, (String)algName);
        } else {
            short hashpass = sheet.getHashedPassword();
            if (hashpass != 0) {
                XSSFSheetHelper.setSheetPasswordHash((XSSFSheet)((XSSFSheet)poiSheet), (short)hashpass);
            }
        }
    }

    private XSSFWorkbook getWorkbook() {
        return (XSSFWorkbook)this.workbook;
    }

    @Override
    protected CellStyle toPOIDefaultCellStyle(SCellStyle cellStyle) {
        BorderStyle bottom = PoiEnumConversion.toPoiBorderType(cellStyle.getBorderBottom());
        BorderStyle left = PoiEnumConversion.toPoiBorderType(cellStyle.getBorderLeft());
        BorderStyle right = PoiEnumConversion.toPoiBorderType(cellStyle.getBorderRight());
        BorderStyle top = PoiEnumConversion.toPoiBorderType(cellStyle.getBorderTop());
        Color bottomColor = this.toPOIColor(cellStyle.getBorderBottomColor());
        Color leftColor = this.toPOIColor(cellStyle.getBorderLeftColor());
        Color rightColor = this.toPOIColor(cellStyle.getBorderRightColor());
        Color topColor = this.toPOIColor(cellStyle.getBorderTopColor());
        CTBorder ct = (CTBorder)CTBorder.Factory.newInstance();
        XSSFCellBorder border = new XSSFCellBorder(ct);
        border.setBorderStyle(XSSFCellBorder.BorderSide.LEFT, left);
        border.setBorderStyle(XSSFCellBorder.BorderSide.TOP, top);
        border.setBorderStyle(XSSFCellBorder.BorderSide.RIGHT, right);
        border.setBorderStyle(XSSFCellBorder.BorderSide.BOTTOM, bottom);
        if (left != BorderStyle.NONE) {
            border.setBorderColor(XSSFCellBorder.BorderSide.LEFT, (XSSFColor)leftColor);
        }
        if (top != BorderStyle.NONE) {
            border.setBorderColor(XSSFCellBorder.BorderSide.TOP, (XSSFColor)topColor);
        }
        if (right != BorderStyle.NONE) {
            border.setBorderColor(XSSFCellBorder.BorderSide.RIGHT, (XSSFColor)rightColor);
        }
        if (bottom != BorderStyle.NONE) {
            border.setBorderColor(XSSFCellBorder.BorderSide.BOTTOM, (XSSFColor)bottomColor);
        }
        SColor fgColor = cellStyle.getFillColor();
        SColor bgColor = cellStyle.getBackColor();
        if (cellStyle.getFillPattern() == SFill.FillPattern.SOLID) {
            SColor tmp = fgColor;
            fgColor = bgColor;
            bgColor = tmp;
        }
        Color fillColor = this.toPOIColor(fgColor);
        Color backColor = this.toPOIColor(bgColor);
        FillPatternType pattern = PoiEnumConversion.toPoiFillPattern(cellStyle.getFillPattern());
        CTFill ctf = (CTFill)CTFill.Factory.newInstance();
        XSSFCellFill fill = new XSSFCellFill(ctf, null);
        this.prepareFill(fill, fillColor, backColor, pattern);
        XSSFFont font = (XSSFFont)this.toPOIFont(cellStyle.getFont());
        XSSFDataFormat df = this.getWorkbook().createDataFormat();
        short fmt = df.getFormat(cellStyle.getDataFormat());
        XSSFCellStyle poiCellStyle = XSSFWorkbookHelper.createDefaultCellStyle((XSSFWorkbook)this.getWorkbook(), (XSSFCellBorder)border, (XSSFCellFill)fill, (XSSFFont)font, (int)fmt);
        HorizontalAlignment hAlign = PoiEnumConversion.toPoiHorizontalAlignment(cellStyle.getAlignment());
        VerticalAlignment vAlign = PoiEnumConversion.toPoiVerticalAlignment(cellStyle.getVerticalAlignment());
        boolean wrapText = cellStyle.isWrapText();
        ExcelXlsxExporter.setDefaultCellAlignment(poiCellStyle.getStyleXf(), hAlign, vAlign, wrapText);
        boolean locked = cellStyle.isLocked();
        boolean hidden = cellStyle.isHidden();
        poiCellStyle.setLocked(locked);
        poiCellStyle.setHidden(hidden);
        return poiCellStyle;
    }

    private static void setDefaultCellAlignment(CTXf _cellStyleXf, HorizontalAlignment hAlign, VerticalAlignment vAlign, boolean wrapText) {
        HorizontalAlignment defaultHAlign = HorizontalAlignment.GENERAL;
        VerticalAlignment defaultVAlign = VerticalAlignment.BOTTOM;
        boolean defaultWrapText = false;
        if (_cellStyleXf != null && _cellStyleXf.isSetAlignment()) {
            CTCellAlignment ctalign = _cellStyleXf.getAlignment();
            if (ctalign.isSetHorizontal()) {
                defaultHAlign = HorizontalAlignment.forInt((int)(ctalign.getHorizontal().intValue() - 1));
            }
            if (ctalign.isSetVertical()) {
                defaultVAlign = VerticalAlignment.forInt((int)(ctalign.getVertical().intValue() - 1));
            }
            if (ctalign.isSetWrapText()) {
                defaultWrapText = ctalign.getWrapText();
            }
        }
        if (defaultHAlign != hAlign && hAlign != HorizontalAlignment.GENERAL) {
            if (!_cellStyleXf.isSetAlignment()) {
                _cellStyleXf.setAlignment((CTCellAlignment)CTCellAlignment.Factory.newInstance());
            }
            _cellStyleXf.getAlignment().setHorizontal(STHorizontalAlignment.Enum.forInt((int)(hAlign.getCode() + 1)));
        }
        if (defaultVAlign != vAlign && vAlign != VerticalAlignment.BOTTOM) {
            if (!_cellStyleXf.isSetAlignment()) {
                _cellStyleXf.setAlignment((CTCellAlignment)CTCellAlignment.Factory.newInstance());
            }
            _cellStyleXf.getAlignment().setVertical(STVerticalAlignment.Enum.forInt((int)(vAlign.getCode() + 1)));
        }
        if (defaultWrapText != wrapText && wrapText) {
            if (!_cellStyleXf.isSetAlignment()) {
                _cellStyleXf.setAlignment((CTCellAlignment)CTCellAlignment.Factory.newInstance());
            }
            _cellStyleXf.getAlignment().setWrapText(wrapText);
        }
    }

    private void prepareFill(XSSFCellFill fill, Color fillColor, Color backColor, FillPatternType patternType) {
        boolean bcset;
        XSSFColor fc = (XSSFColor)fillColor;
        XSSFColor bc = (XSSFColor)backColor;
        String fHex = fc != null ? fc.getARGBHex() : null;
        String bHex = bc != null ? bc.getARGBHex() : null;
        boolean fcset = fHex != null && !"FF000000".equalsIgnoreCase(fHex);
        boolean bl = bcset = bHex != null && !"FFFFFFFF".equalsIgnoreCase(bHex);
        if (bcset || fcset) {
            fill.setFillForegroundColor(fc == null ? new XSSFColor(new byte[]{-1, -1, -1}) : fc);
        }
        if (bcset) {
            fill.setFillBackgroundColor(bc == null ? new XSSFColor(new byte[]{-1, -1, -1}) : bc);
        }
        fill.setPatternType(STPatternType.Enum.forInt((int)(patternType.getCode() + 1)));
    }

    @Override
    protected int exportTables(SSheet sheet, Sheet poiSheet0, int tbId) {
        XSSFSheet poiSheet = (XSSFSheet)poiSheet0;
        for (STable table : sheet.getTables()) {
            this._exportPhase.setPhase("table named %s");
            XSSFTable poiTable = poiSheet.createTable(new AreaReference(table.getAllRegion().getRegion().getReferenceString(), SpreadsheetVersion.EXCEL2007));
            poiTable.setName(table.getName());
            String displayName = table.getDisplayName();
            this._exportPhase.setTableName(displayName);
            poiTable.setDisplayName(displayName);
            CTTable ctTable = poiTable.getCTTable();
            if (table.getTotalsRowCount() == 0) {
                if (ctTable.isSetTotalsRowCount()) {
                    ctTable.unsetTotalsRowCount();
                }
            } else {
                ctTable.setTotalsRowCount((long)table.getTotalsRowCount());
            }
            if (table.getHeaderRowCount() == 0) {
                if (ctTable.isSetHeaderRowCount()) {
                    ctTable.unsetHeaderRowCount();
                }
            } else {
                ctTable.setHeaderRowCount((long)table.getHeaderRowCount());
            }
            this._exportPhase.setPhase("style of table named %s");
            XSSFTableStyleInfo poiInfo = new XSSFTableStyleInfo(this.getWorkbook().getStylesSource(), ctTable.addNewTableStyleInfo());
            STableStyleInfo info = table.getTableStyleInfo();
            poiInfo.setName(info.getName());
            poiInfo.setShowColumnStripes(info.isShowColumnStripes());
            poiInfo.setShowRowStripes(info.isShowRowStripes());
            poiInfo.setLastColumn(info.isShowLastColumn());
            poiInfo.setFirstColumn(info.isShowFirstColumn());
            this._exportPhase.setPhase("table named %s");
            SAutoFilter filter = table.getAutoFilter();
            if (filter != null) {
                this._exportPhase.setPhase("auto filter of table named %s");
                CellRegion region = filter.getRegion();
                CTAutoFilter ctAutoFilter = null;
                if (!(ctTable.isSetHeaderRowCount() && ctTable.getHeaderRowCount() == 0L || ctTable.isSetAutoFilter())) {
                    ctAutoFilter = ctTable.addNewAutoFilter();
                    if (ctTable.isSetAutoFilter()) {
                        ctAutoFilter.setRef(region.getReferenceString());
                    }
                }
                if (ctAutoFilter != null) {
                    this.exportFilterColumns(ctAutoFilter, filter, region.getColumnCount());
                }
                this._exportPhase.setPhase("table named %s");
            } else if (ctTable.isSetAutoFilter()) {
                ctTable.unsetAutoFilter();
            }
            int j = 0;
            List poiTableColumns = poiTable.getColumns();
            for (STableColumn tbCol : table.getColumns()) {
                this._exportPhase.setPhase("table column %s[%s]");
                String tbColName = tbCol.getName().trim();
                XSSFTableColumn poiTbCol = (XSSFTableColumn)poiTableColumns.get(j);
                this._exportPhase.setTableColumnName(tbColName);
                poiTbCol.setName(tbColName.replaceAll("\n", "_x000a_"));
                poiTbCol.setId((long)(++j));
                if (tbCol.getTotalsRowFunction() != null) {
                    XSSFTableColumnHelper.setTotalsRowFunction((XSSFTableColumn)poiTbCol, (XSSFTableColumnHelper.TotalsRowFunction)XSSFTableColumnHelper.TotalsRowFunction.values()[tbCol.getTotalsRowFunction().ordinal()]);
                }
                if (tbCol.getTotalsRowFunction() == STableColumn.STotalsRowFunction.none && tbCol.getTotalsRowLabel() != null) {
                    XSSFTableColumnHelper.setTotalsRowLabel((XSSFTableColumn)poiTbCol, (String)tbCol.getTotalsRowLabel());
                } else if (tbCol.getTotalsRowFunction() == STableColumn.STotalsRowFunction.custom && tbCol.getTotalsRowFormula() != null) {
                    XSSFTableColumnHelper.setTotalsRowFormula((XSSFTableColumn)poiTbCol, (String)tbCol.getTotalsRowFormula());
                }
                this._exportPhase.setTableColumnName(null);
            }
            this._exportPhase.setPhase("table named %s");
            ctTable.setId((long)(++tbId));
            this._exportPhase.setTableName(null);
            this._exportPhase.setPhase(null);
        }
        return tbId;
    }

    @Override
    protected void addPOIDxfCellStyle(SExtraStyle extraStyle) {
        String dataFormat;
        AbstractFillAdv fill;
        XSSFDxfCellStyle poiCellStyle = (XSSFDxfCellStyle)this.styleTable.get(extraStyle);
        if (poiCellStyle != null) {
            return;
        }
        poiCellStyle = XSSFWorkbookHelper.createDxfCellStyle((XSSFWorkbook)this.getWorkbook());
        if (extraStyle.getBorder() != null) {
            SBorder.BorderType btb = extraStyle.getBorderBottom();
            SBorder.BorderType btl = extraStyle.getBorderLeft();
            SBorder.BorderType btr = extraStyle.getBorderRight();
            SBorder.BorderType btt = extraStyle.getBorderTop();
            SBorder.BorderType btd = extraStyle.getBorderDiagonal();
            SBorder.BorderType bth = extraStyle.getBorderHorizontal();
            SBorder.BorderType btv = extraStyle.getBorderVertical();
            BorderStyle bottom = btb == null ? BorderStyle.NONE : PoiEnumConversion.toPoiBorderType(btb);
            BorderStyle left = btl == null ? BorderStyle.NONE : PoiEnumConversion.toPoiBorderType(btl);
            BorderStyle right = btr == null ? BorderStyle.NONE : PoiEnumConversion.toPoiBorderType(btr);
            BorderStyle top = btt == null ? BorderStyle.NONE : PoiEnumConversion.toPoiBorderType(btt);
            BorderStyle diagonal = btd == null ? BorderStyle.NONE : PoiEnumConversion.toPoiBorderType(btd);
            BorderStyle horizontal = bth == null ? BorderStyle.NONE : PoiEnumConversion.toPoiBorderType(bth);
            BorderStyle vertical = btv == null ? BorderStyle.NONE : PoiEnumConversion.toPoiBorderType(btv);
            Color bottomColor = this.toPOIColor(extraStyle.getBorderBottomColor());
            Color leftColor = this.toPOIColor(extraStyle.getBorderLeftColor());
            Color rightColor = this.toPOIColor(extraStyle.getBorderRightColor());
            Color topColor = this.toPOIColor(extraStyle.getBorderTopColor());
            Color diagonalColor = this.toPOIColor(extraStyle.getBorderDiagonalColor());
            Color horizontalColor = this.toPOIColor(extraStyle.getBorderHorizontalColor());
            Color verticalColor = this.toPOIColor(extraStyle.getBorderVerticalColor());
            boolean diaUp = extraStyle.isShowDiagonalUpBorder();
            boolean diaDn = extraStyle.isShowDiagonalDownBorder();
            poiCellStyle.setBorder(left, leftColor, top, topColor, right, rightColor, bottom, bottomColor, diagonal, diagonalColor, horizontal, horizontalColor, vertical, verticalColor, diaUp, diaDn);
        }
        if ((fill = (AbstractFillAdv)extraStyle.getFill()) != null) {
            SColor fgColor = fill.getRawFillColor();
            SColor bgColor = fill.getRawBackColor();
            SFill.FillPattern fillPattern = fill.getRawFillPattern();
            Color fillColor = fgColor == null ? null : this.toPOIColor(fgColor);
            Color backColor = bgColor == null ? null : this.toPOIColor(bgColor);
            short pattern = fillPattern == null ? (short)-1 : (short)PoiEnumConversion.toPoiFillPattern(extraStyle.getFillPattern()).getCode();
            poiCellStyle.setFill(fillColor, backColor, pattern);
        }
        if ((dataFormat = extraStyle.getDataFormat()) != null) {
            DataFormat df = this.workbook.createDataFormat();
            short fmt = df.getFormat(dataFormat);
            poiCellStyle.setDataFormat(fmt);
        }
        poiCellStyle.setFont(this.toPOIDxfFont(extraStyle.getFont()));
        this.styleTable.put(extraStyle, poiCellStyle);
    }

    protected Font toPOIDxfFont(SFont font0) {
        if (font0 == null) {
            return null;
        }
        XSSFFont poiFont = new XSSFFont((CTFont)CTFont.Factory.newInstance());
        AbstractFontAdv font = (AbstractFontAdv)font0;
        if (font.isOverrideBold()) {
            poiFont.setBold(PoiEnumConversion.toPoiBoldweight(font.getBoldweight()) == 700);
        }
        if (font.isOverrideStrikeout()) {
            poiFont.setStrikeout(font.isStrikeout());
        }
        if (font.isOverrideItalic()) {
            poiFont.setItalic(font.isItalic());
        }
        if (font.isOverrideColor()) {
            BookHelper.setFontColor(this.workbook, (Font)poiFont, this.toPOIColor(font.getColor()));
        }
        if (font.isOverrideHeightPoints()) {
            poiFont.setFontHeightInPoints((short)font.getHeightPoints());
        }
        if (font.isOverrideName()) {
            poiFont.setFontName(font.getName());
        }
        if (font.isOverrideTypeOffset()) {
            poiFont.setTypeOffset(PoiEnumConversion.toPoiTypeOffset(font.getTypeOffset()));
        }
        if (font.isOverrideUnderline()) {
            poiFont.setUnderline(PoiEnumConversion.toPoiUnderline(font.getUnderline()));
        }
        return poiFont;
    }

    @Override
    protected void exportConditionalFormatting(SSheet sheet, Sheet poiSheet) {
        this._exportPhase.setPhase("conditional formatting");
        List<SConditionalFormatting> formattings = sheet.getConditionalFormattings();
        XSSFSheet xssfSheet = (XSSFSheet)poiSheet;
        HashMap<CTCfRule, String> extRuleIdMap = new HashMap<CTCfRule, String>();
        for (SConditionalFormatting cf : formattings) {
            boolean isUnderExt = cf.isUnderExt();
            XSSFConditionalFormatting poicf = XSSFConditionalFormattingHelper.newXSSFConditionalFormatting((XSSFSheet)xssfSheet);
            CTConditionalFormatting ctcf = XSSFConditionalFormattingHelper.getCTConditionalFormatting((XSSFConditionalFormatting)poicf);
            this.addSqref(ctcf, cf);
            boolean isExtExpression = false;
            for (SConditionalFormattingRule rule : cf.getRules()) {
                CTCfRule ctRule = ctcf.addNewCfRule();
                if (!isExtExpression) {
                    boolean bl = isExtExpression = isUnderExt && rule.getType().equals((Object)SConditionalFormattingRule.RuleType.EXPRESSION);
                }
                if (isUnderExt && !isExtExpression) continue;
                this.addPoiRule(sheet, ctRule, rule);
                if (!isExtExpression) continue;
                extRuleIdMap.put(ctRule, rule.getId());
            }
            if (isExtExpression) {
                XSSFSheetHelper.addConditionalFormattingToExtensionList((XSSFSheet)xssfSheet, (ConditionalFormatting)poicf, extRuleIdMap);
            }
            if (isUnderExt) continue;
            xssfSheet.getSheetConditionalFormatting().addConditionalFormatting((ConditionalFormatting)poicf);
        }
    }

    protected void addSqref(CTConditionalFormatting ctcf, SConditionalFormatting cf) {
        StringBuilder sb = new StringBuilder();
        for (CellRegion rgn : cf.getRegions()) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(rgn.getReferenceString());
        }
        ArrayList<String> sqrefs = new ArrayList<String>();
        sqrefs.add(sb.toString());
        ctcf.setSqref(sqrefs);
    }

    protected void addPoiRule(SSheet sheet, CTCfRule ctRule, SConditionalFormattingRule rule) {
        SExtraStyle extraStyle;
        ctRule.setType(this.toConditionalFormattingRuleType(rule.getType()));
        Integer priority = rule.getPriority();
        if (priority != null) {
            ctRule.setPriority(priority.intValue());
        }
        if (rule.isStopIfTrue()) {
            ctRule.setStopIfTrue(true);
        }
        if ((extraStyle = rule.getExtraStyle()) != null) {
            this.addPOIDxfCellStyle(extraStyle);
            XSSFDxfCellStyle poiCellStyle = (XSSFDxfCellStyle)this.styleTable.get(extraStyle);
            short index = poiCellStyle.getIndex();
            if (index >= 0) {
                ctRule.setDxfId((long)index);
            }
        }
        switch (rule.getType()) {
            case ABOVE_AVERAGE: {
                if (!rule.isAboveAverage()) {
                    ctRule.setAboveAverage(false);
                }
                if (rule.isEqualAverage()) {
                    ctRule.setEqualAverage(true);
                }
                if (rule.getStandardDeviation() == null) break;
                ctRule.setStdDev(rule.getStandardDeviation().intValue());
                break;
            }
            case CELL_IS: {
                if (rule.getOperator() != null) {
                    ctRule.setOperator(this.toCFRuleOperator(rule.getOperator()));
                }
                this.addFormulas(ctRule, rule);
                break;
            }
            case COLOR_SCALE: {
                if (rule.getColorScale() == null) break;
                this.addColorScale(ctRule, rule);
                break;
            }
            case CONTAINS_BLANKS: 
            case NOT_CONTAINS_BLANKS: {
                this.addFormulas(ctRule, rule);
                break;
            }
            case CONTAINS_ERRORS: 
            case NOT_CONTAINS_ERRORS: {
                this.addFormulas(ctRule, rule);
                break;
            }
            case CONTAINS_TEXT: 
            case NOT_CONTAINS_TEXT: {
                if (rule.getText() != null) {
                    ctRule.setText(rule.getText());
                }
                if (rule.getOperator() != null) {
                    ctRule.setOperator(this.toCFRuleOperator(rule.getOperator()));
                }
                this.addFormulas(ctRule, rule);
                break;
            }
            case DATA_BAR: {
                if (rule.getDataBar() == null) break;
                this.addDataBar(ctRule, rule);
                break;
            }
            case BEGINS_WITH: 
            case ENDS_WITH: {
                if (rule.getText() != null) {
                    ctRule.setText(rule.getText());
                }
                if (rule.getOperator() != null) {
                    ctRule.setOperator(this.toCFRuleOperator(rule.getOperator()));
                }
                this.addFormulas(ctRule, rule);
                break;
            }
            case EXPRESSION: {
                this.addFormulas(ctRule, rule);
                break;
            }
            case ICON_SET: {
                if (rule.getIconSet() == null) break;
                this.addIconSet(ctRule, rule);
                break;
            }
            case TIME_PERIOD: {
                if (rule.getTimePeriod() != null) {
                    ctRule.setTimePeriod(this.toTimePeriod(rule.getTimePeriod()));
                }
                this.addFormulas(ctRule, rule);
                break;
            }
            case TOP_10: {
                if (rule.getRank() != null) {
                    ctRule.setRank(rule.getRank().longValue());
                }
                if (rule.isPercent()) {
                    ctRule.setPercent(true);
                }
                if (!rule.isBottom()) break;
                ctRule.setBottom(true);
                break;
            }
        }
        if (rule.getExtId() != null) {
            CTExtensionList ctExtensionList = ctRule.addNewExtLst();
            CTExtension ctExtension = ctExtensionList.addNewExt();
            XmlCursor cursor = ctExtension.newCursor();
            cursor.toNextToken();
            String x14NS = "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main";
            cursor.insertNamespace("x14", "http://schemas.microsoft.com/office/spreadsheetml/2009/9/main");
            cursor.insertAttributeWithValue("uri", "{B025F937-C7B1-47D3-B67F-A62EFF666E3E}");
            cursor.insertElementWithText(new QName("http://schemas.microsoft.com/office/spreadsheetml/2009/9/main", "id"), rule.getExtId());
        }
    }

    protected void addIconSet(CTCfRule ctRule, SConditionalFormattingRule rule) {
        CTIconSet ctIconSet = ctRule.addNewIconSet();
        SIconSet iconSet = rule.getIconSet();
        for (SCFValueObject vo : iconSet.getCFValueObjects()) {
            CTCfvo ctvo = ctIconSet.addNewCfvo();
            this.addValueObject(ctvo, vo);
        }
        ctIconSet.setIconSet(this.toIconSetType(iconSet.getType()));
        if (iconSet.isPercent()) {
            ctIconSet.setPercent(true);
        }
        if (iconSet.isReverse()) {
            ctIconSet.setReverse(true);
        }
        if (!iconSet.isShowValue()) {
            ctIconSet.setShowValue(false);
        }
    }

    protected void addColorScale(CTCfRule ctRule, SConditionalFormattingRule rule) {
        SColorScale colorScale = rule.getColorScale();
        CTColorScale ctColorScale = ctRule.addNewColorScale();
        for (SCFValueObject vo : colorScale.getCFValueObjects()) {
            CTCfvo ctvo = ctColorScale.addNewCfvo();
            this.addValueObject(ctvo, vo);
        }
        for (SColor color : colorScale.getColors()) {
            CTColor ctColor = ctColorScale.addNewColor();
            ctColor.setRgb(((AbstractColorAdv)color).getARGB());
        }
    }

    protected void addDataBar(CTCfRule ctRule, SConditionalFormattingRule rule) {
        CTDataBar ctDataBar = ctRule.addNewDataBar();
        SDataBar dataBar = rule.getDataBar();
        for (SCFValueObject vo : dataBar.getCFValueObjects()) {
            CTCfvo ctvo = ctDataBar.addNewCfvo();
            this.addValueObject(ctvo, vo);
        }
        CTColor ctColor = ctDataBar.addNewColor();
        ctColor.setRgb(((AbstractColorAdv)dataBar.getColor()).getARGB());
        if (dataBar.getMaxLength() != 90) {
            ctDataBar.setMaxLength((long)dataBar.getMaxLength());
        }
        if (dataBar.getMinLength() != 10) {
            ctDataBar.setMinLength((long)dataBar.getMinLength());
        }
        if (!dataBar.isShowValue()) {
            ctDataBar.setShowValue(false);
        }
    }

    protected void addFormulas(CTCfRule ctRule, SConditionalFormattingRule rule) {
        if (rule.getFormula1() != null) {
            ctRule.addFormula(rule.getFormula1().substring(1));
        }
        if (rule.getFormula2() != null) {
            ctRule.addFormula(rule.getFormula2().substring(1));
        }
        if (rule.getFormula3() != null) {
            ctRule.addFormula(rule.getFormula3().substring(1));
        }
    }

    protected void addValueObject(CTCfvo ctvo, SCFValueObject vo) {
        if (vo.isGreaterOrEqual() && ctvo.isSetGte()) {
            ctvo.unsetGte();
        }
        ctvo.setType(this.toValueObjectType(vo.getType()));
        if (vo.getValue() != null) {
            ctvo.setVal(vo.getValue());
        }
    }

    protected STTimePeriod.Enum toTimePeriod(SConditionalFormattingRule.RuleTimePeriod ctPeriod) {
        return STTimePeriod.Enum.forInt((int)ctPeriod.value);
    }

    protected STConditionalFormattingOperator.Enum toCFRuleOperator(SConditionalFormattingRule.RuleOperator ctType) {
        return STConditionalFormattingOperator.Enum.forInt((int)ctType.value);
    }

    protected STIconSetType.Enum toIconSetType(SIconSet.IconSetType ctType) {
        return STIconSetType.Enum.forInt((int)ctType.value);
    }

    protected STCfvoType.Enum toValueObjectType(SCFValueObject.CFValueObjectType ctType) {
        return STCfvoType.Enum.forInt((int)ctType.value);
    }

    protected STCfType.Enum toConditionalFormattingRuleType(SConditionalFormattingRule.RuleType cfType) {
        return STCfType.Enum.forInt((int)cfType.value);
    }

    protected STCfType.Enum toConditionalFormatingRuleType(SConditionalFormattingRule.RuleType stype) {
        return STCfType.Enum.forInt((int)stype.value);
    }

    @Override
    protected void addPOITableStyle(STableStyle tbStyle) {
        STableStyleElem lastTotalCell;
        STableStyleElem firstTotalCell;
        STableStyleElem lastHeaderCell;
        STableStyleElem firstHeaderCell;
        STableStyleElem totalRow;
        STableStyleElem headerRow;
        STableStyleElem firstColumn;
        STableStyleElem lastColumn;
        CTTableStyleElement ctTableStyleElement;
        STableStyleElem rowStripe2;
        STableStyleElem rowStripe1;
        STableStyleElem colStripe2;
        STableStyleElem colStripe1;
        XSSFTableStyle poiTbStyle = (XSSFTableStyle)this.tbStyleTable.get(tbStyle);
        StylesTable stylesSource = this.getWorkbook().getStylesSource();
        if (poiTbStyle != null) {
            StylesTableHelper.addTableStyle((StylesTable)stylesSource, (XSSFTableStyle)poiTbStyle);
            return;
        }
        poiTbStyle = (XSSFTableStyle)StylesTableHelper.createTableStyle((StylesTable)this.getWorkbook().getStylesSource(), (String)tbStyle.getName());
        STableStyleElem wholeTable = tbStyle.getWholeTableStyle();
        CTTableStyles tableStyles = stylesSource.getCTStylesheet().getTableStyles();
        CTTableStyle ctTableStyle = tableStyles.getTableStyleArray(poiTbStyle.getIndex());
        if (wholeTable != null) {
            int dxfId = this.getOrCreateDxfId(wholeTable);
            CTTableStyleElement ctTableStyleElement2 = ctTableStyle.addNewTableStyleElement();
            ctTableStyleElement2.setDxfId((long)dxfId);
            ctTableStyleElement2.setType(STTableStyleType.WHOLE_TABLE);
        }
        if ((colStripe1 = tbStyle.getColStripe1Style()) != null) {
            int colStripe1Size = tbStyle.getColStripe1Size();
            int dxfId = this.getOrCreateDxfId(colStripe1);
            CTTableStyleElement ctTableStyleElement3 = ctTableStyle.addNewTableStyleElement();
            ctTableStyleElement3.setDxfId((long)dxfId);
            ctTableStyleElement3.setType(STTableStyleType.FIRST_COLUMN_STRIPE);
            if (colStripe1Size > 1) {
                ctTableStyleElement3.setSize((long)colStripe1Size);
            }
        }
        if ((colStripe2 = tbStyle.getColStripe2Style()) != null) {
            int colStripe2Size = tbStyle.getColStripe2Size();
            int dxfId = this.getOrCreateDxfId(colStripe2);
            CTTableStyleElement ctTableStyleElement4 = ctTableStyle.addNewTableStyleElement();
            ctTableStyleElement4.setDxfId((long)dxfId);
            ctTableStyleElement4.setType(STTableStyleType.SECOND_COLUMN_STRIPE);
            if (colStripe2Size > 1) {
                ctTableStyleElement4.setSize((long)colStripe2Size);
            }
        }
        if ((rowStripe1 = tbStyle.getRowStripe1Style()) != null) {
            int rowStripe1Size = tbStyle.getRowStripe1Size();
            int dxfId = this.getOrCreateDxfId(rowStripe1);
            CTTableStyleElement ctTableStyleElement5 = ctTableStyle.addNewTableStyleElement();
            ctTableStyleElement5.setDxfId((long)dxfId);
            ctTableStyleElement5.setType(STTableStyleType.FIRST_ROW_STRIPE);
            if (rowStripe1Size > 1) {
                ctTableStyleElement5.setSize((long)rowStripe1Size);
            }
        }
        if ((rowStripe2 = tbStyle.getRowStripe2Style()) != null) {
            int rowStripe2Size = tbStyle.getRowStripe2Size();
            int dxfId = this.getOrCreateDxfId(rowStripe2);
            ctTableStyleElement = ctTableStyle.addNewTableStyleElement();
            ctTableStyleElement.setDxfId((long)dxfId);
            ctTableStyleElement.setType(STTableStyleType.SECOND_ROW_STRIPE);
            if (rowStripe2Size > 1) {
                ctTableStyleElement.setSize((long)rowStripe2Size);
            }
        }
        if ((lastColumn = tbStyle.getLastColumnStyle()) != null) {
            int dxfId = this.getOrCreateDxfId(lastColumn);
            ctTableStyleElement = ctTableStyle.addNewTableStyleElement();
            ctTableStyleElement.setDxfId((long)dxfId);
            ctTableStyleElement.setType(STTableStyleType.LAST_COLUMN);
        }
        if ((firstColumn = tbStyle.getFirstColumnStyle()) != null) {
            int dxfId = this.getOrCreateDxfId(firstColumn);
            CTTableStyleElement ctTableStyleElement6 = ctTableStyle.addNewTableStyleElement();
            ctTableStyleElement6.setDxfId((long)dxfId);
            ctTableStyleElement6.setType(STTableStyleType.FIRST_COLUMN);
        }
        if ((headerRow = tbStyle.getHeaderRowStyle()) != null) {
            int dxfId = this.getOrCreateDxfId(headerRow);
            CTTableStyleElement ctTableStyleElement7 = ctTableStyle.addNewTableStyleElement();
            ctTableStyleElement7.setDxfId((long)dxfId);
            ctTableStyleElement7.setType(STTableStyleType.HEADER_ROW);
        }
        if ((totalRow = tbStyle.getTotalRowStyle()) != null) {
            int dxfId = this.getOrCreateDxfId(totalRow);
            CTTableStyleElement ctTableStyleElement8 = ctTableStyle.addNewTableStyleElement();
            ctTableStyleElement8.setDxfId((long)dxfId);
            ctTableStyleElement8.setType(STTableStyleType.TOTAL_ROW);
        }
        if ((firstHeaderCell = tbStyle.getFirstHeaderCellStyle()) != null) {
            int dxfId = this.getOrCreateDxfId(firstHeaderCell);
            CTTableStyleElement ctTableStyleElement9 = ctTableStyle.addNewTableStyleElement();
            ctTableStyleElement9.setDxfId((long)dxfId);
            ctTableStyleElement9.setType(STTableStyleType.FIRST_HEADER_CELL);
        }
        if ((lastHeaderCell = tbStyle.getLastHeaderCellStyle()) != null) {
            int dxfId = this.getOrCreateDxfId(lastHeaderCell);
            CTTableStyleElement ctTableStyleElement10 = ctTableStyle.addNewTableStyleElement();
            ctTableStyleElement10.setDxfId((long)dxfId);
            ctTableStyleElement10.setType(STTableStyleType.LAST_HEADER_CELL);
        }
        if ((firstTotalCell = tbStyle.getFirstTotalCellStyle()) != null) {
            int dxfId = this.getOrCreateDxfId(firstTotalCell);
            CTTableStyleElement ctTableStyleElement11 = ctTableStyle.addNewTableStyleElement();
            ctTableStyleElement11.setDxfId((long)dxfId);
            ctTableStyleElement11.setType(STTableStyleType.FIRST_TOTAL_CELL);
        }
        if ((lastTotalCell = tbStyle.getLastTotalCellStyle()) != null) {
            int dxfId = this.getOrCreateDxfId(lastTotalCell);
            CTTableStyleElement ctTableStyleElement12 = ctTableStyle.addNewTableStyleElement();
            ctTableStyleElement12.setDxfId((long)dxfId);
            ctTableStyleElement12.setType(STTableStyleType.LAST_TOTAL_CELL);
        }
        this.tbStyleTable.put(tbStyle, poiTbStyle);
    }

    protected int getOrCreateDxfId(STableStyleElem tbStyleElem) {
        int index = this.getOrCreateDxfId0(tbStyleElem);
        if (index < 0) {
            this.addPOIDxfCellStyle(tbStyleElem);
            return this.getOrCreateDxfId0(tbStyleElem);
        }
        return index;
    }

    private int getOrCreateDxfId0(STableStyleElem tbStyleElem) {
        XSSFDxfCellStyle poiCellStyle = (XSSFDxfCellStyle)this.styleTable.get(tbStyleElem);
        if (poiCellStyle != null) {
            return poiCellStyle.getDxfIndex();
        }
        return -1;
    }

    @Override
    protected RichTextString toPOIRichText(SRichText richText) {
        CreationHelper helper = this.workbook.getCreationHelper();
        XSSFRichTextString poiRichTextString = (XSSFRichTextString)helper.createRichTextString(richText.getText());
        for (SRichText.Segment sg : richText.getSegments()) {
            SFont font = sg.getFont();
            String text = sg.getText();
            CTRst st = poiRichTextString.getCTRst();
            if (st.sizeOfRArray() == 0 && st.isSetT()) {
                st.unsetT();
            }
            XSSFRichTextStringHelper.addRun((XSSFRichTextString)poiRichTextString, (String)text, (XSSFFont)((XSSFFont)this.toPOIFont(font)));
        }
        return poiRichTextString;
    }

    @Override
    protected void exportWorkbookProtection(SWorkbookProtection workbookProtection) {
        WorkbookProtectionImpl protectionImpl = (WorkbookProtectionImpl)workbookProtection;
        XSSFWorkbook xBook = this.getWorkbook();
        if (protectionImpl.isLockStructure() != null) {
            if (protectionImpl.isLockStructure().booleanValue()) {
                xBook.lockStructure();
            } else {
                xBook.unLockStructure();
            }
        }
        if (protectionImpl.isLockWindows() != null) {
            if (protectionImpl.isLockWindows().booleanValue()) {
                xBook.lockWindows();
            } else {
                xBook.unLockWindows();
            }
        }
        if (protectionImpl.getAlgName() != null) {
            XSSFWorkbookHelper.setAlgName((XSSFWorkbook)xBook, (String)protectionImpl.getAlgName());
        }
        if (protectionImpl.getHashValue() != null) {
            XSSFWorkbookHelper.setHashValue((XSSFWorkbook)xBook, (String)protectionImpl.getHashValue());
        }
        if (protectionImpl.getSaltValue() != null) {
            XSSFWorkbookHelper.setSaltValue((XSSFWorkbook)xBook, (String)protectionImpl.getSaltValue());
        }
        if (protectionImpl.getSpinCount() != null) {
            XSSFWorkbookHelper.setSpinCount((XSSFWorkbook)xBook, (String)protectionImpl.getSpinCount());
        }
    }

    @Override
    protected void exportRowColumn(SSheet sheet, Sheet poiSheet) {
        super.exportRowColumn(sheet, poiSheet);
        poiSheet.setActiveCell(new CellAddress(sheet.getViewInfo().getActiveCell()));
        CTSelection selectionArray = ((XSSFSheet)poiSheet).getCTWorksheet().getSheetViews().getSheetViewArray(0).getSelectionArray(0);
        selectionArray.setSqref(Arrays.asList(sheet.getViewInfo().getSelectionAreas().split(" ")));
    }
}

