/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl.imexp;

import io.keikai.importer.XlsxImporter;
import io.keikai.model.SBook;
import io.keikai.range.impl.imexp.AbstractImporter;
import io.keikai.range.impl.imexp.ExcelXlsImporter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.zkoss.lang.Library;

public class ExcelImportAdapter
extends AbstractImporter {
    @Override
    public SBook imports(InputStream is, String bookName) throws IOException {
        if (!is.markSupported()) {
            is = new BufferedInputStream(is, 8);
        }
        AbstractImporter importer = null;
        if (FileMagic.valueOf((InputStream)is) == FileMagic.OLE2) {
            importer = new ExcelXlsImporter();
        } else if (FileMagic.valueOf((InputStream)is) == FileMagic.OOXML) {
            importer = new XlsxImporter();
        }
        if (importer != null) {
            importer.setImportCache(this.isImportCache());
            return importer.imports(is, bookName);
        }
        throw new IllegalArgumentException("The input stream to be imported is neither an OLE2 stream, nor an OOXML stream");
    }

    @Override
    protected boolean isImportCache() {
        String importCache = Optional.ofNullable(Library.getProperty((String)"io.keikai.import.cache")).orElse(Library.getProperty((String)"org.zkoss.zss.import.cache", (String)"false"));
        return "true".equalsIgnoreCase(importCache.trim());
    }
}

