/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl.imexp;

import io.keikai.model.SBook;
import io.keikai.range.SImporter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractImporter
implements SImporter {
    private static final Logger log = LoggerFactory.getLogger(AbstractImporter.class);
    public static String BOOK_TYPE_KEY = "$KK.BOOKTYPE$";
    protected boolean _importCache = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SBook imports(File file, String bookName) throws IOException {
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            SBook sBook = this.imports(is, bookName);
            return sBook;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    log.error("Failed to close input stream", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SBook imports(URL url, String bookName) throws IOException {
        InputStream is = null;
        try {
            is = url.openStream();
            SBook sBook = this.imports(is, bookName);
            return sBook;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    log.error("Failed to close input stream", (Throwable)e);
                }
            }
        }
    }

    public void setImportCache(boolean b) {
        this._importCache = b;
    }

    protected boolean isImportCache() {
        return this._importCache;
    }
}

