/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl.imexp;

import io.keikai.model.SBook;
import io.keikai.model.SSheet;
import io.keikai.model.SheetRegion;
import io.keikai.range.SExporter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExporter
implements SExporter,
Serializable {
    private static final long serialVersionUID = -3401645352937439291L;
    private static final Logger log = LoggerFactory.getLogger(AbstractExporter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(SBook book, File file) throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            this.export(book, (OutputStream)os);
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (Exception e) {
                    log.error("Failed to close output stream", (Throwable)e);
                }
            }
        }
    }

    public void export(SSheet sheet, OutputStream fos) throws IOException {
        throw new UnsupportedOperationException("doesn't support this api");
    }

    public void export(SheetRegion sheetRegion, OutputStream fos) throws IOException {
        throw new UnsupportedOperationException("doesn't support this api");
    }
}

