/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl.imexp;

import io.keikai.model.CellRegion;
import io.keikai.model.SBook;
import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SColor;
import io.keikai.model.SColumnArray;
import io.keikai.model.SComment;
import io.keikai.model.SExtraStyle;
import io.keikai.model.SFill;
import io.keikai.model.SFont;
import io.keikai.model.SFooter;
import io.keikai.model.SHeader;
import io.keikai.model.SHyperlink;
import io.keikai.model.SName;
import io.keikai.model.SNamedStyle;
import io.keikai.model.SPictureData;
import io.keikai.model.SPrintSetup;
import io.keikai.model.SRichText;
import io.keikai.model.SRow;
import io.keikai.model.SSheet;
import io.keikai.model.SSheetProtection;
import io.keikai.model.SSheetViewInfo;
import io.keikai.model.STableStyle;
import io.keikai.model.SWorkbookProtection;
import io.keikai.model.SheetRegion;
import io.keikai.model.impl.AbstractBookAdv;
import io.keikai.model.impl.ColumnArrayImpl;
import io.keikai.model.impl.TableNameImpl;
import io.keikai.model.sys.EngineFactory;
import io.keikai.model.sys.format.FormatContext;
import io.keikai.model.sys.format.FormatEngine;
import io.keikai.model.util.Strings;
import io.keikai.range.impl.imexp.AbstractExporter;
import io.keikai.range.impl.imexp.BookHelper;
import io.keikai.range.impl.imexp.ExportException;
import io.keikai.range.impl.imexp.ExportPhase;
import io.keikai.range.impl.imexp.PoiEnumConversion;
import io.keikai.range.impl.imexp.UnitUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ooxml.POIXMLDocumentPartHelper;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Color;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.NamedStyle;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetProtection;
import org.apache.poi.ss.usermodel.SheetVisibility;
import org.apache.poi.ss.usermodel.TableStyle;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.ZssContext;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.model.ExternalLinksTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFPrintSetup;
import org.apache.poi.xssf.usermodel.XSSFPrintSetupHelper;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFSheetHelper;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbookHelper;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTExternalReference;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTExternalReferences;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRow;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetFormatPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExcelExporter
extends AbstractExporter {
    private static final long serialVersionUID = -453628222967064565L;
    protected static final int DEFAULT_ROW_HEIGHT = 20;
    protected Workbook workbook;
    protected SBook sbook;
    protected Map<SCellStyle, CellStyle> styleTable = new HashMap<SCellStyle, CellStyle>();
    protected Map<SFont, Font> fontTable = new HashMap<SFont, Font>();
    protected Map<SColor, Color> colorTable = new HashMap<SColor, Color>();
    protected Map<Integer, Integer> exportedPicDataMap = new HashMap<Integer, Integer>();
    protected Map<STableStyle, TableStyle> tbStyleTable = new HashMap<STableStyle, TableStyle>();
    private static final Logger _logger = LoggerFactory.getLogger(AbstractExcelExporter.class);
    protected ExportPhase _exportPhase;
    protected boolean _exportCache = false;

    protected abstract void exportColumnArray(SSheet var1, Sheet var2, SColumnArray var3);

    protected abstract Workbook createPoiBook();

    protected abstract void exportWorkbookProtection(SWorkbookProtection var1);

    protected abstract void exportChart(SSheet var1, Sheet var2);

    protected abstract void exportPicture(SSheet var1, Sheet var2);

    protected abstract void exportValidation(SSheet var1, Sheet var2);

    protected abstract void exportAutoFilter(SSheet var1, Sheet var2);

    protected abstract void exportSheetPr(SSheet var1, Sheet var2);

    protected abstract void exportExtLst(SSheet var1, Sheet var2);

    protected abstract void exportPassword(SSheet var1, Sheet var2);

    protected abstract int exportTables(SSheet var1, Sheet var2, int var3);

    protected abstract void exportConditionalFormatting(SSheet var1, Sheet var2);

    @Override
    public void export(SBook book, OutputStream fos) throws IOException {
        ReadWriteLock lock = book.getBookSeries().getLock();
        lock.readLock().lock();
        try {
            boolean selectedSheetExisted;
            int n;
            this.clearCache();
            this._exportPhase = new ExportPhase(book.getBookName());
            this.workbook = this.createPoiBook();
            this.sbook = book;
            List<SBook> books = book.getBookSeries().getBooks();
            if (!books.isEmpty() && this.workbook instanceof XSSFWorkbook) {
                books.forEach(sbook -> this.workbook.linkExternalWorkbook(sbook.getBookName().replace(" ", "+"), this.createPoiBook()));
            }
            this._exportPhase.setPhase("cell style");
            if (this.workbook instanceof XSSFWorkbook) {
                XSSFWorkbook xssfWorkbook = (XSSFWorkbook)this.workbook;
                XSSFWorkbookHelper.clearDefaultCellStyles((XSSFWorkbook)xssfWorkbook);
                for (SCellStyle sCellStyle : book.getDefaultCellStyles()) {
                    this.toPOIDefaultCellStyle(sCellStyle);
                    this.toPOICellStyle(sCellStyle);
                }
                this._exportPhase.setPhase("named cell style");
                XSSFWorkbookHelper.clearNamedStyles((XSSFWorkbook)xssfWorkbook);
                XSSFWorkbookHelper.addNamedStyles((XSSFWorkbook)xssfWorkbook, book.getNamedStyles().stream().map(this::toPOINamedStyle).collect(Collectors.toList()));
                this._exportPhase.setPhase("dxf cell style");
                XSSFWorkbookHelper.clearDxfCellStyles((XSSFWorkbook)xssfWorkbook);
                for (SExtraStyle sExtraStyle : book.getExtraStyles()) {
                    this.addPOIDxfCellStyle(sExtraStyle);
                }
                this._exportPhase.setPhase("workbook table style");
                XSSFWorkbookHelper.setDefaultPivotStyle((XSSFWorkbook)xssfWorkbook, (String)book.getDefaultPivotStyleName());
                XSSFWorkbookHelper.setDefaultTableStyle((XSSFWorkbook)xssfWorkbook, (String)book.getDefaultTableStyleName());
                XSSFWorkbookHelper.clearTableStyles((XSSFWorkbook)xssfWorkbook);
                for (STableStyle sTableStyle : book.getTableStyles()) {
                    this.addPOITableStyle(sTableStyle);
                }
            }
            this._exportPhase.setPhase("workbook protection");
            this.exportWorkbookProtection(book.getWorkbookProtection());
            int tbId = 0;
            this._exportPhase.setPhase("sheets");
            int firstVisibleSheetIndex = -1;
            int n2 = -1;
            for (int n3 = 0; n3 < book.getSheets().size(); ++n3) {
                SSheet sheet = book.getSheet(n3);
                this.exportSheet(sheet);
                if (SSheet.SheetVisible.VISIBLE.equals((Object)sheet.getSheetVisible())) {
                    if (firstVisibleSheetIndex == -1) {
                        firstVisibleSheetIndex = n3;
                    }
                    if (n == -1 && sheet.getViewInfo().isTabSelected()) {
                        n = n3;
                    }
                }
                Sheet poiSheet = this.workbook.getSheetAt(n3);
                tbId = this.exportTables(sheet, poiSheet, tbId);
                this.exportConditionalFormatting(sheet, poiSheet);
                this._exportPhase.setSheetName(null);
            }
            boolean bl = selectedSheetExisted = n != -1;
            if (selectedSheetExisted || firstVisibleSheetIndex != -1) {
                this._exportPhase.setPhase("sheet active");
                this.workbook.setActiveSheet(selectedSheetExisted ? n : firstVisibleSheetIndex);
            }
            this._exportPhase.setPhase("named range");
            this.exportNamedRange(book);
            this._exportPhase.setPhase("workbook picture data");
            this.exportPictureData(book);
            for (int n4 = 0; n4 < book.getSheets().size(); ++n4) {
                this._exportPhase.setPhase("sheet");
                SSheet sheet = book.getSheet(n4);
                this._exportPhase.setSheetName(sheet.getSheetName());
                Sheet poiSheet = this.workbook.getSheetAt(n4);
                if (poiSheet instanceof XSSFSheet) {
                    XSSFSheet xssfSheet = (XSSFSheet)poiSheet;
                    CTWorksheet ctSheet = xssfSheet.getCTWorksheet();
                    CTSheetFormatPr ctSheetFormatPr = ctSheet.getSheetFormatPr();
                    if (ctSheetFormatPr == null) {
                        ctSheetFormatPr = ctSheet.addNewSheetFormatPr();
                    }
                    if (sheet.getOutlineLevelRow() > 0) {
                        ctSheetFormatPr.setOutlineLevelRow((short)sheet.getOutlineLevelRow());
                    }
                    if (sheet.getOutlineLevelCol() > 0) {
                        ctSheetFormatPr.setOutlineLevelCol((short)sheet.getOutlineLevelCol());
                    }
                }
                this.exportRowColumn(sheet, poiSheet);
                this.exportMergedRegions(sheet, poiSheet);
                this.exportChart(sheet, poiSheet);
                this.exportPicture(sheet, poiSheet);
                this.exportValidation(sheet, poiSheet);
                this.exportAutoFilter(sheet, poiSheet);
                this.exportExtLst(sheet, poiSheet);
                this._exportPhase.setSheetName(null);
            }
            this._exportPhase.setPhase("write workbook");
            if (!books.isEmpty() && this.workbook instanceof XSSFWorkbook) {
                XSSFWorkbook xssfWorkbook = (XSSFWorkbook)this.workbook;
                List relationParts = xssfWorkbook.getRelationParts();
                CTExternalReferences externalReferences = xssfWorkbook.getCTWorkbook().getExternalReferences();
                block10: for (SBook sbook2 : books) {
                    CTExternalReference[] externalReferenceArray = externalReferences.getExternalReferenceArray();
                    for (POIXMLDocumentPart.RelationPart relationPart : relationParts) {
                        ExternalLinksTable linksTable;
                        String linkedFileName;
                        if (!(relationPart.getDocumentPart() instanceof ExternalLinksTable) || !(linkedFileName = (linksTable = (ExternalLinksTable)relationPart.getDocumentPart()).getLinkedFileName()).equals(sbook2.getBookName())) continue;
                        for (int i = 0; i < externalReferenceArray.length; ++i) {
                            if (!externalReferenceArray[i].getId().equals(relationPart.getRelationship().getId())) continue;
                            externalReferences.removeExternalReference(i);
                            break;
                        }
                        POIXMLDocumentPartHelper.removeRelation((POIXMLDocumentPart)xssfWorkbook, (POIXMLDocumentPart)relationPart.getDocumentPart());
                        continue block10;
                    }
                }
                if (externalReferences.sizeOfExternalReferenceArray() == 0) {
                    xssfWorkbook.getCTWorkbook().unsetExternalReferences();
                }
            }
            this.workbook.write(fos);
        }
        catch (RuntimeException e) {
            throw new ExportException("Fail to export " + this._exportPhase.toString(), e);
        }
        finally {
            lock.readLock().unlock();
            this.clearCache();
        }
    }

    private void clearCache() {
        this.styleTable.clear();
        this.fontTable.clear();
        this.colorTable.clear();
        this.tbStyleTable.clear();
        this._exportPhase = null;
        this.workbook = null;
        this.sbook = null;
    }

    protected void exportPictureData(SBook book) {
        for (SPictureData picData : book.getPicturesDatas()) {
            int poiIndex = this.workbook.addPicture(picData.getData(), PoiEnumConversion.toPoiPictureFormat(picData.getFormat()));
            this.exportedPicDataMap.put(picData.getIndex(), poiIndex);
        }
    }

    protected void exportNamedRange(SBook book) {
        for (SName name : book.getNames()) {
            if (name instanceof TableNameImpl || name.getName().startsWith("_xlnm.")) continue;
            Name poiName = this.workbook.createName();
            try {
                String sheetName = name.getApplyToSheetName();
                if (sheetName != null) {
                    poiName.setSheetIndex(this.workbook.getSheetIndex(sheetName));
                }
                poiName.setNameName(name.getName());
                if (name.isFormulaParsingError()) continue;
                poiName.setRefersToFormula(name.getRefersToFormula());
            }
            catch (Exception e) {
                _logger.warn("Cannot export a name range: " + name.getName(), (Throwable)e);
                if (poiName.getNameName() == null) continue;
                this.workbook.removeName(poiName);
            }
        }
    }

    protected void exportSheet(SSheet sheet) {
        CellRegion crgn;
        CellRegion rgn;
        int n;
        this._exportPhase.setPhase("sheet");
        String sheetName = sheet.getSheetName();
        this._exportPhase.setSheetName(sheetName);
        Sheet poiSheet = this.workbook.createSheet(sheetName);
        this.exportSheetPr(sheet, poiSheet);
        this._exportPhase.setPhase("sheet view");
        SSheetViewInfo viewInfo = sheet.getViewInfo();
        int freezeRow = viewInfo.getNumOfRowFreeze();
        int freezeCol = viewInfo.getNumOfColumnFreeze();
        poiSheet.createFreezePane(freezeCol <= 0 ? 0 : freezeCol, freezeRow <= 0 ? 0 : freezeRow);
        poiSheet.setDisplayGridlines(viewInfo.isDisplayGridlines());
        int[] nArray = viewInfo.getRowBreaks();
        int n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            Integer rowIndex = nArray[n];
            poiSheet.setRowBreak(rowIndex.intValue());
        }
        nArray = viewInfo.getColumnBreaks();
        n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            Integer colIndex = nArray[n];
            poiSheet.setColumnBreak(colIndex.intValue());
        }
        poiSheet.setSelected(viewInfo.isTabSelected());
        this._exportPhase.setPhase("sheet protection");
        this.exportSheetProtection(sheet, poiSheet);
        if (sheet.isProtected()) {
            if (this.workbook.getSpreadsheetVersion() == SpreadsheetVersion.EXCEL97) {
                poiSheet.protectSheet("");
            } else {
                XSSFSheetHelper.protectSheet((XSSFSheet)((XSSFSheet)poiSheet), (String)"");
            }
            this.exportPassword(sheet, poiSheet);
        } else if (poiSheet instanceof XSSFSheet) {
            XSSFSheetHelper.unsetSheetProtection((XSSFSheet)((XSSFSheet)poiSheet));
        } else {
            poiSheet.protectSheet(null);
        }
        this._exportPhase.setPhase("sheet format");
        poiSheet.setDefaultRowHeight((short)UnitUtil.pxToTwip(sheet.getDefaultRowHeight()));
        AbstractBookAdv book = (AbstractBookAdv)sheet.getBook();
        poiSheet.setDefaultColumnWidth(UnitUtil.pxToDefaultColumnWidth(sheet.getDefaultColumnWidth(), book.getCharWidth()));
        this._exportPhase.setPhase("sheet header");
        Header header = poiSheet.getHeader();
        header.setLeft(viewInfo.getHeader().getLeftText());
        header.setCenter(viewInfo.getHeader().getCenterText());
        header.setRight(viewInfo.getHeader().getRightText());
        this._exportPhase.setPhase("sheet footer");
        Footer footer = poiSheet.getFooter();
        footer.setLeft(viewInfo.getFooter().getLeftText());
        footer.setCenter(viewInfo.getFooter().getCenterText());
        footer.setRight(viewInfo.getFooter().getRightText());
        SPrintSetup sps = sheet.getPrintSetup();
        this._exportPhase.setPhase("sheet print setup");
        poiSheet.setMargin((short)0, sps.getLeftMargin());
        poiSheet.setMargin((short)1, sps.getRightMargin());
        poiSheet.setMargin((short)2, sps.getTopMargin());
        poiSheet.setMargin((short)3, sps.getBottomMargin());
        poiSheet.setMargin((short)4, sps.getHeaderMargin());
        poiSheet.setMargin((short)5, sps.getFooterMargin());
        PrintSetup poips = poiSheet.getPrintSetup();
        if (sps.isDifferentOddEvenPage()) {
            SFooter evenFooter;
            SHeader evenHeader = sps.getEvenHeader();
            if (evenHeader != null) {
                Header poiEvenHeader = poiSheet instanceof HSSFSheet ? ((HSSFSheet)poiSheet).getEvenHeader() : ((XSSFSheet)poiSheet).getEvenHeader();
                poiEvenHeader.setCenter(evenHeader.getCenterText());
                poiEvenHeader.setLeft(evenHeader.getLeftText());
                poiEvenHeader.setRight(evenHeader.getRightText());
            }
            if ((evenFooter = sps.getEvenFooter()) != null) {
                Footer poiEvenFooter = poiSheet instanceof HSSFSheet ? ((HSSFSheet)poiSheet).getEvenFooter() : ((XSSFSheet)poiSheet).getEvenFooter();
                poiEvenFooter.setCenter(evenFooter.getCenterText());
                poiEvenFooter.setLeft(evenFooter.getLeftText());
                poiEvenFooter.setRight(evenFooter.getRightText());
            }
        }
        if (sps.isDifferentFirstPage()) {
            SFooter firstFooter;
            SHeader firstHeader = sps.getFirstHeader();
            if (firstHeader != null) {
                Header poiFirstHeader = poiSheet instanceof HSSFSheet ? ((HSSFSheet)poiSheet).getFirstHeader() : ((XSSFSheet)poiSheet).getFirstHeader();
                poiFirstHeader.setCenter(firstHeader.getCenterText());
                poiFirstHeader.setLeft(firstHeader.getLeftText());
                poiFirstHeader.setRight(firstHeader.getRightText());
            }
            if ((firstFooter = sps.getFirstFooter()) != null) {
                Footer poiFirstFooter = poiSheet instanceof HSSFSheet ? ((HSSFSheet)poiSheet).getFirstFooter() : ((XSSFSheet)poiSheet).getFirstFooter();
                poiFirstFooter.setCenter(firstFooter.getCenterText());
                poiFirstFooter.setLeft(firstFooter.getLeftText());
                poiFirstFooter.setRight(firstFooter.getRightText());
            }
        }
        if (poiSheet instanceof HSSFSheet) {
            ((HSSFSheet)poiSheet).setAlignMargins(sps.isAlignWithMargins());
        } else {
            ((XSSFSheet)poiSheet).getHeaderFooterProperties().setAlignWithMargins(sps.isAlignWithMargins());
        }
        if (poips instanceof HSSFPrintSetup) {
            ((HSSFPrintSetup)poips).setErrorsMode(sps.getErrorPrintMode());
        } else {
            XSSFPrintSetupHelper.setErrorsMode((XSSFPrintSetup)((XSSFPrintSetup)poips), (int)sps.getErrorPrintMode());
        }
        poips.setFitHeight((short)sps.getFitHeight());
        poips.setFitWidth((short)sps.getFitWidth());
        poiSheet.setHorizontallyCenter(sps.isHCenter());
        poiSheet.setVerticallyCenter(sps.isVCenter());
        poips.setLandscape(sps.isLandscape());
        poips.setLeftToRight(sps.isLeftToRight());
        int pageStart = sps.getPageStart();
        poips.setUsePage(pageStart > 0);
        poips.setPageStart((short)(pageStart > 0 ? pageStart : 0));
        poips.setPaperSize(PoiEnumConversion.toPoiPaperSize(sps.getPaperSize()));
        if (poips instanceof HSSFPrintSetup) {
            ((HSSFPrintSetup)poips).setCommentsMode(sps.getCommentsMode());
        } else {
            XSSFPrintSetupHelper.setCommentsMode((XSSFPrintSetup)((XSSFPrintSetup)poips), (int)sps.getCommentsMode());
        }
        poiSheet.setPrintGridlines(sps.isPrintGridlines());
        if (poiSheet instanceof HSSFSheet) {
            ((HSSFSheet)poiSheet).setPrintHeadings(sps.isPrintHeadings());
        } else {
            XSSFSheetHelper.setPrintHeadings((XSSFSheet)((XSSFSheet)poiSheet), (boolean)sps.isPrintHeadings());
        }
        poips.setScale((short)sps.getScale());
        if (poiSheet instanceof HSSFSheet) {
            ((HSSFSheet)poiSheet).setScalWithDoc(sps.isScaleWithDoc());
        } else {
            ((XSSFSheet)poiSheet).getHeaderFooterProperties().setScaleWithDoc(sps.isScaleWithDoc());
        }
        if (poiSheet instanceof HSSFSheet) {
            ((HSSFSheet)poiSheet).setDiffOddEven(sps.isDifferentOddEvenPage());
        } else {
            ((XSSFSheet)poiSheet).getHeaderFooterProperties().setDifferentOddEven(sps.isDifferentOddEvenPage());
        }
        if (poiSheet instanceof HSSFSheet) {
            ((HSSFSheet)poiSheet).setDiffFirst(sps.isDifferentOddEvenPage());
        } else {
            ((XSSFSheet)poiSheet).getHeaderFooterProperties().setDifferentFirst(sps.isDifferentFirstPage());
        }
        int sheetIndex = this.workbook.getNumberOfSheets() - 1;
        String area = sps.getPrintArea();
        if (!Strings.isEmpty(area)) {
            this._exportPhase.setPhase("sheet print area");
            AreaReference areaReference = new AreaReference(area, this.workbook.getSpreadsheetVersion());
            this.workbook.setPrintArea(sheetIndex, areaReference.getFirstCell().formatAsString(false) + ":" + areaReference.getLastCell().formatAsString(false));
            this._exportPhase.setPhase("sheet print setup");
        }
        if ((rgn = sps.getRepeatingRowsTitle()) != null) {
            CellRangeAddress rowrng = new CellRangeAddress(rgn.getRow(), rgn.getLastRow(), -1, -1);
            poiSheet.setRepeatingRows(rowrng);
        }
        if ((crgn = sps.getRepeatingColumnsTitle()) != null) {
            CellRangeAddress colrng = new CellRangeAddress(-1, -1, crgn.getColumn(), crgn.getLastColumn());
            poiSheet.setRepeatingColumns(colrng);
        }
        this._exportPhase.setPhase("sheet visible");
        SheetVisibility option = SheetVisibility.VISIBLE;
        switch (sheet.getSheetVisible()) {
            default: {
                option = SheetVisibility.VISIBLE;
                break;
            }
            case HIDDEN: {
                option = SheetVisibility.HIDDEN;
                break;
            }
            case VERY_HIDDEN: {
                option = SheetVisibility.VERY_HIDDEN;
            }
        }
        this.workbook.setSheetVisibility(sheetIndex, option);
    }

    protected void exportMergedRegions(SSheet sheet, Sheet poiSheet) {
        this._exportPhase.setPhase("merged cell");
        for (int i = sheet.getNumOfMergedRegion() - 1; i >= 0; --i) {
            CellRegion region = sheet.getMergedRegion(i);
            poiSheet.addMergedRegion(new CellRangeAddress(region.row, region.lastRow, region.column, region.lastColumn));
        }
    }

    protected void exportRowColumn(SSheet sheet, Sheet poiSheet) {
        Iterator<SRow> rowIterator = sheet.getRowIterator();
        while (rowIterator.hasNext()) {
            SRow row = rowIterator.next();
            this.exportRow(sheet, poiSheet, row);
        }
        this._exportPhase.setRowIndex(-1);
        this._exportPhase.setColIndex(-1);
        Iterator<SColumnArray> columnArrayIterator = sheet.getColumnArrayIterator();
        while (columnArrayIterator.hasNext()) {
            SColumnArray columnArr = columnArrayIterator.next();
            if (((ColumnArrayImpl)columnArr).shouldSkip()) continue;
            this.exportColumnArray(sheet, poiSheet, columnArr);
        }
        this._exportPhase.setColIndex(-1);
    }

    protected void exportRow(SSheet sheet, Sheet poiSheet, SRow row) {
        this._exportPhase.setPhase("row");
        int rowIndex = row.getIndex();
        this._exportPhase.setRowIndex(rowIndex);
        Row poiRow = poiSheet.getRow(rowIndex);
        if (poiRow == null) {
            poiRow = poiSheet.createRow(rowIndex);
        }
        if (row.isHidden()) {
            poiRow.setZeroHeight(true);
        } else if (row.isCustomHeight()) {
            poiRow.setHeight((short)UnitUtil.pxToTwip(row.getHeight()));
        } else if (row.getHeight() != 20) {
            poiRow.setHeight((short)UnitUtil.pxToTwip(row.getHeight()));
        }
        if (poiRow instanceof XSSFRow) {
            CTRow ctRow = ((XSSFRow)poiRow).getCTRow();
            if (row.isCollapsed()) {
                ctRow.setCollapsed(true);
            }
            if (row.getOutlineLevel() > 0) {
                ctRow.setOutlineLevel((short)row.getOutlineLevel());
            }
        }
        SCellStyle rowStyle = row.getCellStyle();
        CellStyle poiRowStyle = this.toPOICellStyle(rowStyle);
        poiRow.setRowStyle(poiRowStyle);
        this._exportPhase.setPhase("cell");
        Iterator<SCell> cellIterator = sheet.getCellIterator(row.getIndex());
        while (cellIterator.hasNext()) {
            SCell cell = cellIterator.next();
            this.exportCell(poiRow, cell);
        }
        this._exportPhase.setPhase("row");
    }

    protected void exportCell(Row poiRow, SCell cell) {
        int columnIndex = cell.getColumnIndex();
        this._exportPhase.setColIndex(columnIndex);
        Cell poiCell = poiRow.createCell(columnIndex);
        SCellStyle cellStyle = cell.getCellStyle();
        poiCell.setCellStyle(this.toPOICellStyle(cellStyle));
        block1 : switch (cell.getType()) {
            case BLANK: {
                poiCell.setBlank();
                break;
            }
            case ERROR: {
                if (cell.getErrorValue().getCode() == 127) {
                    _logger.warn("Don't export an invalid formula: {} at {}", (Object)("=" + cell.getFormulaValue()), (Object)new SheetRegion(cell.getSheet(), cell.getReferenceString()).getReferenceString());
                    break;
                }
                poiCell.setCellErrorValue(cell.getErrorValue().getCode());
                break;
            }
            case BOOLEAN: {
                poiCell.setCellValue(cell.getBooleanValue().booleanValue());
                break;
            }
            case FORMULA: {
                if (cell.getFormulaResultType() == SCell.CellType.ERROR && cell.getErrorValue().getCode() == 127) {
                    _logger.warn("Don't export an invalid formula: {} at {}", (Object)("=" + cell.getFormulaValue()), (Object)new SheetRegion(cell.getSheet(), cell.getReferenceString()).getReferenceString());
                    break;
                }
                if (cell.isPartOfArrayFormulaGroup()) {
                    CellRegion arrayFormulaRange = cell.getArrayFormulaRegion();
                    if (arrayFormulaRange.getRow() != cell.getRowIndex() || arrayFormulaRange.getColumn() != cell.getColumnIndex()) break;
                    poiCell.getSheet().setArrayFormula(this.getFormulaString(cell), CellRangeAddress.valueOf((String)arrayFormulaRange.getReferenceString()));
                    break;
                }
                poiCell.setCellFormula(this.getFormulaString(cell));
                if (_logger.isDebugEnabled()) {
                    _logger.debug("export a formula at {}", (Object)new SheetRegion(cell.getSheet(), cell.getReferenceString()).getReferenceString());
                }
                if (!this.isExportCache()) break;
                switch (cell.getFormulaResultType()) {
                    default: {
                        break block1;
                    }
                    case BOOLEAN: {
                        poiCell.setCellValue(cell.getBooleanValue().booleanValue());
                        break block1;
                    }
                    case ERROR: {
                        poiCell.setCellErrorValue(cell.getErrorValue().getCode());
                        break block1;
                    }
                    case NUMBER: {
                        poiCell.setCellValue(cell.getNumberValue().doubleValue());
                        break block1;
                    }
                    case STRING: 
                }
                if (cell.isRichTextValue()) {
                    poiCell.setCellValue(this.toPOIRichText(cell.getRichTextValue()));
                    break;
                }
                poiCell.setCellValue(cell.getStringValue());
                break;
            }
            case NUMBER: {
                poiCell.setCellValue(cell.getNumberValue().doubleValue());
                break;
            }
            case STRING: {
                if (cell.isRichTextValue()) {
                    poiCell.setCellValue(this.toPOIRichText(cell.getRichTextValue()));
                    break;
                }
                poiCell.setCellValue(cell.getStringValue());
                break;
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("exported a cell type {} at {}", (Object)cell.getType(), (Object)new SheetRegion(cell.getSheet(), cell.getReferenceString()).getReferenceString());
        }
        this._exportPhase.setPhase("hyperlink");
        SHyperlink hyperlink = cell.getHyperlink();
        if (hyperlink != null) {
            CreationHelper helper = this.workbook.getCreationHelper();
            try {
                Hyperlink poiHyperlink = helper.createHyperlink(PoiEnumConversion.toPoiHyperlinkType(hyperlink.getType()));
                poiHyperlink.setAddress(hyperlink.getAddress());
                poiHyperlink.setLabel(hyperlink.getLabel());
                poiCell.setHyperlink(poiHyperlink);
            }
            catch (Exception e) {
                _logger.warn("Cannot export a hyperlink: " + hyperlink.getAddress(), (Throwable)e);
            }
        }
        this._exportPhase.setPhase("comment");
        SComment comment = cell.getComment();
        if (comment != null) {
            CreationHelper helper = this.workbook.getCreationHelper();
            Drawing drawing = poiCell.getSheet().createDrawingPatriarch();
            ClientAnchor anchor = helper.createClientAnchor();
            anchor.setCol1(poiCell.getColumnIndex());
            anchor.setCol2(poiCell.getColumnIndex() + 1);
            anchor.setRow1(poiRow.getRowNum());
            anchor.setRow2(poiRow.getRowNum() + 3);
            Comment poiComment = drawing.createCellComment(anchor);
            SRichText richText = comment.getRichText();
            if (richText != null) {
                poiComment.setString(this.toPOIRichText(richText));
            } else {
                poiComment.setString(helper.createRichTextString(comment.getText()));
            }
            Optional.ofNullable(comment.getAuthor()).ifPresent(arg_0 -> ((Comment)poiComment).setAuthor(arg_0));
            poiComment.setVisible(comment.isVisible());
            poiCell.setCellComment(poiComment);
        }
        this._exportPhase.setPhase("cell");
    }

    protected String getFormulaString(SCell cell) {
        FormatEngine fe = EngineFactory.getInstance().createFormatEngine();
        String originalFormulaValue = cell.getFormulaValue();
        String prefix = "_xlfn.";
        boolean prefixFound = originalFormulaValue.startsWith(prefix);
        String formulaString = fe.getEditText(cell, new FormatContext(ZssContext.getCurrent().getLocale())).substring(1);
        return prefixFound && !formulaString.startsWith(prefix) ? prefix + formulaString : formulaString;
    }

    protected RichTextString toPOIRichText(SRichText richText) {
        CreationHelper helper = this.workbook.getCreationHelper();
        RichTextString poiRichTextString = helper.createRichTextString(richText.getText());
        int start = 0;
        int end = 0;
        for (SRichText.Segment sg : richText.getSegments()) {
            SFont font = sg.getFont();
            int len = sg.getText().length();
            poiRichTextString.applyFont(start, end += len, this.toPOIFont(font));
            start += len;
        }
        return poiRichTextString;
    }

    protected NamedStyle toPOINamedStyle(SNamedStyle cellStyle) {
        if (this.workbook instanceof XSSFWorkbook) {
            return XSSFWorkbookHelper.createNamedStyle((XSSFWorkbook)((XSSFWorkbook)this.workbook), (String)cellStyle.getName(), (boolean)cellStyle.isCustomBuiltin(), (int)cellStyle.getBuiltinId(), (int)cellStyle.getIndex());
        }
        return null;
    }

    protected CellStyle toPOIDefaultCellStyle(SCellStyle cellStyle) {
        return null;
    }

    protected CellStyle toPOICellStyle(SCellStyle cellStyle) {
        short index;
        CellStyle poiCellStyle = this.styleTable.get(cellStyle);
        if (poiCellStyle != null) {
            return poiCellStyle;
        }
        poiCellStyle = this.workbook.createCellStyle();
        BorderStyle bottom = PoiEnumConversion.toPoiBorderType(cellStyle.getBorderBottom());
        BorderStyle left = PoiEnumConversion.toPoiBorderType(cellStyle.getBorderLeft());
        BorderStyle right = PoiEnumConversion.toPoiBorderType(cellStyle.getBorderRight());
        BorderStyle top = PoiEnumConversion.toPoiBorderType(cellStyle.getBorderTop());
        Color bottomColor = this.toPOIColor(cellStyle.getBorderBottomColor());
        Color leftColor = this.toPOIColor(cellStyle.getBorderLeftColor());
        Color rightColor = this.toPOIColor(cellStyle.getBorderRightColor());
        Color topColor = this.toPOIColor(cellStyle.getBorderTopColor());
        poiCellStyle.setBorderRight(right);
        poiCellStyle.setBorderLeft(left);
        poiCellStyle.setBorderTop(top);
        poiCellStyle.setBorderBottom(bottom);
        if (poiCellStyle instanceof HSSFCellStyle) {
            ((HSSFCellStyle)poiCellStyle).setBottomBorderColor((HSSFColor)bottomColor);
            ((HSSFCellStyle)poiCellStyle).setTopBorderColor((HSSFColor)topColor);
            ((HSSFCellStyle)poiCellStyle).setRightBorderColor((HSSFColor)rightColor);
            ((HSSFCellStyle)poiCellStyle).setLeftBorderColor((HSSFColor)leftColor);
        } else {
            ((XSSFCellStyle)poiCellStyle).setBottomBorderColor((XSSFColor)bottomColor);
            ((XSSFCellStyle)poiCellStyle).setTopBorderColor((XSSFColor)topColor);
            ((XSSFCellStyle)poiCellStyle).setRightBorderColor((XSSFColor)rightColor);
            ((XSSFCellStyle)poiCellStyle).setLeftBorderColor((XSSFColor)leftColor);
        }
        SColor fgColor = cellStyle.getFillColor();
        SColor bgColor = cellStyle.getBackColor();
        if (cellStyle.getFillPattern() == SFill.FillPattern.SOLID) {
            SColor tmp = fgColor;
            fgColor = bgColor;
            bgColor = tmp;
        }
        Color fillColor = this.toPOIColor(fgColor);
        Color backColor = this.toPOIColor(bgColor);
        FillPatternType pattern = PoiEnumConversion.toPoiFillPattern(cellStyle.getFillPattern());
        poiCellStyle.setFillForegroundColor(fillColor);
        poiCellStyle.setFillBackgroundColor(backColor);
        poiCellStyle.setFillPattern(pattern);
        HorizontalAlignment hAlign = PoiEnumConversion.toPoiHorizontalAlignment(cellStyle.getAlignment());
        VerticalAlignment vAlign = PoiEnumConversion.toPoiVerticalAlignment(cellStyle.getVerticalAlignment());
        boolean wrapText = cellStyle.isWrapText();
        poiCellStyle.setAlignment(hAlign);
        poiCellStyle.setVerticalAlignment(vAlign);
        poiCellStyle.setWrapText(wrapText);
        poiCellStyle.setRotation((short)cellStyle.getRotation());
        boolean locked = cellStyle.isLocked();
        boolean hidden = cellStyle.isHidden();
        poiCellStyle.setLocked(locked);
        poiCellStyle.setHidden(hidden);
        DataFormat dataFormat = this.workbook.createDataFormat();
        if (cellStyle.isDirectDataFormat()) {
            if (dataFormat instanceof HSSFDataFormat) {
                index = ((HSSFDataFormat)dataFormat).newFormat(cellStyle.getDataFormat());
                poiCellStyle.setDataFormat(index);
            } else {
                poiCellStyle.setDataFormat((short)((XSSFWorkbook)this.workbook).getStylesSource().putNumberFormat(cellStyle.getDataFormat()));
            }
        } else {
            index = dataFormat.getFormat(cellStyle.getDataFormat());
            poiCellStyle.setDataFormat(index);
        }
        poiCellStyle.setFont(this.toPOIFont(cellStyle.getFont()));
        this.styleTable.put(cellStyle, poiCellStyle);
        int indention = cellStyle.getIndention();
        if (indention > 0) {
            poiCellStyle.setIndention((short)indention);
        }
        return poiCellStyle;
    }

    protected Color toPOIColor(SColor color) {
        if (color == null) {
            return null;
        }
        Color poiColor = this.colorTable.get(color);
        if (poiColor != null) {
            return poiColor;
        }
        poiColor = BookHelper.HTMLToColor(this.workbook, color.getHtmlColor());
        this.colorTable.put(color, poiColor);
        return poiColor;
    }

    protected Font toPOIFont(SFont font) {
        if (font == null) {
            return null;
        }
        Font poiFont = this.fontTable.get(font);
        if (poiFont != null) {
            return poiFont;
        }
        poiFont = this.workbook.createFont();
        poiFont.setBold(PoiEnumConversion.toPoiBoldweight(font.getBoldweight()) == 700);
        poiFont.setStrikeout(font.isStrikeout());
        poiFont.setItalic(font.isItalic());
        BookHelper.setFontColor(this.workbook, poiFont, this.toPOIColor(font.getColor()));
        poiFont.setFontHeightInPoints((short)font.getHeightPoints());
        poiFont.setFontName(font.getName());
        poiFont.setTypeOffset(PoiEnumConversion.toPoiTypeOffset(font.getTypeOffset()));
        poiFont.setUnderline(PoiEnumConversion.toPoiUnderline(font.getUnderline()));
        this.fontTable.put(font, poiFont);
        return poiFont;
    }

    protected void exportSheetProtection(SSheet sheet, Sheet poiSheet) {
        SSheetProtection ssp = sheet.getSheetProtection();
        SheetProtection sp = poiSheet instanceof HSSFSheet ? ((HSSFSheet)poiSheet).getOrCreateSheetProtection() : XSSFSheetHelper.getOrCreateSheetProtection((XSSFSheet)((XSSFSheet)poiSheet));
        sp.setAutoFilter(ssp.isAutoFilter());
        sp.setDeleteColumns(ssp.isDeleteColumns());
        sp.setDeleteRows(ssp.isDeleteRows());
        sp.setFormatCells(ssp.isFormatCells());
        sp.setFormatColumns(ssp.isFormatColumns());
        sp.setFormatRows(ssp.isFormatRows());
        sp.setInsertColumns(ssp.isInsertColumns());
        sp.setInsertHyperlinks(ssp.isInsertHyperlinks());
        sp.setInsertRows(ssp.isInsertRows());
        sp.setPivotTables(ssp.isPivotTables());
        sp.setSort(ssp.isSort());
        sp.setObjects(ssp.isObjects());
        sp.setScenarios(ssp.isScenarios());
        sp.setSelectLockedCells(ssp.isSelectLockedCells());
        sp.setSelectUnlockedCells(ssp.isSelectUnlockedCells());
    }

    public void setExportCache(boolean b) {
        this._exportCache = b;
    }

    protected boolean isExportCache() {
        return this._exportCache;
    }

    protected void addPOIDxfCellStyle(SExtraStyle extraStyle) {
    }

    protected void addPOITableStyle(STableStyle tableStyle) {
    }
}

