/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl;

import io.keikai.model.InvalidModelOpException;
import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SColumn;
import io.keikai.model.SRow;
import io.keikai.range.SRange;
import io.keikai.range.impl.RangeHelperBase;
import io.keikai.range.impl.StyleUtil;
import java.util.HashSet;
import java.util.Iterator;

public class SetCellStyleHelper
extends RangeHelperBase {
    private static final long serialVersionUID = 7100312833600659286L;
    SCellStyle _defaultStyle;

    public SetCellStyleHelper(SRange range) {
        super(range);
        this._defaultStyle = range.getSheet().getBook().getDefaultCellStyle();
    }

    public void setCellStyle(SCellStyle style) {
        if (this.isWholeSheet()) {
            throw new InvalidModelOpException("don't allow to set style to whole sheet, please consider to set as whole column style");
        }
        if (this.isWholeRow()) {
            this.setWholeRowCellStyle(style);
        } else if (this.isWholeColumn()) {
            this.setWholeColumnCellStyle(style);
        } else {
            for (int r = this.getRow(); r <= this.getLastRow(); ++r) {
                for (int c = this.getColumn(); c <= this.getLastColumn(); ++c) {
                    SCell cell = this.sheet.getCell(r, c);
                    this.setNewCellStyle(cell, style);
                    cell.setCellStyle(style);
                }
            }
        }
    }

    public void setWholeRowCellStyle(SCellStyle style) {
        for (int r = this.getRow(); r <= this.getLastRow(); ++r) {
            SRow row = this.sheet.getRow(r);
            row.setCellStyle(style);
            HashSet<Integer> cellProcessed = new HashSet<Integer>();
            Iterator<SCell> cells = this.sheet.getCellIterator(r);
            while (cells.hasNext()) {
                SCell cell = cells.next();
                if (cell.getCellStyle(true) != null || this.sheet.getColumn(cell.getColumnIndex()).getCellStyle(true) != null) {
                    cell.setCellStyle(style);
                }
                cellProcessed.add(cell.getColumnIndex());
            }
            Iterator<SColumn> columns = this.sheet.getColumnIterator();
            while (columns.hasNext()) {
                SColumn column = columns.next();
                if (cellProcessed.contains(column.getIndex()) || column.getCellStyle(true) == null) continue;
                this.sheet.getCell(r, column.getIndex()).setCellStyle(style);
            }
        }
    }

    public void setWholeColumnCellStyle(SCellStyle style) {
        for (int c = this.getColumn(); c <= this.getLastColumn(); ++c) {
            SColumn column = this.sheet.getColumn(c);
            column.setCellStyle(style);
        }
        Iterator<SRow> rows = this.sheet.getRowIterator();
        while (rows.hasNext()) {
            SRow row = rows.next();
            for (int c = this.getColumn(); c <= this.getLastColumn(); ++c) {
                SCell cell = this.sheet.getCell(row.getIndex(), c);
                if (cell.getCellStyle(true) == null && row.getCellStyle(true) == null) continue;
                cell.setCellStyle(style);
            }
        }
    }

    private void setNewCellStyle(SCell cell, SCellStyle cellStyle) {
        StyleUtil.setNewCellStyle(cell, cellStyle);
    }
}

