/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl;

import io.keikai.model.CellRegion;
import io.keikai.model.SSheet;
import io.keikai.model.STable;
import io.keikai.model.SheetRegion;
import io.keikai.model.impl.CellAttribute;
import io.keikai.model.impl.RefImpl;
import io.keikai.model.sys.dependency.Ref;
import io.keikai.range.impl.AutoFilterUpdate;
import io.keikai.range.impl.InsertDeleteUpdate;
import io.keikai.range.impl.MergeUpdate;
import io.keikai.range.impl.ModelUpdate;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ModelUpdateCollector
implements Serializable {
    private static final long serialVersionUID = 1310348139144036698L;
    static ThreadLocal<ModelUpdateCollector> _current = new ThreadLocal();
    private List<ModelUpdate> _updates;

    public static ModelUpdateCollector setCurrent(ModelUpdateCollector ctx) {
        ModelUpdateCollector old = _current.get();
        _current.set(ctx);
        return old;
    }

    public static ModelUpdateCollector getCurrent() {
        return _current.get();
    }

    public void addModelUpdate(ModelUpdate mu) {
        if (this._updates == null) {
            this._updates = new LinkedList<ModelUpdate>();
        }
        this._updates.add(mu);
    }

    public List<ModelUpdate> getModelUpdates() {
        if (this._updates == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this._updates);
    }

    private ModelUpdate getLast() {
        return this._updates == null || this._updates.size() == 0 ? null : this._updates.get(this._updates.size() - 1);
    }

    private void removeLast() {
        if (this._updates != null && this._updates.size() > 0) {
            this._updates.remove(this._updates.size() - 1);
        }
    }

    public void addRefs(Set<Ref> dependents) {
        ModelUpdate last = this.getLast();
        if (last != null) {
            if (last.getType() == ModelUpdate.UpdateType.REFS) {
                ((Set)last.getData()).addAll(dependents);
                return;
            }
            if (last.getType() == ModelUpdate.UpdateType.REF) {
                LinkedHashSet<Ref> data = new LinkedHashSet<Ref>();
                data.add((Ref)last.getData());
                data.addAll(dependents);
                this.removeLast();
                this.addModelUpdate(new ModelUpdate(ModelUpdate.UpdateType.REFS, data, CellAttribute.ALL));
                return;
            }
        }
        this.addModelUpdate(new ModelUpdate(ModelUpdate.UpdateType.REFS, new LinkedHashSet<Ref>(dependents), CellAttribute.ALL));
    }

    public void addRef(Ref ref) {
        ModelUpdate last = this.getLast();
        if (last != null) {
            if (last.getType() == ModelUpdate.UpdateType.REFS) {
                ((Set)last.getData()).add(ref);
                return;
            }
            if (last.getType() == ModelUpdate.UpdateType.REF) {
                LinkedHashSet<Ref> data = new LinkedHashSet<Ref>();
                data.add((Ref)last.getData());
                data.add(ref);
                this.removeLast();
                this.addModelUpdate(new ModelUpdate(ModelUpdate.UpdateType.REFS, data, CellAttribute.ALL));
                return;
            }
        }
        this.addModelUpdate(new ModelUpdate(ModelUpdate.UpdateType.REF, ref, CellAttribute.ALL));
    }

    public void addCellUpdate(SSheet sheet, int row, int column, int lastRow, int lastColumn, CellAttribute cellAttr) {
        ModelUpdate last = this.getLast();
        if (last != null) {
            if (last.getType() == ModelUpdate.UpdateType.REFS) {
                String bookName = sheet.getBook().getBookName();
                String sheetName = sheet.getSheetName();
                if (((Set)last.getData()).contains(new RefImpl(bookName, sheetName, row, column, lastRow, lastColumn))) {
                    return;
                }
            } else if (last.getType() == ModelUpdate.UpdateType.REF) {
                String bookName = sheet.getBook().getBookName();
                String sheetName = sheet.getSheetName();
                if (((Ref)last.getData()).equals(new RefImpl(bookName, sheetName, row, column, lastRow, lastColumn))) {
                    return;
                }
            } else {
                if (last.getType() == ModelUpdate.UpdateType.CELLS && last.getCellAttr() == cellAttr) {
                    SheetRegion data = new SheetRegion(sheet, row, column, lastRow, lastColumn);
                    ((Set)last.getData()).add(data);
                    return;
                }
                if (last.getType() == ModelUpdate.UpdateType.CELL && last.getCellAttr() == cellAttr) {
                    LinkedHashSet<SheetRegion> data = new LinkedHashSet<SheetRegion>();
                    data.add((SheetRegion)last.getData());
                    data.add(new SheetRegion(sheet, row, column, lastRow, lastColumn));
                    this.removeLast();
                    this.addModelUpdate(new ModelUpdate(ModelUpdate.UpdateType.CELLS, data, cellAttr));
                }
            }
        }
        this.addModelUpdate(new ModelUpdate(ModelUpdate.UpdateType.CELL, new SheetRegion(sheet, row, column, lastRow, lastColumn), cellAttr));
    }

    public void addMergeChange(SSheet sheet, CellRegion original, CellRegion changeTo) {
        this.addModelUpdate(new ModelUpdate(ModelUpdate.UpdateType.MERGE, new MergeUpdate(sheet, original, changeTo), CellAttribute.ALL));
    }

    public void addInsertDeleteUpdate(SSheet sheet, boolean inserted, boolean isRow, int index, int lastIndex) {
        this.addModelUpdate(new ModelUpdate(ModelUpdate.UpdateType.INSERT_DELETE, new InsertDeleteUpdate(sheet, inserted, isRow, index, lastIndex), CellAttribute.ALL));
    }

    public void addAutoFilterUpdate(SSheet sheet, STable table) {
        this.addModelUpdate(new ModelUpdate(ModelUpdate.UpdateType.FILTER, new AutoFilterUpdate(sheet, table), CellAttribute.ALL));
    }
}

