/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl;

import io.keikai.model.CellRegion;
import io.keikai.model.SBorder;
import io.keikai.model.SBorderLine;
import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SCellStyleBuilder;
import io.keikai.model.SRow;
import io.keikai.model.SSheet;
import io.keikai.range.SRange;
import io.keikai.range.impl.RangeHelperBase;
import java.util.List;
import java.util.Objects;

public class MergeHelper
extends RangeHelperBase {
    public MergeHelper(SRange range) {
        super(range);
    }

    public void unmerge(boolean overlapped) {
        int tRow = this.getRow();
        int lCol = this.getColumn();
        int bRow = this.getLastRow();
        int rCol = this.getLastColumn();
        this.sheet.removeMergedRegion(new CellRegion(tRow, lCol, bRow, rCol), overlapped);
    }

    public void merge(boolean across) {
        int rCol;
        int bRow;
        int lCol;
        int tRow = this.range.getRow();
        List<CellRegion> overlaps = this.sheet.getOverlapsMergedRegions(new CellRegion(tRow, lCol = this.range.getColumn(), bRow = this.range.getLastRow(), rCol = this.range.getLastColumn()), false);
        if (overlaps.size() > 0) {
            this.unmerge(true);
        }
        if (across) {
            for (int r = tRow; r <= bRow; ++r) {
                this.merge0(this.sheet, r, lCol, r, rCol);
            }
        } else {
            this.merge0(this.sheet, tRow, lCol, bRow, rCol);
        }
    }

    private void setRowCustomHeight(SSheet sheet, int r) {
        int defaultHt;
        SRow row = sheet.getRow(r);
        int ht = row.getHeight();
        if (ht != (defaultHt = sheet.getDefaultRowHeight())) {
            row.setCustomHeight(true);
        }
    }

    private void merge0(SSheet sheet, int tRow, int lCol, int bRow, int rCol) {
        SCell brCell;
        SBorder brBd;
        if (tRow == bRow && lCol == rCol) {
            return;
        }
        SCell target = null;
        block0: for (int r = tRow; target == null && r <= bRow; ++r) {
            for (int c = lCol; c <= rCol; ++c) {
                SCell cell = sheet.getCell(r, c);
                if (MergeHelper.isBlank(cell)) continue;
                target = cell;
                continue block0;
            }
        }
        SBorderLine lBorder = null;
        SBorderLine tBorder = null;
        SBorderLine rBorder = null;
        SBorderLine bBorder = null;
        SCell tlCell = sheet.getCell(tRow, lCol);
        SBorder tlBd = tlCell.getCellStyle().getBorder();
        if (tlBd != null) {
            lBorder = tlBd.getLeftLine();
            tBorder = tlBd.getTopLine();
        }
        if ((brBd = (brCell = sheet.getCell(bRow, rCol)).getCellStyle().getBorder()) != null) {
            rBorder = brBd.getRightLine();
            bBorder = brBd.getBottomLine();
        }
        SBorderLine defaultLBorder = null;
        SBorderLine defaultTBorder = null;
        SBorderLine defaultRBorder = null;
        SBorderLine defaultBBorder = null;
        SBorder sb = sheet.getBook().getDefaultCellStyle().getBorder();
        if (sb != null) {
            defaultLBorder = sb.getLeftLine();
            defaultTBorder = sb.getTopLine();
            defaultRBorder = sb.getRightLine();
            defaultBBorder = sb.getBottomLine();
        }
        boolean checkLeft = true;
        boolean checkTop = true;
        boolean checkRight = true;
        boolean checkBottom = true;
        if (Objects.equals(tBorder, defaultTBorder)) {
            checkTop = false;
        }
        if (Objects.equals(lBorder, defaultLBorder)) {
            checkLeft = false;
        }
        if (Objects.equals(rBorder, defaultRBorder)) {
            checkRight = false;
        }
        if (Objects.equals(bBorder, defaultBBorder)) {
            checkBottom = false;
        }
        boolean check = true;
        if (!(checkTop || checkBottom || checkLeft || checkRight)) {
            check = false;
        }
        if (check) {
            for (int r = tRow; r <= bRow; ++r) {
                SBorderLine cellLBorder;
                SBorder border;
                SCell cell;
                int c;
                if (r == tRow) {
                    for (c = lCol; c <= rCol; ++c) {
                        cell = sheet.getCell(r, c);
                        border = cell.getCellStyle().getBorder();
                        cellLBorder = null;
                        SBorderLine cellTBorder = null;
                        SBorderLine cellRBorder = null;
                        if (border != null) {
                            cellLBorder = border.getLeftLine();
                            cellTBorder = border.getTopLine();
                            cellRBorder = border.getRightLine();
                        }
                        if (checkTop && border != null && !Objects.equals(tBorder, cellTBorder)) {
                            checkTop = false;
                            tBorder = defaultTBorder;
                        }
                        if (checkLeft && c == lCol && !Objects.equals(lBorder, cellLBorder)) {
                            checkLeft = false;
                            lBorder = defaultLBorder;
                        }
                        if (!checkRight || c != rCol || Objects.equals(rBorder, cellRBorder)) continue;
                        checkRight = false;
                        rBorder = defaultRBorder;
                    }
                }
                if (r == bRow) {
                    for (c = lCol; c <= rCol; ++c) {
                        cell = sheet.getCell(r, c);
                        border = cell.getCellStyle().getBorder();
                        cellLBorder = null;
                        SBorderLine cellRBorder = null;
                        SBorderLine cellBBorder = null;
                        if (border != null) {
                            cellLBorder = border.getLeftLine();
                            cellRBorder = border.getRightLine();
                            cellBBorder = border.getBottomLine();
                        }
                        if (checkBottom && !Objects.equals(bBorder, cellBBorder)) {
                            checkBottom = false;
                            bBorder = defaultBBorder;
                        }
                        if (checkLeft && c == lCol && !Objects.equals(lBorder, cellLBorder)) {
                            checkLeft = false;
                            lBorder = defaultLBorder;
                        }
                        if (!checkRight || c != rCol || Objects.equals(rBorder, cellRBorder)) continue;
                        checkRight = false;
                        rBorder = defaultRBorder;
                    }
                }
                if (r == tRow || r == bRow) continue;
                SCell cell2 = sheet.getCell(r, lCol);
                SBorder border2 = cell2.getCellStyle().getBorder();
                SBorderLine cellLBorder2 = null;
                SBorderLine cellRBorder = null;
                if (border2 != null) {
                    cellLBorder2 = border2.getLeftLine();
                }
                if (checkLeft && !Objects.equals(lBorder, cellLBorder2)) {
                    checkLeft = false;
                    lBorder = defaultLBorder;
                }
                if ((border2 = (cell2 = sheet.getCell(r, rCol)).getCellStyle().getBorder()) != null) {
                    cellRBorder = border2.getRightLine();
                }
                if (!checkRight || Objects.equals(rBorder, cellRBorder)) continue;
                checkRight = false;
                rBorder = defaultRBorder;
            }
        }
        if (target == null) {
            target = sheet.getCell(tRow, lCol);
        }
        SCellStyle style = null;
        if (target != null) {
            int tgtRow = target.getRowIndex();
            int tgtCol = target.getColumnIndex();
            int nRow = tRow - tgtRow;
            int nCol = lCol - tgtCol;
            if (nRow != 0 || nCol != 0) {
                sheet.moveCell(tgtRow, tgtCol, tgtRow, tgtCol, nRow, nCol);
            }
            SCellStyle source = target.getCellStyle();
            SCellStyleBuilder csb = sheet.getBook().addCellStyle(source);
            if (lBorder != null) {
                csb.borderLeft(lBorder.getBorderType()).borderLeftColor(lBorder.getColor().getHtmlColor());
            }
            if (tBorder != null) {
                csb.borderTop(tBorder.getBorderType()).borderTopColor(tBorder.getColor().getHtmlColor());
            }
            if (rBorder != null) {
                csb.borderRight(rBorder.getBorderType()).borderRightColor(rBorder.getColor().getHtmlColor());
            }
            if (bBorder != null) {
                csb.borderBottom(bBorder.getBorderType()).borderBottomColor(bBorder.getColor().getHtmlColor());
            }
            style = (SCellStyle)csb.build();
            target.setCellStyle(style);
        }
        this.setRowCustomHeight(sheet, tRow);
        for (int c = lCol + 1; c <= rCol; ++c) {
            SCell cell = sheet.getCell(tRow, c);
            if (style != null) {
                cell.setCellStyle(style);
            }
            cell.setValue(null);
        }
        for (int r = tRow + 1; r <= bRow; ++r) {
            for (int c = lCol; c <= rCol; ++c) {
                SCell cell = sheet.getCell(r, c);
                cell.setCellStyle(style);
                cell.setValue(null);
            }
            this.setRowCustomHeight(sheet, r);
        }
        CellRegion mergeArea = new CellRegion(tRow, lCol, bRow, rCol);
        sheet.addMergedRegion(mergeArea);
    }
}

