/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl;

import io.keikai.model.CellRegion;
import io.keikai.model.InvalidModelOpException;
import io.keikai.model.SCell;
import io.keikai.model.SRow;
import io.keikai.model.SSheet;
import io.keikai.model.STable;
import io.keikai.model.impl.AbstractRowAdv;
import io.keikai.model.impl.AbstractSheetAdv;
import io.keikai.range.SRange;
import io.keikai.range.impl.RangeHelperBase;
import java.util.Iterator;
import java.util.List;

public class DataRegionHelper
extends RangeHelperBase {
    private static final long serialVersionUID = 7502892116280609724L;

    public DataRegionHelper(SRange range) {
        super(range);
    }

    public static boolean isOneCell(SSheet sheet, CellRegion rng) {
        if (rng.isSingle()) {
            return true;
        }
        int l = rng.getColumn();
        int t = rng.getRow();
        int r = rng.getLastColumn();
        int b = rng.getLastRow();
        int s = sheet.getNumOfMergedRegion();
        for (int i = 0; i < s; ++i) {
            CellRegion ref = sheet.getMergedRegion(i);
            int top = ref.getRow();
            int bottom = ref.getLastRow();
            int left = ref.getColumn();
            int right = ref.getLastColumn();
            if (l != left || t != top || r != right || b != bottom) continue;
            return true;
        }
        return false;
    }

    public CellRegion findCustomSortRegion() {
        CellRegion currentArea = new CellRegion(this.getRow(), this.getColumn(), this.getLastRow(), this.getLastColumn());
        if (DataRegionHelper.isOneCell(this.sheet, currentArea)) {
            FilterRegionHelper frHelper = new FilterRegionHelper();
            CellRegion cra = frHelper.findOutlineRegion(this.sheet, this.getRow(), this.getColumn(), this.getRow(), this.getColumn());
            if (cra == null) {
                throw new InvalidModelOpException("This cannot be applied to the selected range");
            }
            return cra;
        }
        return currentArea;
    }

    public CellRegion findAutoFilterDataRegion() {
        CellRegion currentArea = new CellRegion(this.getRow(), this.getColumn(), this.getLastRow(), this.getLastColumn());
        FilterRegionHelper frHelper = new FilterRegionHelper();
        if (this.isWholeRow()) {
            if (this.isPartialOverlapTables()) {
                throw new InvalidModelOpException("Range overlaps the table");
            }
            return frHelper.getRowCurrentRegion(this.sheet, this.getRow(), this.getLastRow());
        }
        if (DataRegionHelper.isOneCell(this.sheet, currentArea)) {
            return frHelper.findOutlineRegion(this.sheet, this.getRow(), this.getColumn(), this.getRow(), this.getColumn());
        }
        if (this.isPartialOverlapTables()) {
            throw new InvalidModelOpException("Range " + currentArea.getReferenceString() + " overlaps the table");
        }
        CellRegion region = frHelper.findOutlineRegion(this.sheet, this.getRow(), this.getColumn(), this.getLastRow(), this.getLastColumn());
        if (region == null) {
            return null;
        }
        int row = Math.max(this.getRow(), region.getRow());
        int col = Math.max(this.getColumn(), region.getColumn());
        int lastRow = region.getLastRow();
        int lastCol = Math.min(this.getLastColumn(), region.getLastColumn());
        if (row > lastRow || col > lastCol) {
            return null;
        }
        return new CellRegion(row, col, lastRow, lastCol);
    }

    private boolean isPartialOverlapTables() {
        List<STable> tables = this.sheet.getTables();
        int col = this.getColumn();
        int lastCol = this.getLastColumn();
        int row = this.getRow();
        int lastRow = this.getLastRow();
        for (STable table : tables) {
            CellRegion rgn = table.getAllRegion().getRegion();
            if (rgn.getColumn() > lastCol || rgn.getLastColumn() < col || rgn.getRow() > lastRow || rgn.getLastRow() < row) continue;
            return true;
        }
        return false;
    }

    public static class FilterRegionHelper {
        private static int LTRB_L = 0;
        private static int LTRB_T = 1;
        private static int LTRB_R = 2;
        private static int LTRB_B = 3;
        private static int LR_L = 0;
        private static int LR_R = 1;
        int llm;
        int tlm;
        int rlm;
        int blm;

        private int[] getRowMinMax(SSheet sheet, SRow row) {
            int rowIndex = row.getIndex();
            int sc = sheet.getStartCellIndex(rowIndex);
            int es = sheet.getEndCellIndex(rowIndex);
            if (sc == -1) {
                return null;
            }
            return this.getRowMinMax(sheet, row, sc, es);
        }

        private int[] getRowMinMax(SSheet sheet, SRow row, int startCol, int endCol) {
            int[] nArray;
            int rowIdx = row.getIndex();
            int minc = startCol;
            int maxc = endCol;
            int minr = rowIdx;
            int maxr = rowIdx;
            boolean found = false;
            Iterator<SCell> iter = row.getCellIterator(startCol, endCol);
            while (iter.hasNext()) {
                int[] ltrb = this.getCellMinMax(sheet, rowIdx, iter);
                if (ltrb == null) continue;
                found = true;
                minc = Math.min(minc, ltrb[LTRB_L]);
                minr = Math.min(minr, ltrb[LTRB_T]);
                maxc = Math.max(maxc, ltrb[LTRB_R]);
                minr = Math.max(minr, ltrb[LTRB_B]);
            }
            if (found) {
                int[] nArray2 = new int[4];
                nArray2[0] = minc;
                nArray2[1] = minr;
                nArray2[2] = maxc;
                nArray = nArray2;
                nArray2[3] = maxr;
            } else {
                nArray = null;
            }
            return nArray;
        }

        int[] getCellMinMax(SSheet sheet, int row, Iterator<SCell> iter) {
            int[] nArray;
            int b;
            int r;
            int t;
            int l;
            SCell ltCell = iter.next();
            int col = ltCell.getColumnIndex();
            if (this.tlm > row || this.blm < row || this.llm > col || this.rlm < col) {
                return null;
            }
            CellRegion rng = sheet.getMergedRegion(row, col);
            if (rng != null) {
                l = rng.getColumn();
                t = rng.getRow();
                r = rng.getLastColumn();
                b = rng.getLastRow();
                if (t != row || l != col) {
                    ltCell = sheet.getCell(t, l);
                }
            } else {
                l = col;
                t = row;
                r = col;
                b = row;
            }
            if (RangeHelperBase.isBlank(ltCell)) {
                nArray = null;
            } else {
                int[] nArray2 = new int[4];
                nArray2[0] = l;
                nArray2[1] = t;
                nArray2[2] = r;
                nArray = nArray2;
                nArray2[3] = b;
            }
            return nArray;
        }

        CellRegion findOutlineRegion(SSheet sheet, int row, int col, int lastRow, int lastCol) {
            return this.findOutlineRegion0(sheet, row, col, lastRow, lastCol);
        }

        private void calcBoundaries(SSheet sheet, int row, int col, int lastRow, int lastCol) {
            int b;
            int t;
            int r;
            int l;
            CellRegion rgn;
            this.llm = 0;
            this.rlm = Integer.MAX_VALUE;
            this.tlm = 0;
            this.blm = Integer.MAX_VALUE;
            for (STable tb : sheet.getTables()) {
                rgn = tb.getAllRegion().getRegion();
                l = rgn.getColumn();
                r = rgn.getLastColumn();
                t = rgn.getRow();
                b = rgn.getLastRow();
                if (l > col || lastCol > r) continue;
                if (row < t && this.blm >= t) {
                    this.blm = t - 1;
                }
                if (lastRow <= b || this.tlm > b) continue;
                this.tlm = b + 1;
            }
            for (STable tb : sheet.getTables()) {
                rgn = tb.getAllRegion().getRegion();
                l = rgn.getColumn();
                r = rgn.getLastColumn();
                t = rgn.getRow();
                b = rgn.getLastRow();
                if (t > this.blm || b < this.tlm) continue;
                if (col < l && this.rlm >= l) {
                    this.rlm = l - 1;
                }
                if (lastCol <= r || this.llm > r) continue;
                this.llm = r + 1;
            }
            int sr = sheet.getStartRowIndex();
            int er = sheet.getEndRowIndex();
            if (sr != -1 && sr > this.tlm) {
                this.tlm = sr;
            }
            if (er != -1 && er < this.blm) {
                this.blm = er;
            }
        }

        private void calcBoundaries(SSheet sheet, int row, int lastRow) {
            this.llm = 0;
            this.tlm = row;
            this.rlm = Integer.MAX_VALUE;
            this.blm = lastRow;
        }

        private CellRegion findOutlineRegion0(SSheet sheet, int row, int col, int lastRow, int lastCol) {
            AbstractSheetAdv absSheetAdv = (AbstractSheetAdv)sheet;
            STable table = absSheetAdv.getTableByRowCol(row, col);
            if (table != null) {
                return table.getDataRegion().getRegion();
            }
            this.calcBoundaries(sheet, row, col, lastRow, lastCol);
            int t = row > this.tlm ? row - 1 : row;
            int b = lastRow < this.blm ? lastRow + 1 : lastRow;
            int l = col > this.llm ? col - 1 : col;
            int r = lastCol < this.rlm ? lastCol + 1 : lastCol;
            int tt = Integer.MAX_VALUE;
            int bb = -1;
            int ll = Integer.MAX_VALUE;
            int rr = -1;
            Iterator<SRow> iter = sheet.getRowIterator(t, b);
            while (iter.hasNext()) {
                SRow srow = iter.next();
                Iterator<SCell> cellIter = srow.getCellIterator(l, r);
                while (cellIter.hasNext()) {
                    int[] ltrb = this.getCellMinMax(sheet, srow.getIndex(), cellIter);
                    if (ltrb == null) continue;
                    ll = Math.min(ll, ltrb[LTRB_L]);
                    tt = Math.min(tt, ltrb[LTRB_T]);
                    rr = Math.max(rr, ltrb[LTRB_R]);
                    bb = Math.max(bb, ltrb[LTRB_B]);
                }
            }
            if (tt > bb || ll > rr) {
                return null;
            }
            return this.findCurrentRegion0(absSheetAdv, tt, ll, bb, rr);
        }

        private boolean isRowBlank(AbstractRowAdv row, int start, int end) {
            int index = row.getIndex();
            Iterator<SCell> iter = row.getCellIterator(start, end);
            while (iter.hasNext()) {
                int[] ltrb = this.getCellMinMax(row.getSheet(), index, iter);
                if (ltrb == null) continue;
                return false;
            }
            return true;
        }

        private int[] getNonBlankCell(AbstractSheetAdv sheet, AbstractRowAdv row, int left, int right) {
            if (this.isRowBlank(row, left, right)) {
                return null;
            }
            int rowIdx = row.getIndex();
            int minc = left;
            if (this.llm <= left - 1) {
                Iterator<SCell> leftIter = row.getCellIterator(true, this.llm, left - 1);
                while (leftIter.hasNext()) {
                    int[] ltrb = this.getCellMinMax(sheet, rowIdx, leftIter);
                    if (ltrb == null) continue;
                    if (minc - 1 > ltrb[LTRB_R]) break;
                    minc = ltrb[LTRB_L];
                }
            }
            int maxc = right;
            if (this.rlm >= right + 1) {
                Iterator<SCell> rightIter = row.getCellIterator(right + 1, this.rlm);
                while (rightIter.hasNext()) {
                    int[] ltrb = this.getCellMinMax(sheet, rowIdx, rightIter);
                    if (ltrb == null) continue;
                    if (maxc + 1 < ltrb[LTRB_L]) break;
                    maxc = ltrb[LTRB_R];
                }
            }
            return new int[]{minc, maxc};
        }

        private CellRegion findCurrentRegion0(AbstractSheetAdv sheet, int row, int col, int lastRow, int lastCol) {
            int b1;
            int t1;
            int[] lr;
            int l = col;
            int t = row;
            int r = lastCol;
            int b = lastRow;
            int t0 = t - 1;
            int b0 = b + 1;
            if (t0 >= this.tlm) {
                AbstractRowAdv topRow;
                Iterator<AbstractRowAdv> topIter = sheet.getRowIterator(true, this.tlm, t0);
                while (topIter.hasNext() && (topRow = topIter.next()).getIndex() >= t0 && (lr = this.getNonBlankCell(sheet, topRow, l, r)) != null) {
                    t = t0--;
                    l = Math.min(l, lr[LR_L]);
                    r = Math.max(r, lr[LR_R]);
                }
            }
            if (b0 <= this.blm) {
                SRow next;
                Iterator<SRow> bottomIter = sheet.getRowIterator(b0, this.blm);
                while (bottomIter.hasNext() && (next = bottomIter.next()).getIndex() <= b0 && (lr = this.getNonBlankCell(sheet, (AbstractRowAdv)next, l, r)) != null) {
                    b = b0++;
                    l = Math.min(l, lr[LR_L]);
                    r = Math.max(r, lr[LR_R]);
                }
            }
            if ((t1 = Math.max(this.tlm, t - 1)) <= (b1 = Math.min(b + 1, this.blm))) {
                Iterator<SRow> iter = sheet.getRowIterator(t1, b1);
                block2: while (iter.hasNext()) {
                    int r0;
                    SRow srow = iter.next();
                    int rowIndex = srow.getIndex();
                    int l0 = l - 1;
                    if (l0 >= this.llm) {
                        Iterator<SCell> leftIter = ((AbstractRowAdv)srow).getCellIterator(true, this.llm, l0);
                        while (leftIter.hasNext()) {
                            int[] ltrb = this.getCellMinMax(sheet, rowIndex, leftIter);
                            if (ltrb == null) continue;
                            if (l0 > ltrb[LTRB_R]) break;
                            l = l0;
                            l0 = ltrb[LTRB_L];
                            t = Math.min(t, ltrb[LTRB_T]);
                            b = Math.max(b, ltrb[LTRB_B]);
                        }
                    }
                    if ((r0 = r + 1) > this.rlm) continue;
                    boolean isExtended = false;
                    Iterator<SCell> rightIter = srow.getCellIterator(r0, this.rlm);
                    while (rightIter.hasNext()) {
                        int[] ltrb = this.getCellMinMax(sheet, rowIndex, rightIter);
                        if (ltrb == null) continue;
                        if (r0 < ltrb[LTRB_L]) continue block2;
                        r = r0;
                        r0 = ltrb[LTRB_R];
                        t = Math.min(t, ltrb[LTRB_T]);
                        b = Math.max(b, ltrb[LTRB_B]);
                    }
                }
            }
            if (l == col && t == row && r == lastCol && b == lastRow) {
                if (l == r && t == b && RangeHelperBase.isBlank(sheet.getCell(t, l))) {
                    return null;
                }
                return new CellRegion(t, l, b, r);
            }
            return this.findCurrentRegion0(sheet, t, l, b, r);
        }

        private CellRegion getRowCurrentRegion(SSheet sheet, int topRow, int btmRow) {
            this.calcBoundaries(sheet, topRow, btmRow);
            int minc = -1;
            int maxc = -1;
            int minr = -1;
            int maxr = -1;
            boolean found = false;
            Iterator<SRow> iter = sheet.getRowIterator(topRow, btmRow);
            while (iter.hasNext()) {
                SRow row = iter.next();
                int[] ltrb = this.getRowMinMax(sheet, row);
                if (ltrb == null) continue;
                if (found) {
                    minc = Math.min(minc, ltrb[LTRB_L]);
                    minr = Math.min(minr, ltrb[LTRB_T]);
                    maxc = Math.max(maxc, ltrb[LTRB_R]);
                    maxr = Math.max(maxr, ltrb[LTRB_B]);
                    continue;
                }
                found = true;
                minc = ltrb[LTRB_L];
                minr = ltrb[LTRB_T];
                maxc = ltrb[LTRB_R];
                maxr = ltrb[LTRB_B];
            }
            return found ? new CellRegion(minr, minc, maxr, maxc) : null;
        }
    }
}

