/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl.sys.formula;

import io.keikai.model.CellRegion;
import io.keikai.model.ErrorValue;
import io.keikai.model.SBook;
import io.keikai.model.SCell;
import io.keikai.model.SRow;
import io.keikai.model.SSheet;
import io.keikai.model.impl.AbstractCellAdv;
import io.keikai.model.impl.AbstractRowAdv;
import io.keikai.model.impl.AbstractSheetAdv;
import io.keikai.model.impl.CellImpl;
import io.keikai.model.sys.formula.FormulaExpression;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.poi.ss.formula.EvaluationCell;
import org.apache.poi.ss.formula.EvaluationSheet;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.util.CellRangeAddress;

public class EvalSheet
implements EvaluationSheet,
Serializable {
    private static final long serialVersionUID = -4811427512834490081L;
    private SSheet _sheet;

    public EvalSheet(SSheet sheet) {
        this._sheet = sheet;
    }

    public SSheet getNSheet() {
        return this._sheet;
    }

    public EvaluationCell getCell(int rowIndex, int columnIndex) {
        if (rowIndex > this._sheet.getEndRowIndex()) {
            return null;
        }
        SCell cell = this._sheet.getCell(rowIndex, columnIndex);
        return cell.isNull() ? null : new EvalCell(this, cell);
    }

    public Iterator<EvaluationCell> nonEmptyCellsIterator(int rowStart, int rowEnd, int columnStart, int columnEnd) {
        LinkedList<EvalCell> result = new LinkedList<EvalCell>();
        Iterator<SRow> rowIterator = this._sheet.getRowIterator(rowStart, rowEnd);
        while (rowIterator.hasNext()) {
            SRow row = rowIterator.next();
            Iterator<SCell> cellIterator = ((AbstractRowAdv)row).getCellIterator(false, columnStart, columnEnd);
            while (cellIterator.hasNext()) {
                SCell cell = cellIterator.next();
                if (cell.isNull() || cell.getType() == SCell.CellType.BLANK) continue;
                result.add(new EvalCell(this, cell));
            }
        }
        return result.iterator();
    }

    public Iterator<EvaluationCell> nonEmptyCellsIterator(int columnIndex) {
        LinkedList<EvalCell> result = new LinkedList<EvalCell>();
        Iterator<SRow> rowIterator = this._sheet.getRowIterator();
        while (rowIterator.hasNext()) {
            SRow row = rowIterator.next();
            AbstractCellAdv cell = ((AbstractRowAdv)row).getCell(columnIndex, false);
            if (cell == null || cell.getType() == SCell.CellType.BLANK) continue;
            result.add(new EvalCell(this, cell));
        }
        return result.iterator();
    }

    public void clearAllCachedResultValues() {
    }

    public int getLastRowNum() {
        return this._sheet.getEndRowIndex();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._sheet == null ? 0 : this._sheet.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EvalSheet other = (EvalSheet)obj;
        return this._sheet == other._sheet;
    }

    public boolean isHidden(int rowIndex, int columnIndex) {
        return ((AbstractSheetAdv)this._sheet).isHidden(rowIndex, columnIndex);
    }

    public boolean isRowHidden(int rowIndex) {
        return ((AbstractSheetAdv)this._sheet).isRowHidden(rowIndex);
    }

    public boolean isFiltered() {
        return ((AbstractSheetAdv)this._sheet).isFiltered();
    }

    private static class Key {
        public String bookName;
        public int sheet;
        public int row;
        public int column;

        public Key(String bookName, int sheet, int row, int column) {
            this.bookName = bookName;
            this.sheet = sheet;
            this.row = row;
            this.column = column;
        }

        public int hashCode() {
            int prime = 31;
            int result = this.bookName == null ? 1 : this.bookName.hashCode();
            result = 31 * result + this.column;
            result = 31 * result + this.row;
            result = 31 * result + this.sheet;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.bookName != other.bookName || this.bookName != null && !this.bookName.equals(other.bookName)) {
                return false;
            }
            if (this.column != other.column) {
                return false;
            }
            if (this.row != other.row) {
                return false;
            }
            return this.sheet == other.sheet;
        }
    }

    static class EvalCell
    implements EvaluationCell {
        private SCell cell;
        private Key key;
        private int _formulaMaxIterations = -1;
        private double _formulaMaxChange = -1.0;
        private EvalSheet _sheet;

        public EvalCell(EvalSheet esheet, SCell cell) {
            this.cell = cell;
            this._sheet = esheet;
            SSheet sheet = cell.getSheet();
            SBook book = sheet.getBook();
            int sheetIndex = book.getSheetIndex(sheet);
            this.key = new Key(book.getBookName(), sheetIndex, cell.getRowIndex(), cell.getColumnIndex());
            this._formulaMaxIterations = book.getFormulaMaxIterations();
            this._formulaMaxChange = book.getFormulaMaxChange();
        }

        public Object getIdentityKey() {
            return this.key;
        }

        public EvaluationSheet getSheet() {
            return this._sheet;
        }

        public int getRowIndex() {
            return this.cell.getRowIndex();
        }

        public int getColumnIndex() {
            return this.cell.getColumnIndex();
        }

        public CellType getCellType() {
            switch (this.cell.getType()) {
                case BLANK: {
                    return CellType.BLANK;
                }
                case BOOLEAN: {
                    return CellType.BOOLEAN;
                }
                case ERROR: {
                    return CellType.ERROR;
                }
                case FORMULA: {
                    return CellType.FORMULA;
                }
                case NUMBER: {
                    return CellType.NUMERIC;
                }
                case STRING: {
                    return CellType.STRING;
                }
            }
            return CellType._NONE;
        }

        public double getNumericCellValue() {
            return this.cell.getNumberValue();
        }

        public String getStringCellValue() {
            if (this.cell.getType() == SCell.CellType.FORMULA) {
                return this.cell.getFormulaValue();
            }
            if (this.cell.getType() == SCell.CellType.STRING) {
                return this.cell.getStringValue();
            }
            return null;
        }

        public boolean getBooleanCellValue() {
            return this.cell.getBooleanValue();
        }

        public int getErrorCellValue() {
            ErrorValue errorValue = this.cell.getErrorValue();
            switch (errorValue.getCode()) {
                case 127: {
                    return FormulaError.NA.getCode();
                }
            }
            return errorValue.getCode();
        }

        public CellRangeAddress getArrayFormulaRange() {
            CellRegion arrayFormulaRange = this.cell.getArrayFormulaRegion();
            if (arrayFormulaRange == null) {
                return null;
            }
            return CellRangeAddress.valueOf((String)arrayFormulaRange.getReferenceString());
        }

        public boolean isPartOfArrayFormulaGroup() {
            return this.cell.isPartOfArrayFormulaGroup();
        }

        public CellType getCachedFormulaResultType() {
            return this.getCellType();
        }

        public String toString() {
            return this.getRowIndex() + ":" + this.getColumnIndex() + " " + this.getStringCellValue();
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof EvaluationCell)) {
                return false;
            }
            return this.key.equals(((EvaluationCell)obj).getIdentityKey());
        }

        public FormulaExpression getFormulaExpression() {
            return this.cell.getType() == SCell.CellType.FORMULA ? (FormulaExpression)((CellImpl)this.cell).getValue(false) : null;
        }

        public Object getInitValue() {
            Object val = ((AbstractCellAdv)this.cell).getInitValue();
            if (val instanceof Double) {
                return (Double)val;
            }
            if (val instanceof Number) {
                return ((Number)val).doubleValue();
            }
            if (val instanceof Boolean) {
                return (Boolean)val != false ? 1.0 : 0.0;
            }
            return 0.0;
        }

        public int getFormulaMaxIterations() {
            return this._formulaMaxIterations;
        }

        public double getFormulaMaxChange() {
            return this._formulaMaxChange;
        }
    }
}

