/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl.sys;

import io.keikai.model.CellRegion;
import io.keikai.model.SBook;
import io.keikai.model.SCell;
import io.keikai.model.SSheet;
import io.keikai.model.STableStyle;
import io.keikai.model.impl.AbstractBookAdv;
import io.keikai.model.impl.ReadOnlyRichTextImpl;
import io.keikai.model.impl.TableStyleNone;
import io.keikai.model.impl.sys.FormatResultImpl;
import io.keikai.model.sys.EngineFactory;
import io.keikai.model.sys.format.FormatContext;
import io.keikai.model.sys.format.FormatEngine;
import io.keikai.model.sys.format.FormatResult;
import io.keikai.range.impl.imexp.UnitUtil;
import java.text.Format;
import java.util.Locale;
import org.apache.poi.ss.format.CellFormat;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.ZssContext;
import org.apache.poi.ss.util.NumberToTextConverter;

public class FormatEngineImpl
implements FormatEngine {
    private static final int TIME = 19;
    private static final int DATE = 14;
    private static final int DATE_TIME = 256;

    @Override
    public FormatResult format(SCell cell, FormatContext context) {
        SCell.CellType type = cell.getType();
        if (type == SCell.CellType.FORMULA) {
            type = cell.getFormulaResultType();
        }
        String format = cell.getCellStyle().getDataFormat();
        if (type == SCell.CellType.BLANK) {
            return new FormatResultImpl(cell.getStringValue(), null);
        }
        if (type == SCell.CellType.STRING) {
            if (cell.isRichTextValue()) {
                return new FormatResultImpl(new ReadOnlyRichTextImpl(cell.getRichTextValue()));
            }
            if ("General".equals(format)) {
                return new FormatResultImpl(cell.getStringValue(), null);
            }
        } else if (type == SCell.CellType.ERROR) {
            return new FormatResultImpl(cell.getErrorValue().getErrorString(), null);
        }
        int cellWidth = FormatEngineImpl.getCellWidth256(cell) >> 8;
        return this.format0(cell.getCellStyle().getDataFormat(), cell.getCellStyle().isDirectDataFormat(), cell.getValue(), context, cellWidth);
    }

    @Override
    public FormatResult format(String format, Object value, FormatContext context, int cellWidth) {
        return this.format0(format, false, value, context, cellWidth);
    }

    protected CellFormat getCellFormat(String formatStr, Locale locale) {
        return CellFormat.getInstance((Locale)locale, (String)formatStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FormatResult format0(String format, boolean direct, Object value, FormatContext context, int cellWidth) {
        ZssContext old = ZssContext.getThreadLocal();
        try {
            int i;
            ZssContext zssContext = old == null ? new ZssContext(context.getLocale(), -1) : new ZssContext(context.getLocale(), old.getTwoDigitYearUpperBound());
            ZssContext.setThreadLocal((ZssContext)zssContext);
            if (!direct && (i = BuiltinFormats.getBuiltinFormat((String)format)) >= 0) {
                format = BuiltinFormats.getBuiltinFormat((int)i, (Locale)context.getLocale());
            }
            format = FormatEngineImpl.normalizeFormat(format);
            CellFormat formatter = this.getCellFormat(format, context.getLocale());
            Format javaFormat = null;
            if (value instanceof Number) {
                javaFormat = DataFormatter.getJavaFormat((double)((Number)value).doubleValue(), (String)format, (Locale)context.getLocale());
            }
            boolean dateFromatted = false;
            if (value instanceof Double && formatter.isApplicableDateFormat((Double)value)) {
                value = EngineFactory.getInstance().getCalendarUtil().doubleValueToDate((Double)value);
                dateFromatted = true;
            }
            FormatResultImpl formatResultImpl = new FormatResultImpl(formatter.apply(value, cellWidth), javaFormat, dateFromatted);
            return formatResultImpl;
        }
        finally {
            ZssContext.setThreadLocal((ZssContext)old);
        }
    }

    @Override
    public String getLocalizedFormat(String format, FormatContext context) {
        return this.getFormat0(format, false, context);
    }

    @Override
    public String getFormat(SCell cell, FormatContext context) {
        return this.getFormat0(cell.getCellStyle().getDataFormat(), cell.getCellStyle().isDirectDataFormat(), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFormat0(String format, boolean direct, FormatContext context) {
        ZssContext old = ZssContext.getThreadLocal();
        try {
            int i;
            ZssContext zssContext = old == null ? new ZssContext(context.getLocale(), -1) : new ZssContext(context.getLocale(), old.getTwoDigitYearUpperBound());
            ZssContext.setThreadLocal((ZssContext)zssContext);
            if (!direct && (i = BuiltinFormats.getBuiltinFormat((String)format)) >= 0) {
                format = BuiltinFormats.getBuiltinFormat((int)i, (Locale)context.getLocale());
            }
            String string = format = FormatEngineImpl.normalizeFormat(format);
            return string;
        }
        finally {
            ZssContext.setThreadLocal((ZssContext)old);
        }
    }

    private boolean isDateFormatted(String format, Double value, Locale locale) {
        CellFormat formatter = CellFormat.getInstance((Locale)locale, (String)format);
        return formatter.isApplicableDateFormat(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getEditText(SCell cell, FormatContext context) {
        ZssContext old = ZssContext.getThreadLocal();
        try {
            ZssContext zssContext = old == null ? new ZssContext(context.getLocale(), -1) : new ZssContext(context.getLocale(), old.getTwoDigitYearUpperBound());
            ZssContext.setThreadLocal((ZssContext)zssContext);
            Locale locale = context.getLocale();
            SCell.CellType cellType = cell.getType();
            switch (cellType) {
                case BLANK: {
                    String string = "";
                    return string;
                }
                case BOOLEAN: {
                    String string = cell.getBooleanValue() != false ? "TRUE" : "FALSE";
                    return string;
                }
                case ERROR: {
                    String string = cell.getErrorValue().getErrorString();
                    return string;
                }
                case FORMULA: {
                    String string = "=" + this.getFormulaEditText(cell);
                    return string;
                }
                case NUMBER: {
                    double val = cell.getNumberValue();
                    if (this.isDateFormatted(cell.getCellStyle().getDataFormat(), val, locale)) {
                        String string = FormatEngineImpl.getDateTimeString(val, locale);
                        return string;
                    }
                    String string = NumberToTextConverter.toText((double)val);
                    return string;
                }
                case STRING: {
                    String string = cell.getStringValue();
                    return string;
                }
            }
            return "";
        }
        finally {
            ZssContext.setThreadLocal((ZssContext)old);
        }
    }

    private static String normalizeFormat(String format) {
        if (format == null || "".equals(format.trim())) {
            format = "General";
        }
        return format;
    }

    private static String getDateFormatString(int formatType, Locale locale) {
        return BuiltinFormats.getBuiltinFormat((int)formatType, (Locale)locale);
    }

    private static boolean isInteger(Object value) {
        if (value instanceof Number) {
            return (double)((Number)value).intValue() == ((Number)value).doubleValue();
        }
        return false;
    }

    public static String getDateTimeString(double val, Locale locale) {
        String formatString = null;
        if (Math.abs(val) < 1.0) {
            formatString = FormatEngineImpl.getDateFormatString(19, locale);
            if (formatString == null) {
                formatString = "h:mm:ss AM/PM";
            }
        } else if (FormatEngineImpl.isInteger(val)) {
            formatString = FormatEngineImpl.getDateFormatString(14, locale);
            if (formatString == null) {
                formatString = "mm/dd/yyyy";
            }
        } else {
            formatString = FormatEngineImpl.getDateFormatString(256, locale);
            if (formatString == null) {
                formatString = "mm/dd/yyyy h:mm:ss AM/PM";
            }
        }
        boolean date1904 = false;
        return new DataFormatter(locale, false).formatRawCellContents(val, -1, formatString, false);
    }

    public static int getCellWidth256(SCell cell) {
        int endCol;
        int rotate = cell.getCellStyle().getRotation();
        if (rotate == 255) {
            return 3072;
        }
        SSheet sheet = cell.getSheet();
        CellRegion region = sheet.getMergedRegion(cell.getRowIndex(), cell.getColumnIndex());
        int px = 0;
        if (rotate == 90 || rotate == -90) {
            if (region != null) {
                endCol = region.getLastRow();
                for (int row = region.getRow(); row <= endCol; ++row) {
                    px += sheet.getRow(row).getHeight();
                }
            } else {
                px = sheet.getRow(cell.getRowIndex()).getHeight();
            }
        } else if (region != null) {
            endCol = region.getLastColumn();
            for (int col = region.getColumn(); col <= endCol; ++col) {
                px += sheet.getColumn(col).getWidth();
            }
        } else {
            px = sheet.getColumn(cell.getColumnIndex()).getWidth();
        }
        AbstractBookAdv book = (AbstractBookAdv)sheet.getBook();
        return UnitUtil.pxToFileChar256(px -= 5, book.getCharWidth());
    }

    protected String getFormulaEditText(SCell cell) {
        return cell.getFormulaValue();
    }

    @Override
    public STableStyle getTableStyle(SBook book, String name) {
        return TableStyleNone.instance;
    }

    @Override
    public STableStyle getExistTableStyle(SBook book, String name) {
        return null;
    }
}

