/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl.chart;

import io.keikai.model.ErrorValue;
import io.keikai.model.SCell;
import io.keikai.model.SColor;
import io.keikai.model.SSheet;
import io.keikai.model.chart.SSeries;
import io.keikai.model.impl.AbstractBookSeriesAdv;
import io.keikai.model.impl.AbstractChartAdv;
import io.keikai.model.impl.AbstractSeriesAdv;
import io.keikai.model.impl.EvaluationUtil;
import io.keikai.model.impl.LinkedModelObject;
import io.keikai.model.impl.ObjectRefImpl;
import io.keikai.model.impl.chart.ChartUtil;
import io.keikai.model.sys.EngineFactory;
import io.keikai.model.sys.dependency.Ref;
import io.keikai.model.sys.format.FormatContext;
import io.keikai.model.sys.format.FormatEngine;
import io.keikai.model.sys.formula.EvaluationResult;
import io.keikai.model.sys.formula.FormulaEngine;
import io.keikai.model.sys.formula.FormulaEvaluationContext;
import io.keikai.model.sys.formula.FormulaExpression;
import io.keikai.model.sys.formula.FormulaParseContext;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.formula.LazyRefEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.usermodel.ZssContext;

public class SeriesImpl
extends AbstractSeriesAdv
implements SSeries,
Serializable,
LinkedModelObject {
    private static final long serialVersionUID = 1L;
    private FormulaExpression _nameExpr;
    private FormulaExpression _valueExpr;
    private FormulaExpression _yValueExpr;
    private FormulaExpression _zValueExpr;
    private AbstractChartAdv _chart;
    private final String _id;
    private Object _evalNameResult;
    private Object _evalValuesResult;
    private Object _evalYValuesResult;
    private Object _evalZValuesResult;
    private boolean[] _hiddenNameInfo;
    private boolean[] _hiddenValuesInfo;
    private boolean[] _hiddenYValuesInfo;
    private boolean[] _hiddenZValuesInfo;
    private boolean _evaluated = false;
    private boolean _visibleEvaluated = false;
    private SColor _defaultColor;
    private int _order;
    private boolean _smooth;
    private boolean _dataLabelsVisible;
    private Map<Integer, SColor> _dataPointColors = new HashMap<Integer, SColor>(2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void evalFormula() {
        if (this._evaluated) {
            return;
        }
        SeriesImpl seriesImpl = this;
        synchronized (seriesImpl) {
            if (!this._evaluated) {
                Object val;
                EvaluationResult result;
                FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
                SSheet sheet = this._chart.getSheet();
                Ref ref = this.getRef();
                if (this._nameExpr != null) {
                    result = fe.evaluate(this._nameExpr, new FormulaEvaluationContext(sheet, ref));
                    val = result.getValue();
                    if (result.getType() == EvaluationResult.ResultType.SUCCESS) {
                        ValueEval valueEval = result.getValueEval();
                        if (valueEval instanceof LazyRefEval) {
                            FormatEngine formatEngine = EngineFactory.getInstance().createFormatEngine();
                            LazyRefEval lazyRefEval = (LazyRefEval)valueEval;
                            String bookName = lazyRefEval.getBookName();
                            String sheetName = lazyRefEval.getSheetName();
                            SCell cell = sheet.getBook().getBookSeries().getBook(bookName).getSheetByName(sheetName).getCell(lazyRefEval.getRow(), lazyRefEval.getColumn());
                            val = formatEngine.format(cell, new FormatContext(ZssContext.getCurrent().getLocale())).getText();
                        }
                        this._evalNameResult = val;
                    } else if (result.getType() == EvaluationResult.ResultType.ERROR) {
                        Object object = this._evalNameResult = val instanceof ErrorValue ? val : ErrorValue.valueOf((byte)15);
                    }
                }
                if (this._valueExpr != null) {
                    result = fe.evaluate(this._valueExpr, new FormulaEvaluationContext(sheet, ref));
                    val = result.getValue();
                    if (result.getType() == EvaluationResult.ResultType.SUCCESS) {
                        this._evalValuesResult = val;
                    } else if (result.getType() == EvaluationResult.ResultType.ERROR) {
                        Object object = this._evalValuesResult = val instanceof ErrorValue ? val : ErrorValue.valueOf((byte)15);
                    }
                }
                if (this._yValueExpr != null) {
                    result = fe.evaluate(this._yValueExpr, new FormulaEvaluationContext(sheet, ref));
                    val = result.getValue();
                    if (result.getType() == EvaluationResult.ResultType.SUCCESS) {
                        this._evalYValuesResult = val;
                    } else if (result.getType() == EvaluationResult.ResultType.ERROR) {
                        Object object = this._evalYValuesResult = val instanceof ErrorValue ? val : ErrorValue.valueOf((byte)15);
                    }
                }
                if (this._zValueExpr != null) {
                    result = fe.evaluate(this._zValueExpr, new FormulaEvaluationContext(sheet, ref));
                    val = result.getValue();
                    if (result.getType() == EvaluationResult.ResultType.SUCCESS) {
                        this._evalZValuesResult = val;
                    } else if (result.getType() == EvaluationResult.ResultType.ERROR) {
                        this._evalZValuesResult = val instanceof ErrorValue ? val : ErrorValue.valueOf((byte)15);
                    }
                }
                this._evaluated = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void evalVisibleInfo() {
        if (this._visibleEvaluated) {
            return;
        }
        SeriesImpl seriesImpl = this;
        synchronized (seriesImpl) {
            if (!this._visibleEvaluated) {
                HashMap<Integer, Boolean> cachedRowValues = new HashMap<Integer, Boolean>(16);
                HashMap<Integer, Boolean> cachedColumnValues = new HashMap<Integer, Boolean>(16);
                if (this._nameExpr != null) {
                    this._hiddenNameInfo = new boolean[this.getNumOfValue()];
                    ChartUtil.evalVisibleInfo(this._chart, this._nameExpr, this._hiddenNameInfo, cachedRowValues, cachedColumnValues);
                }
                if (this._valueExpr != null) {
                    this._hiddenValuesInfo = new boolean[this.getNumOfValue()];
                    ChartUtil.evalVisibleInfo(this._chart, this._valueExpr, this._hiddenValuesInfo, cachedRowValues, cachedColumnValues);
                }
                if (this._yValueExpr != null) {
                    this._hiddenYValuesInfo = new boolean[this.getNumOfYValue()];
                    ChartUtil.evalVisibleInfo(this._chart, this._yValueExpr, this._hiddenYValuesInfo, cachedRowValues, cachedColumnValues);
                }
                if (this._zValueExpr != null) {
                    this._hiddenZValuesInfo = new boolean[this.getNumOfZValue()];
                    ChartUtil.evalVisibleInfo(this._chart, this._zValueExpr, this._hiddenZValuesInfo, cachedRowValues, cachedColumnValues);
                }
                this._visibleEvaluated = true;
            }
        }
    }

    public SeriesImpl(AbstractChartAdv chart, String id) {
        this._chart = chart;
        this._id = id;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public String getName() {
        this.evalFormula();
        if (this._evalNameResult == null) {
            return null;
        }
        if (this._evalNameResult instanceof ErrorValue) {
            return ((ErrorValue)this._evalNameResult).getErrorString();
        }
        if (this._evalNameResult instanceof List) {
            return String.join((CharSequence)" ", (List)this._evalNameResult);
        }
        return this._evalNameResult.toString();
    }

    @Override
    public int getNumOfValue() {
        this.evalFormula();
        return EvaluationUtil.sizeOf(this._evalValuesResult);
    }

    @Override
    public Object getValue(int index) {
        this.evalFormula();
        if (index >= EvaluationUtil.sizeOf(this._evalValuesResult)) {
            return null;
        }
        return EvaluationUtil.valueOf(this._evalValuesResult, index);
    }

    @Override
    public int getNumOfYValue() {
        this.evalFormula();
        return EvaluationUtil.sizeOf(this._evalYValuesResult);
    }

    @Override
    public Object getYValue(int index) {
        this.evalFormula();
        if (index >= EvaluationUtil.sizeOf(this._evalYValuesResult)) {
            return null;
        }
        return EvaluationUtil.valueOf(this._evalYValuesResult, index);
    }

    @Override
    public int getNumOfZValue() {
        this.evalFormula();
        return EvaluationUtil.sizeOf(this._evalZValuesResult);
    }

    @Override
    public Object getZValue(int index) {
        this.evalFormula();
        if (index >= EvaluationUtil.sizeOf(this._evalZValuesResult)) {
            return null;
        }
        return EvaluationUtil.valueOf(this._evalZValuesResult, index);
    }

    @Override
    public void setFormula(String nameExpression, String valueExpression) {
        this.setXYZFormula(nameExpression, valueExpression, null, null);
    }

    @Override
    public void setXYFormula(String nameExpression, String xValueExpression, String yValueExpression) {
        this.setXYZFormula(nameExpression, xValueExpression, yValueExpression, null);
    }

    @Override
    public void setXYZFormula(String nameExpression, String xValueExpression, String yValueExpression, String zValueExpression) {
        this.checkOrphan();
        this._evaluated = false;
        this._visibleEvaluated = false;
        this.clearFormulaDependency();
        FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
        SSheet sheet = this._chart.getSheet();
        Ref ref = this.getRef();
        this._nameExpr = nameExpression != null ? fe.parse(nameExpression, new FormulaParseContext(sheet, ref)) : null;
        this._valueExpr = xValueExpression != null ? fe.parse(xValueExpression, new FormulaParseContext(sheet, ref)) : null;
        this._yValueExpr = yValueExpression != null ? fe.parse(yValueExpression, new FormulaParseContext(sheet, ref)) : null;
        this._zValueExpr = zValueExpression != null ? fe.parse(zValueExpression, new FormulaParseContext(sheet, ref)) : null;
    }

    @Override
    public boolean isFormulaParsingError() {
        boolean r = false;
        if (this._nameExpr != null) {
            r |= this._nameExpr.hasError();
        }
        if (!r && this._valueExpr != null) {
            r |= this._valueExpr.hasError();
        }
        if (!r && this._yValueExpr != null) {
            r |= this._yValueExpr.hasError();
        }
        if (!r && this._zValueExpr != null) {
            r |= this._zValueExpr.hasError();
        }
        return r;
    }

    @Override
    public String getNameFormula() {
        return this._nameExpr == null ? null : this._nameExpr.getFormulaString();
    }

    @Override
    public String getValuesFormula() {
        return this._valueExpr == null ? null : this._valueExpr.getFormulaString();
    }

    @Override
    public String getYValuesFormula() {
        return this._yValueExpr == null ? null : this._yValueExpr.getFormulaString();
    }

    @Override
    public String getZValuesFormula() {
        return this._zValueExpr == null ? null : this._zValueExpr.getFormulaString();
    }

    @Override
    public void clearFormulaResultCache() {
        this._evaluated = false;
        this._visibleEvaluated = false;
        this._evalZValuesResult = null;
        this._evalYValuesResult = null;
        this._evalValuesResult = null;
        this._evalNameResult = null;
        this._hiddenZValuesInfo = null;
        this._hiddenYValuesInfo = null;
        this._hiddenValuesInfo = null;
        this._hiddenNameInfo = null;
    }

    private void clearFormulaDependency() {
        if (this._nameExpr != null || this._valueExpr != null || this._yValueExpr != null || this._zValueExpr != null) {
            ((AbstractBookSeriesAdv)this._chart.getSheet().getBook().getBookSeries()).getDependencyTable().clearDependents(this.getRef());
        }
    }

    private Ref getRef() {
        return new ObjectRefImpl(this._chart, new String[]{this._chart.getId(), this._id});
    }

    @Override
    public void destroy() {
        this.checkOrphan();
        this.clearFormulaDependency();
        this.clearFormulaResultCache();
        this._chart = null;
    }

    @Override
    public void checkOrphan() {
        if (this._chart == null) {
            throw new IllegalStateException("doesn't connect to parent");
        }
    }

    @Override
    public int getNumOfXValue() {
        return this.getNumOfValue();
    }

    @Override
    public Object getXValue(int index) {
        return this.getValue(index);
    }

    @Override
    public String getXValuesFormula() {
        return this.getValuesFormula();
    }

    public SeriesImpl cloneSeriesImpl(AbstractChartAdv chart) {
        SeriesImpl tgt = new SeriesImpl(chart, this._id);
        String nexpr = this.getNameFormula();
        String vexpr = this.getValuesFormula();
        String yexpr = this.getYValuesFormula();
        String zexpr = this.getZValuesFormula();
        tgt.setXYZFormula(nexpr, vexpr, yexpr, zexpr);
        tgt._defaultColor = this._defaultColor;
        tgt._order = this._order;
        tgt._smooth = this._smooth;
        tgt._dataLabelsVisible = this._dataLabelsVisible;
        return tgt;
    }

    @Override
    public FormulaExpression getNameFormulaExpression() {
        return this._nameExpr;
    }

    @Override
    public FormulaExpression getValuesFormulaExpression() {
        return this._valueExpr;
    }

    @Override
    public FormulaExpression getXValuesFormulaExpression() {
        return this.getValuesFormulaExpression();
    }

    @Override
    public FormulaExpression getYValuesFormulaExpression() {
        return this._yValueExpr;
    }

    @Override
    public FormulaExpression getZValuesFormulaExpression() {
        return this._zValueExpr;
    }

    @Override
    public void setXYZFormula(FormulaExpression nameExpr, FormulaExpression xValueExpr, FormulaExpression yValueExpr, FormulaExpression zValueExpr) {
        this.checkOrphan();
        this._evaluated = false;
        this._visibleEvaluated = false;
        this.clearFormulaDependency();
        this._nameExpr = nameExpr;
        this._valueExpr = xValueExpr;
        this._yValueExpr = yValueExpr;
        this._zValueExpr = zValueExpr;
        FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
        SSheet sheet = this._chart.getSheet();
        Ref ref = this.getRef();
        FormulaParseContext context = new FormulaParseContext(sheet, ref);
        if (nameExpr != null) {
            fe.updateDependencyTable(nameExpr, context);
        }
        if (xValueExpr != null) {
            fe.updateDependencyTable(xValueExpr, context);
        }
        if (yValueExpr != null) {
            fe.updateDependencyTable(yValueExpr, context);
        }
        if (zValueExpr != null) {
            fe.updateDependencyTable(zValueExpr, context);
        }
    }

    @Override
    public boolean isNameFomulaHidden(int index) {
        this.evalVisibleInfo();
        return this._hiddenNameInfo == null ? false : this._hiddenNameInfo[index];
    }

    @Override
    public boolean isXValueFomulaHidden(int index) {
        this.evalVisibleInfo();
        return this._hiddenValuesInfo == null ? false : this._hiddenValuesInfo[index];
    }

    @Override
    public boolean isYValueFomulaHidden(int index) {
        this.evalVisibleInfo();
        return this._hiddenYValuesInfo == null ? false : this._hiddenYValuesInfo[index];
    }

    @Override
    public boolean isZValueFomulaHidden(int index) {
        this.evalVisibleInfo();
        return this._hiddenZValuesInfo == null ? false : this._hiddenZValuesInfo[index];
    }

    @Override
    public SColor getDefaultColor() {
        return this._defaultColor;
    }

    @Override
    public void setDefaultColor(SColor defaultColor) {
        this._defaultColor = defaultColor;
    }

    @Override
    public Map<Integer, SColor> getDataPointColors() {
        return this._dataPointColors;
    }

    @Override
    public void addDataPointColors(int index, SColor color) {
        this._dataPointColors.put(index, color);
    }

    @Override
    public int getOrder() {
        return this._order;
    }

    @Override
    public void setOrder(int order) {
        this._order = order;
    }

    @Override
    public boolean isSmooth() {
        return this._smooth;
    }

    @Override
    public void setSmooth(boolean _smooth) {
        this._smooth = _smooth;
    }

    @Override
    public boolean isDataLabelsVisible() {
        return this._dataLabelsVisible;
    }

    @Override
    public void setDataLabelsVisible(boolean dataLabelsVisible) {
        this._dataLabelsVisible = dataLabelsVisible;
    }
}

