/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SBook;
import io.keikai.model.SFont;
import io.keikai.model.SRichText;
import io.keikai.model.impl.AbstractFontAdv;
import io.keikai.model.impl.AbstractRichTextAdv;
import io.keikai.model.impl.SegmentImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ReadOnlyRichTextImpl
extends AbstractRichTextAdv {
    private static final long serialVersionUID = 1L;
    private List<SRichText.Segment> _segments;
    private SRichText _richText;

    public ReadOnlyRichTextImpl(String text, SFont font) {
        this._segments = new ArrayList<SRichText.Segment>(1);
        this._segments.add(new SegmentImpl(text, font));
    }

    public ReadOnlyRichTextImpl(SRichText richText) {
        this._richText = richText;
    }

    @Override
    public String getText() {
        return this._richText == null ? this._segments.get(0).getText() : this._richText.getText();
    }

    @Override
    public SFont getFont() {
        return this._richText == null ? this._segments.get(0).getFont() : this._richText.getFont();
    }

    @Override
    public List<SRichText.Segment> getSegments() {
        return this._richText == null ? Collections.unmodifiableList(this._segments) : this._richText.getSegments();
    }

    @Override
    public void addSegment(String text, SFont font) {
        throw new UnsupportedOperationException("readonly rich text");
    }

    @Override
    public void clearSegments() {
        throw new UnsupportedOperationException("readonly rich text");
    }

    @Override
    public AbstractRichTextAdv clone() {
        return this._richText == null ? new ReadOnlyRichTextImpl(this._segments.get(0).getText(), this._segments.get(0).getFont()) : new ReadOnlyRichTextImpl(this._richText);
    }

    @Override
    public int getHeightPoints() {
        int highest = 0;
        for (SRichText.Segment ss : this.getSegments()) {
            int p = ss.getFont().getHeightPoints();
            if (p <= highest) continue;
            highest = p;
        }
        return highest;
    }

    @Override
    AbstractRichTextAdv cloneRichText(SBook book) {
        if (this._richText == null) {
            SFont font0 = this._segments.get(0).getFont();
            SFont font = font0 == null ? null : ((AbstractFontAdv)font0).cloneFont(book);
            return new ReadOnlyRichTextImpl(this._segments.get(0).getText(), font);
        }
        AbstractRichTextAdv richText = ((AbstractRichTextAdv)this._richText).cloneRichText(book);
        return new ReadOnlyRichTextImpl(richText);
    }
}

