/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.util.Ref;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public class OutlineLevelTree
implements Serializable {
    private OutlineLevelNode[] indexToNode = new OutlineLevelNode[8];
    public OutlineLevelNode root = new OutlineLevelNode(0);

    private static boolean overlaps(OutlineLevelNode node, Ref ref) {
        return node.end >= ref.getTop() && node.start <= ref.getBottom();
    }

    public List<OutlineLevelNode> search(Ref ref) {
        ArrayDeque<OutlineLevelNode> stack = new ArrayDeque<OutlineLevelNode>();
        stack.push(this.root);
        ArrayList<OutlineLevelNode> result = new ArrayList<OutlineLevelNode>();
        while (!stack.isEmpty()) {
            OutlineLevelNode node = (OutlineLevelNode)stack.pop();
            if (!OutlineLevelTree.overlaps(node, ref) || node.level >= ref.getRight()) continue;
            if (node.children != null) {
                stack.addAll(node.children);
            }
            if (node.level < ref.getLeft()) continue;
            result.add(node);
        }
        return result;
    }

    public OutlineLevelNode getOrCreateNode(int level) {
        return this.getOrCreateNode(level, false);
    }

    private OutlineLevelNode getOrCreateNode(int level, boolean skipClear) {
        if (level == 0) {
            if (!skipClear) {
                this.indexToNode = new OutlineLevelNode[8];
            }
            return this.root;
        }
        OutlineLevelNode node = this.indexToNode[level];
        if (node != null) {
            if (!skipClear) {
                for (int i = level + 1; i < 8; ++i) {
                    this.indexToNode[i] = null;
                }
            }
            return node;
        }
        node = new OutlineLevelNode(level);
        OutlineLevelNode parent = this.getOrCreateNode(level - 1, true);
        parent.appendChild(node);
        this.indexToNode[level] = node;
        return node;
    }

    public static class OutlineLevelNode
    implements Serializable {
        private int start = -1;
        private int end = -1;
        private int level = 0;
        private OutlineLevelNode parent;
        private List<OutlineLevelNode> children;
        private int maxLevel = 0;

        public OutlineLevelNode(int level) {
            this.level = level;
        }

        public void appendChild(OutlineLevelNode node) {
            if (this.children == null) {
                this.children = new ArrayList<OutlineLevelNode>();
            }
            this.children.add(node);
            node.parent = this;
        }

        public void setIndex(int index, int level) {
            if (this.start < 0 || this.start > index) {
                this.start = index;
            }
            if (this.end < index) {
                this.end = index;
            }
            if (this.maxLevel < level) {
                this.maxLevel = level;
            }
            if (this.parent != null) {
                this.parent.setIndex(index, level);
            }
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public int getLevel() {
            return this.level;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }
    }
}

