/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.CellRegion;
import io.keikai.model.SBookSeries;
import io.keikai.model.SCell;
import io.keikai.model.SSheet;
import io.keikai.model.STable;
import io.keikai.model.STableStyleInfo;
import io.keikai.model.SheetRegion;
import io.keikai.model.impl.AbstractBookSeriesAdv;
import io.keikai.model.impl.CellAttribute;
import io.keikai.model.impl.FormulaCacheCleaner;
import io.keikai.model.impl.FormulaCacheClearHelper;
import io.keikai.model.sys.dependency.DependencyTable;
import io.keikai.model.sys.dependency.Ref;
import io.keikai.range.impl.ModelUpdateCollector;
import java.util.Set;

class ModelUpdateUtil {
    ModelUpdateUtil() {
    }

    static void handlePrecedentUpdate(SBookSeries bookSeries, Ref precedent) {
        ModelUpdateUtil.handlePrecedentUpdate(bookSeries, precedent, true);
    }

    static void handlePrecedentUpdate(SBookSeries bookSeries, Ref precedent, boolean includePrecedent) {
        FormulaCacheCleaner clearer = FormulaCacheCleaner.getCurrent();
        ModelUpdateCollector collector = ModelUpdateCollector.getCurrent();
        Set<Ref> dependents = null;
        if (collector != null || clearer != null || bookSeries.isAutoFormulaCacheClean()) {
            DependencyTable table = ((AbstractBookSeriesAdv)bookSeries).getDependencyTable();
            dependents = table.getEvaluatedDependents(precedent);
        }
        if (includePrecedent) {
            ModelUpdateUtil.addRefUpdate(precedent);
        }
        if (dependents != null && dependents.size() > 0) {
            if (clearer != null) {
                clearer.clear(dependents, precedent);
            } else if (bookSeries.isAutoFormulaCacheClean()) {
                new FormulaCacheClearHelper(bookSeries).clear(dependents, precedent);
            }
            if (collector != null) {
                collector.addRefs(dependents);
            }
        }
    }

    static void addRefUpdate(Ref ref) {
        ModelUpdateCollector collector = ModelUpdateCollector.getCurrent();
        if (collector != null) {
            collector.addRef(ref);
        }
    }

    static void addCellUpdate(SSheet sheet, SCell cell, CellAttribute cellAttr) {
        ModelUpdateUtil.addCellUpdate(sheet, cell.getRowIndex(), cell.getColumnIndex(), cellAttr);
    }

    static void addCellUpdate(SSheet sheet, int row, int column, CellAttribute cellAttr) {
        ModelUpdateUtil.addCellUpdate(sheet, row, column, row, column, cellAttr);
    }

    static void addCellUpdate(SSheet sheet, int row, int column, int lastRow, int lastColumn, CellAttribute cellAttr) {
        ModelUpdateCollector collector = ModelUpdateCollector.getCurrent();
        if (collector != null) {
            collector.addCellUpdate(sheet, row, column, lastRow, lastColumn, cellAttr);
        }
    }

    static void addMergeUpdate(SSheet sheet, CellRegion original, CellRegion changeTo) {
        ModelUpdateCollector collector = ModelUpdateCollector.getCurrent();
        if (collector != null) {
            collector.addMergeChange(sheet, original, changeTo);
        }
    }

    static void addInsertDeleteUpdate(SSheet sheet, boolean inserted, boolean isRow, int index, int lastIndex) {
        ModelUpdateCollector collector = ModelUpdateCollector.getCurrent();
        if (collector != null) {
            collector.addInsertDeleteUpdate(sheet, inserted, isRow, index, lastIndex);
        }
    }

    static void addAutoFilterUpdate(SSheet sheet, STable table) {
        ModelUpdateCollector collector = ModelUpdateCollector.getCurrent();
        if (collector != null) {
            collector.addAutoFilterUpdate(sheet, table);
        }
    }

    static void addTableStyleUpdate(STable table) {
        STableStyleInfo tableStyleInfo;
        ModelUpdateCollector collector = ModelUpdateCollector.getCurrent();
        if (collector != null && ((tableStyleInfo = table.getTableStyleInfo()).isShowColumnStripes() || tableStyleInfo.isShowRowStripes())) {
            SheetRegion region = table.getDataRegion();
            collector.addCellUpdate(region.getSheet(), region.getRow(), region.getColumn(), region.getLastRow(), region.getLastColumn(), CellAttribute.STYLE);
        }
    }
}

