/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;

abstract class IndexPool<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer _firstKey;
    private Integer _lastKey;
    private ConcurrentSkipListMap<Integer, T> _objs = new ConcurrentSkipListMap();

    IndexPool() {
    }

    public T get(int idx) {
        return this._objs.get(idx);
    }

    public T put(int idx, T obj) {
        T old = this._objs.put(idx, obj);
        this.resetCacheKey();
        return old;
    }

    public int firstKey() {
        if (this._firstKey == null) {
            this._firstKey = this.size() == 0 ? -1 : this._objs.firstKey();
        }
        return this._firstKey;
    }

    public int lastKey() {
        if (this._lastKey == null) {
            this._lastKey = this.size() == 0 ? -1 : this._objs.lastKey();
        }
        return this._lastKey;
    }

    public Collection<T> clear(int start, int end) {
        NavigableMap effected = this._objs.subMap((Object)start, true, (Object)end, true);
        LinkedList remove = new LinkedList();
        Iterator iter = effected.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object obj = entry.getValue();
            remove.add(obj);
            iter.remove();
        }
        this.resetCacheKey();
        return remove;
    }

    public void insert(int start, int size) {
        if (size <= 0) {
            return;
        }
        NavigableMap effected = this._objs.descendingMap().headMap((Object)start, true);
        for (Map.Entry entry : new ArrayList(effected.entrySet())) {
            int idx = (Integer)entry.getKey();
            int newidx = idx + size;
            Object obj = entry.getValue();
            this._objs.remove(idx);
            this.resetIndex(newidx, obj);
            this._objs.put(newidx, obj);
        }
        this.resetCacheKey();
    }

    abstract void resetIndex(int var1, T var2);

    public Collection<T> delete(int start, int size) {
        if (size <= 0) {
            return Collections.EMPTY_LIST;
        }
        NavigableMap effected = this._objs.tailMap((Object)start, true);
        LinkedList remove = new LinkedList();
        for (Map.Entry entry : new ArrayList(effected.entrySet())) {
            int idx = (Integer)entry.getKey();
            int newidx = idx - size;
            Object obj = entry.getValue();
            this._objs.remove(idx);
            if (newidx >= start) {
                this.resetIndex(newidx, obj);
                this._objs.put(newidx, obj);
                continue;
            }
            remove.add(obj);
        }
        this.resetCacheKey();
        return remove;
    }

    public Collection<T> trim(int start) {
        NavigableMap effected = this._objs.tailMap((Object)start, true);
        LinkedList remove = new LinkedList();
        for (Map.Entry entry : new ArrayList(effected.entrySet())) {
            int idx = (Integer)entry.getKey();
            this._objs.remove(idx);
            remove.add(entry.getValue());
        }
        this.resetCacheKey();
        return remove;
    }

    public Set<Integer> keySet() {
        return this._objs.keySet();
    }

    public Collection<T> values() {
        return this._objs.values();
    }

    public Collection<T> descendingValues() {
        return this._objs.descendingMap().values();
    }

    public Collection<T> subValues(int start, int end) {
        return this._objs.subMap((Object)start, true, (Object)end, true).values();
    }

    public Collection<T> descendingSubValues(int start, int end) {
        return this._objs.subMap((Object)start, true, (Object)end, true).descendingMap().values();
    }

    public int size() {
        return this._objs.size();
    }

    public void clear() {
        this._objs.clear();
        this.resetCacheKey();
    }

    private void resetCacheKey() {
        this._firstKey = null;
        this._lastKey = null;
    }
}

