/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SBook;
import io.keikai.model.SBorder;
import io.keikai.model.SBorderLine;
import io.keikai.model.SCellStyle;
import io.keikai.model.SExtraStyle;
import io.keikai.model.SFill;
import io.keikai.model.SFont;
import io.keikai.model.impl.AbstractBorderAdv;
import io.keikai.model.impl.AbstractFillAdv;
import io.keikai.model.impl.AbstractFontAdv;
import io.keikai.model.impl.BookImpl;
import io.keikai.model.impl.ExtraFillImpl;
import io.keikai.model.impl.ImmutableCellStyleImpl;
import io.keikai.model.util.Strings;
import io.keikai.model.util.Validations;

public class ImmutableExtraStyleImpl
extends ImmutableCellStyleImpl
implements SExtraStyle {
    private static final long serialVersionUID = -7358673570667872723L;

    ImmutableExtraStyleImpl(ImmutableExtraStyleImpl src, BookImpl book) {
        super(src, book);
    }

    public ImmutableExtraStyleImpl(SFont font, SFill fill, SBorder border, String dataFormat) {
        super((AbstractFontAdv)font, (AbstractFillAdv)fill, (AbstractBorderAdv)border);
        if (fill != null) {
            Validations.argInstance(fill, ExtraFillImpl.class);
        }
        if (dataFormat != null && !Strings.isBlank(dataFormat)) {
            this.dataFormat = dataFormat;
        }
    }

    @Override
    public SBorder.BorderType getBorderLeft() {
        if (this.border == null) {
            return null;
        }
        SBorderLine bline = this.border.getLeftLine();
        return bline == null ? null : bline.getBorderType();
    }

    @Override
    public SBorder.BorderType getBorderTop() {
        if (this.border == null) {
            return null;
        }
        SBorderLine bline = this.border.getTopLine();
        return bline == null ? null : bline.getBorderType();
    }

    @Override
    public SBorder.BorderType getBorderRight() {
        if (this.border == null) {
            return null;
        }
        SBorderLine bline = this.border.getRightLine();
        return bline == null ? null : bline.getBorderType();
    }

    @Override
    public SBorder.BorderType getBorderBottom() {
        if (this.border == null) {
            return null;
        }
        SBorderLine bline = this.border.getBottomLine();
        return bline == null ? null : bline.getBorderType();
    }

    @Override
    public SBorder.BorderType getBorderDiagonal() {
        if (this.border == null) {
            return null;
        }
        SBorderLine bline = this.border.getDiagonalLine();
        return bline == null ? null : bline.getBorderType();
    }

    @Override
    public SBorder.BorderType getBorderVertical() {
        if (this.border == null) {
            return null;
        }
        SBorderLine bline = this.border.getVerticalLine();
        return bline == null ? null : bline.getBorderType();
    }

    @Override
    public SBorder.BorderType getBorderHorizontal() {
        if (this.border == null) {
            return null;
        }
        SBorderLine bline = this.border.getHorizontalLine();
        return bline == null ? null : bline.getBorderType();
    }

    @Override
    public String getDataFormat() {
        return this.dataFormat;
    }

    @Override
    SCellStyle createCellStyle(SBook book) {
        return new ImmutableExtraStyleImpl(this, (BookImpl)book);
    }

    @Override
    SCellStyle cloneCellStyle(SBook book) {
        return book == null ? this : book.getOrAddExtraStyle(this);
    }
}

