/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SBook;
import io.keikai.model.SBorder;
import io.keikai.model.SBorderLine;
import io.keikai.model.SColor;
import io.keikai.model.impl.AbstractBorderLineAdv;
import io.keikai.model.impl.AbstractColorAdv;
import io.keikai.model.impl.DefaultStyle;
import java.util.Objects;
import java.util.Optional;

public class ImmutableBorderLineImpl
extends AbstractBorderLineAdv {
    public static final SBorderLine BLANK_BORDER_LINE = new ImmutableBorderLineImpl(DefaultStyle.BORDER_TYPE, DefaultStyle.BORDER_COLOR);
    private static final long serialVersionUID = 2236585361952473608L;
    private final SBorder.BorderType type;
    private final SColor color;
    private final boolean showUp;
    private final boolean showDown;
    private final int hashCode;

    public ImmutableBorderLineImpl(SBorder.BorderType type, SColor color) {
        this(type, color, false, false);
    }

    public ImmutableBorderLineImpl(SBorder.BorderType type, SColor color, boolean showUp, boolean showDown) {
        this.type = Optional.of(type).orElse(DefaultStyle.BORDER_TYPE);
        this.color = color;
        this.showUp = showUp;
        this.showDown = showDown;
        this.hashCode = ImmutableBorderLineImpl.calcHashCode(this);
    }

    private static int calcHashCode(ImmutableBorderLineImpl impl) {
        int result = impl.type.hashCode();
        result = 31 * result + impl.color.hashCode();
        result = 31 * result + (impl.showUp ? 1 : 0);
        result = 31 * result + (impl.showDown ? 1 : 0);
        return result;
    }

    @Override
    public SBorder.BorderType getBorderType() {
        return this.type;
    }

    @Override
    public void setBorderType(SBorder.BorderType type) {
        throw new UnsupportedOperationException("doesn't support set border type");
    }

    @Override
    public SColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(SColor color) {
        throw new UnsupportedOperationException("doesn't support set color");
    }

    @Override
    public boolean isShowDiagonalUpBorder() {
        return this.showUp;
    }

    @Override
    public void setShowDiagonalUpBorder(boolean show) {
        throw new UnsupportedOperationException("doesn't support set show diagonal up border");
    }

    @Override
    public boolean isShowDiagonalDownBorder() {
        return this.showDown;
    }

    @Override
    public void setShowDiagonalDownBorder(boolean show) {
        throw new UnsupportedOperationException("doesn't support set show diagonal down border");
    }

    @Override
    String getStyleKey() {
        return this.type.ordinal() + "." + this.color.getHtmlColor() + "." + (this.showUp ? "1" : "0") + "." + (this.showDown ? "1" : "0");
    }

    @Override
    SBorderLine cloneBorderLine(SBook book) {
        AbstractColorAdv srcColor = (AbstractColorAdv)this.getColor();
        SColor color = srcColor == null ? null : srcColor.cloneColor(book);
        return new ImmutableBorderLineImpl(this.type, color, this.showUp, this.showDown);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableBorderLineImpl that = (ImmutableBorderLineImpl)o;
        if (this.showUp != that.showUp) {
            return false;
        }
        if (this.showDown != that.showDown) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return Objects.equals(this.color, that.color);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

