/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.CFIconImpl;
import io.keikai.model.SCFIcon;
import io.keikai.model.SCFValueObject;
import io.keikai.model.SIconSet;
import io.keikai.model.impl.CFValueObjectImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IconSetImpl
implements SIconSet,
Serializable {
    private static final long serialVersionUID = 167905784918493054L;
    private static final Map<String, String[]> iconSets = new HashMap<String, String[]>(17);
    private SIconSet.IconSetType type;
    private List<SCFValueObject> valueObjects;
    private boolean percent;
    private boolean reverse;
    private boolean showValue = true;
    private List<SCFIcon> cfIcons;

    public static String getIconSetName(String name, int iconSetId, boolean reverse, List<SCFIcon> cfIcons) {
        if (cfIcons != null && !cfIcons.isEmpty()) {
            SCFIcon cfIcon;
            SCFIcon sCFIcon = cfIcon = iconSetId < cfIcons.size() ? cfIcons.get(iconSetId) : null;
            if (cfIcon == null) {
                return null;
            }
            SIconSet.IconSetType type = cfIcon.getType();
            name = type != null ? type.name : null;
            iconSetId = cfIcon.getIconId();
            reverse = false;
        }
        String[] sets = iconSets.get(name);
        int iconSetId0 = reverse ? sets.length - iconSetId - 1 : iconSetId;
        return sets == null ? null : sets[iconSetId0];
    }

    @Override
    public SIconSet.IconSetType getType() {
        return this.type;
    }

    public void setType(SIconSet.IconSetType type) {
        this.type = type;
    }

    @Override
    public List<SCFValueObject> getCFValueObjects() {
        return this.valueObjects;
    }

    public void addValueObject(SCFValueObject vo) {
        if (this.valueObjects == null) {
            this.valueObjects = new ArrayList<SCFValueObject>();
        }
        this.valueObjects.add(vo);
    }

    @Override
    public boolean isPercent() {
        return this.percent;
    }

    public void setPercent(boolean b) {
        this.percent = b;
    }

    @Override
    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean b) {
        this.reverse = b;
    }

    @Override
    public boolean isShowValue() {
        return this.showValue;
    }

    public void setShowValue(boolean b) {
        this.showValue = b;
    }

    public IconSetImpl cloneIconSet() {
        IconSetImpl iconSet = new IconSetImpl();
        iconSet.type = this.type;
        iconSet.percent = this.percent;
        iconSet.reverse = this.reverse;
        iconSet.showValue = iconSet.showValue;
        for (SCFValueObject vo : this.valueObjects) {
            CFValueObjectImpl vo0 = (CFValueObjectImpl)vo;
            iconSet.addValueObject(vo0.cloneCFValueObject());
        }
        if (this.cfIcons != null) {
            for (SCFIcon icon : this.cfIcons) {
                CFIconImpl icon1 = (CFIconImpl)icon;
                iconSet.addCfIcon(icon1.cloneCFIcon());
            }
        }
        return iconSet;
    }

    @Override
    public List<SCFIcon> getCFIcons() {
        return this.cfIcons;
    }

    public void addCfIcon(SCFIcon icon) {
        if (this.cfIcons == null) {
            this.cfIcons = new ArrayList<SCFIcon>();
        }
        this.cfIcons.add(icon);
    }

    static {
        iconSets.put("3ArrowsGray", new String[]{"arrowsGrayDown", "arrowsGrayRight", "arrowsGrayUp"});
        iconSets.put("3Flags", new String[]{"flagsRed", "flagsYellow", "flagsGreen"});
        iconSets.put("3TrafficLights1", new String[]{"trafficLights1Red", "trafficLights1Yellow", "trafficLights1Green"});
        iconSets.put("3TrafficLights2", new String[]{"trafficLights2Red", "trafficLights2Yellow", "trafficLights2Green"});
        iconSets.put("3Signs", new String[]{"signsRed", "signsYellow", "signsGreen"});
        iconSets.put("3Symbols", new String[]{"symbolsRed", "symbolsYellow", "symbolsGreen"});
        iconSets.put("3Symbols2", new String[]{"symbols2Red", "symbols2Yellow", "symbols2Green"});
        iconSets.put("3Arrows", new String[]{"arrowsDown", "arrowsRight", "arrowsUp"});
        iconSets.put("4Arrows", new String[]{"arrowsDown", "arrowsDownRight", "arrowsUpRight", "arrowsUp"});
        iconSets.put("4ArrowsGray", new String[]{"arrowsGrayDown", "arrowsGrayDownRight", "arrowsGrayUpRight", "arrowsGrayUp"});
        iconSets.put("4RedToBlack", new String[]{"trafficLightsBlack", "trafficLightsGray", "trafficLightsPink", "trafficLights1Red"});
        iconSets.put("4Rating", new String[]{"signal1", "signal2", "signal3", "signal4"});
        iconSets.put("4TrafficLights", new String[]{"trafficLightsBlack", "trafficLights1Red", "trafficLights1Yellow", "trafficLights1Green"});
        iconSets.put("5Arrows", new String[]{"arrowsDown", "arrowsDownRight", "arrowsRight", "arrowsUpRight", "arrowsUp"});
        iconSets.put("5ArrowsGray", new String[]{"arrowsGrayDown", "arrowsGrayDownRight", "arrowsGrayRight", "arrowsGrayUpRight", "arrowsGrayUp"});
        iconSets.put("5Rating", new String[]{"signal0", "signal1", "signal2", "signal3", "signal4"});
        iconSets.put("5Quarters", new String[]{"quarters0", "quarters1", "quarters2", "quarters3", "quarters4"});
        iconSets.put("3Stars", new String[]{"start0", "start1", "start2"});
        iconSets.put("3Triangles", new String[]{"triangle1", "triangle2", "triangle3"});
        iconSets.put("5Boxes", new String[]{"boxes0", "boxes1", "boxes2", "boxes3", "boxes4"});
    }
}

