/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.ErrorValue;
import io.keikai.model.SCell;
import io.keikai.model.impl.CellValue;
import io.keikai.model.sys.formula.EvaluationResult;
import java.io.Serializable;
import java.util.Collection;
import org.apache.poi.ss.util.ToExcelNumberConverter;

public class FormulaResultCellValue
extends CellValue
implements Serializable {
    private static final long serialVersionUID = 1L;

    public FormulaResultCellValue(EvaluationResult result) {
        Object val = result.getValue();
        EvaluationResult.ResultType type = result.getType();
        if (type == EvaluationResult.ResultType.ERROR) {
            this.cellType = SCell.CellType.ERROR;
            this.value = val instanceof ErrorValue ? (ErrorValue)val : ErrorValue.valueOf((byte)15);
        } else if (type == EvaluationResult.ResultType.SUCCESS) {
            this.setByValue(val);
        }
    }

    private void setByValue(Object val) {
        if (val == null || "".equals(val)) {
            this.cellType = SCell.CellType.BLANK;
            this.value = null;
        } else if (val instanceof String) {
            this.cellType = SCell.CellType.STRING;
            this.value = (String)val;
        } else if (val instanceof Number) {
            this.cellType = SCell.CellType.NUMBER;
            this.value = val instanceof Double ? Double.valueOf(ToExcelNumberConverter.toExcelNumber((double)((Double)val), (boolean)true)) : val;
        } else if (val instanceof Boolean) {
            this.cellType = SCell.CellType.BOOLEAN;
            this.value = (Boolean)val;
        } else if (val instanceof Collection) {
            if (((Collection)val).size() > 0) {
                this.setByValue(((Collection)val).iterator().next());
            } else {
                this.cellType = SCell.CellType.BLANK;
                this.value = null;
            }
        } else if (val.getClass().isArray()) {
            if (((Object[])val).length > 0) {
                this.setByValue(((Object[])val)[0]);
            } else {
                this.cellType = SCell.CellType.BLANK;
                this.value = null;
            }
        } else {
            this.cellType = SCell.CellType.ERROR;
            this.value = val instanceof ErrorValue ? (ErrorValue)val : new ErrorValue(15, "Unknow value type " + val);
        }
    }

    public SCell.CellType getCellType() {
        return this.cellType;
    }

    @Override
    public Object getValue() {
        return this.value;
    }
}

