/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SBook;
import io.keikai.model.SBookSeries;
import io.keikai.model.SCell;
import io.keikai.model.SChart;
import io.keikai.model.SConditionalFormattingRule;
import io.keikai.model.SDataValidation;
import io.keikai.model.SRow;
import io.keikai.model.SSheet;
import io.keikai.model.chart.SChartData;
import io.keikai.model.impl.AbstractCellAdv;
import io.keikai.model.impl.AbstractChartAdv;
import io.keikai.model.impl.AbstractSheetAdv;
import io.keikai.model.impl.ConditionalFormattingImpl;
import io.keikai.model.impl.ConditionalFormattingRuleImpl;
import io.keikai.model.sys.EngineFactory;
import io.keikai.model.sys.dependency.ConditionalRef;
import io.keikai.model.sys.dependency.ObjectRef;
import io.keikai.model.sys.dependency.Ref;
import io.keikai.model.sys.formula.FormulaClearContext;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FormulaCacheClearHelper
implements Serializable {
    private static final long serialVersionUID = 8757672812896139208L;
    private final SBookSeries _bookSeries;
    private static final Logger logger = LoggerFactory.getLogger(FormulaCacheClearHelper.class);

    public FormulaCacheClearHelper(SBookSeries bookSeries) {
        this._bookSeries = bookSeries;
    }

    public void clear(Set<Ref> refs) {
        this.clear(refs, null);
    }

    public void clear(Set<Ref> refs, Ref precedent) {
        if (precedent != null && (precedent.getType() == Ref.RefType.CELL || precedent.getType() == Ref.RefType.AREA)) {
            this.clearColumnValueCache(precedent);
        }
        for (Ref ref : refs) {
            if (logger.isDebugEnabled()) {
                logger.debug("Clear Formula Cache: " + ref);
            }
            if (ref.getType() == Ref.RefType.CELL || ref.getType() == Ref.RefType.AREA) {
                this.handleAreaRef(ref);
                continue;
            }
            if (ref.getType() == Ref.RefType.OBJECT) {
                if (((ObjectRef)ref).getObjectType() == ObjectRef.ObjectType.CHART) {
                    this.handleChartRef((ObjectRef)ref);
                    continue;
                }
                if (((ObjectRef)ref).getObjectType() != ObjectRef.ObjectType.DATA_VALIDATION) continue;
                this.handleDataValidationRef((ObjectRef)ref);
                continue;
            }
            if (ref.getType() != Ref.RefType.CONDITIONAL) continue;
            this.handleConditionalRef((ConditionalRef)ref);
        }
    }

    private void clearColumnValueCache(Ref ref) {
        SBook book = this._bookSeries.getBook(ref.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(ref.getSheetName());
        if (sheet == null) {
            return;
        }
        EngineFactory.getInstance().createFormulaEngine().clearColumnCache(new FormulaClearContext(sheet), ref.getColumn(), ref.getLastColumn());
    }

    private void handleChartRef(ObjectRef ref) {
        SBook book = this._bookSeries.getBook(ref.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(ref.getSheetName());
        if (sheet == null) {
            return;
        }
        String[] ids = ref.getObjectIdPath();
        SChart chart = sheet.getChart(ids[0]);
        if (chart != null) {
            for (SChartData chartData : ((AbstractChartAdv)chart).getChartData()) {
                chartData.clearFormulaResultCache();
            }
        }
    }

    private void handleConditionalRef(ConditionalRef ref) {
        SBook book = this._bookSeries.getBook(ref.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(ref.getSheetName());
        if (sheet == null) {
            return;
        }
        int id = ref.getConditionalId();
        ConditionalFormattingImpl cfmt = (ConditionalFormattingImpl)((AbstractSheetAdv)sheet).getConditionalFormatting(id);
        for (SConditionalFormattingRule rule0 : cfmt.getRules()) {
            ConditionalFormattingRuleImpl rule = (ConditionalFormattingRuleImpl)rule0;
            switch (rule.getType()) {
                case CELL_IS: 
                case BEGINS_WITH: 
                case ENDS_WITH: 
                case CONTAINS_TEXT: 
                case NOT_CONTAINS_TEXT: 
                case CONTAINS_BLANKS: 
                case NOT_CONTAINS_BLANKS: 
                case CONTAINS_ERRORS: 
                case NOT_CONTAINS_ERRORS: 
                case EXPRESSION: {
                    if (rule.getRuleInfo1() != null) {
                        rule.getRuleInfo1().clearCacheMap();
                        if (rule.getRuleInfo2() == null) break;
                        rule.getRuleInfo2().clearCacheMap();
                        break;
                    }
                    rule.clearFormulaResultCache();
                    break;
                }
                case ABOVE_AVERAGE: 
                case COLOR_SCALE: 
                case DATA_BAR: 
                case DUPLICATE_VALUES: 
                case ICON_SET: 
                case TIME_PERIOD: 
                case TOP_10: 
                case UNIQUE_VALUES: {
                    rule.clearFormulaResultCache();
                }
            }
        }
    }

    private void handleDataValidationRef(ObjectRef ref) {
        SBook book = this._bookSeries.getBook(ref.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(ref.getSheetName());
        if (sheet == null) {
            return;
        }
        String[] ids = ref.getObjectIdPath();
        SDataValidation validation = sheet.getDataValidation(ids[0]);
        if (validation != null) {
            validation.clearFormulaResultCache();
        }
    }

    private void handleAreaRef(Ref ref) {
        boolean wholeSheet;
        SBook book = this._bookSeries.getBook(ref.getBookName());
        if (book == null) {
            return;
        }
        SSheet sheet = book.getSheetByName(ref.getSheetName());
        if (sheet == null) {
            return;
        }
        boolean wholeRow = ref.getColumn() == 0 && ref.getLastColumn() >= book.getMaxColumnIndex();
        boolean wholeColumn = ref.getRow() == 0 && ref.getLastRow() >= book.getMaxRowIndex();
        boolean bl = wholeSheet = wholeRow && wholeColumn;
        if (wholeSheet) {
            Iterator<SRow> rows = sheet.getRowIterator();
            while (rows.hasNext()) {
                Iterator<SCell> cells = sheet.getCellIterator(rows.next().getIndex());
                while (cells.hasNext()) {
                    cells.next().clearFormulaResultCache();
                }
            }
        } else if (wholeRow) {
            for (int r = ref.getRow(); r <= ref.getLastRow(); ++r) {
                Iterator<SCell> cells = sheet.getCellIterator(r);
                while (cells.hasNext()) {
                    cells.next().clearFormulaResultCache();
                }
            }
        } else if (wholeColumn) {
            Iterator<SRow> rows = sheet.getRowIterator();
            while (rows.hasNext()) {
                int r = rows.next().getIndex();
                for (int c = ref.getColumn(); c <= ref.getLastColumn(); ++c) {
                    AbstractCellAdv cell = ((AbstractSheetAdv)sheet).getCell(r, c, false);
                    if (cell == null) continue;
                    cell.clearFormulaResultCache();
                }
            }
        } else {
            for (int r = ref.getRow(); r <= ref.getLastRow(); ++r) {
                for (int c = ref.getColumn(); c <= ref.getLastColumn(); ++c) {
                    AbstractCellAdv cell = ((AbstractSheetAdv)sheet).getCell(r, c, false);
                    if (cell == null) continue;
                    cell.clearFormulaResultCache();
                }
            }
        }
    }
}

