/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SBook;
import io.keikai.model.SColor;
import io.keikai.model.SFill;
import io.keikai.model.impl.AbstractColorAdv;
import io.keikai.model.impl.AbstractFillAdv;
import io.keikai.model.impl.ColorImpl;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Objects;

@Deprecated
public class FillImpl
extends AbstractFillAdv {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(FillImpl.class);
    protected SColor _fillColor;
    protected SColor _backColor;
    protected SFill.FillPattern _fillPattern;
    protected String _patternHtml = null;
    static byte[][] PATTERN_BYTES = new byte[][]{null, {0, 0, 0, 0}, {85, -86, 85, -86}, {-18, -69, -18, -69}, {-120, 34, -120, 34}, {-1, 0, 0, -1}, {51, 51, 51, 51}, {-103, -52, 102, 51}, {-103, 51, 102, -52}, {-103, -103, 102, 102}, {-103, -1, 102, -1}, {0, 0, 0, -1}, {34, 34, 34, 34}, {17, -120, 68, 34}, {-120, 17, 34, 68}, {34, 34, 34, -1}, {85, -120, 85, 34}, {0, -120, 0, 34}, {0, 32, 0, 2}};
    public static final SFill BLANK_FILL = new FillImpl(SFill.FillPattern.NONE, ColorImpl.BLACK, ColorImpl.WHITE);

    FillImpl(FillImpl src, SBook book) {
        this._backColor = src._backColor == null ? null : ((AbstractColorAdv)src._backColor).cloneColor(book);
        this._fillColor = src._fillColor == null ? null : ((AbstractColorAdv)src._fillColor).cloneColor(book);
        this._fillPattern = src._fillPattern;
    }

    public FillImpl() {
    }

    public FillImpl(SFill.FillPattern pattern, String fgColor, String bgColor) {
        this._fillPattern = pattern;
        this._fillColor = new ColorImpl(fgColor);
        this._backColor = new ColorImpl(bgColor);
    }

    public FillImpl(SFill.FillPattern pattern, SColor fgColor, SColor bgColor) {
        this._fillPattern = pattern;
        this._fillColor = fgColor;
        this._backColor = bgColor;
    }

    @Override
    public void setFillColor(SColor fillColor) {
        this._fillColor = fillColor;
        this._patternHtml = null;
    }

    @Override
    public void setBackColor(SColor backColor) {
        this._backColor = backColor;
        this._patternHtml = null;
    }

    @Override
    public void setFillPattern(SFill.FillPattern fillPattern) {
        this._fillPattern = fillPattern;
        this._patternHtml = null;
    }

    @Override
    public SColor getFillColor() {
        return this._fillColor == null ? ColorImpl.BLACK : this._fillColor;
    }

    @Override
    public SColor getBackColor() {
        return this._backColor == null ? ColorImpl.WHITE : this._backColor;
    }

    @Override
    public SFill.FillPattern getFillPattern() {
        return this._fillPattern == null ? SFill.FillPattern.NONE : this._fillPattern;
    }

    public int hashCode() {
        int hash = this.getFillColor().hashCode();
        hash = hash * 31 + this.getBackColor().hashCode();
        hash = hash * 31 + this.getFillPattern().hashCode();
        return hash;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FillImpl)) {
            return false;
        }
        FillImpl o = (FillImpl)other;
        return Objects.equals((Object)this.getFillColor(), (Object)o.getFillColor()) && Objects.equals((Object)this.getBackColor(), (Object)o.getBackColor()) && Objects.equals((Object)((Object)this.getFillPattern()), (Object)((Object)o.getFillPattern()));
    }

    public String getFillPatternHtml() {
        SFill.FillPattern pattern = this.getFillPattern();
        if (pattern == SFill.FillPattern.NONE || pattern == SFill.FillPattern.SOLID) {
            return "";
        }
        if (this._patternHtml == null) {
            this._patternHtml = FillImpl.getFillPatternHtml(this);
        }
        return this._patternHtml;
    }

    private static String getFillPatternHtml(SFill style) {
        byte[] rawData = FillImpl.getFillPatternBytes(style, 0, 0, 8, 4);
        StringBuilder sb = new StringBuilder();
        sb.append("background-image:url(data:image/png;base64,");
        String base64 = Base64.encodeBase64String((byte[])rawData);
        sb.append(base64).append(");");
        return sb.toString();
    }

    @Override
    String getStyleKey() {
        return this._fillPattern.ordinal() + "." + this._fillColor.getHtmlColor() + "." + this._backColor.getHtmlColor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFillPatternBytes(SFill style, int xOffset, int yOffset, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g2 = image.createGraphics();
        byte[] rgb = style.getBackColor().getRGB();
        g2.setColor(new Color(rgb[0] & 0xFF, rgb[1] & 0xFF, rgb[2] & 0xFF));
        g2.fillRect(0, 0, width, height);
        rgb = style.getFillColor().getRGB();
        g2.setColor(new Color(rgb[0] & 0xFF, rgb[1] & 0xFF, rgb[2] & 0xFF));
        byte[] patb = PATTERN_BYTES[style.getFillPattern().ordinal()];
        for (int y = 0; y < height; ++y) {
            int y0 = (y + yOffset) % 4;
            byte b = patb[y0];
            if (b == 0) continue;
            if (b == 255) {
                g2.drawLine(0, y, width - 1, y);
                continue;
            }
            int mask = 128 >>> xOffset % 8;
            for (int x = 0; x < width; ++x) {
                if ((b & mask) != 0) {
                    g2.drawLine(x, y, x, y);
                }
                if ((mask >>>= 1) != 0) continue;
                mask = 128;
            }
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", os);
        }
        catch (IOException e) {
            log.error("Failed to write image", (Throwable)e);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                log.error("Failed to close output stream", (Throwable)e);
            }
        }
        return os.toByteArray();
    }

    @Override
    public SColor getRawFillColor() {
        return this._fillColor;
    }

    @Override
    public SColor getRawBackColor() {
        return this._backColor;
    }

    @Override
    public SFill.FillPattern getRawFillPattern() {
        return this._fillPattern;
    }

    @Override
    SFill cloneFill(SBook book) {
        return book == null ? this : new FillImpl(this, book);
    }
}

