/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SBorder;
import io.keikai.model.SCellStyle;
import io.keikai.model.SCellStyleBuilder;
import io.keikai.model.SFill;
import io.keikai.model.SFont;
import io.keikai.model.impl.AbstractFontAdv;
import io.keikai.model.impl.BookImpl;
import io.keikai.model.impl.BorderBuilderImpl;
import io.keikai.model.impl.DefaultStyle;
import io.keikai.model.impl.FillBuilderImpl;
import io.keikai.model.impl.ImmutableCellStyleImpl;
import io.keikai.model.util.Strings;
import io.keikai.model.util.Validations;

public class CellStyleBuilderImpl
implements SCellStyleBuilder {
    private final BookImpl bookImpl;
    private final boolean inStyleTable;
    private final SCellStyle src;
    private AbstractFontAdv font;
    private FillBuilderImpl fillBuilder;
    private BorderBuilderImpl borderBuilder;
    private SCellStyle.Alignment alignment;
    private SCellStyle.VerticalAlignment verticalAlignment;
    private boolean wrapText;
    private String dataFormat;
    private boolean directFormat;
    private boolean locked;
    private boolean hidden;
    private int rotation;
    private int indention;

    CellStyleBuilderImpl(BookImpl bookImpl, SCellStyle src, boolean inStyleTable) {
        this.bookImpl = bookImpl;
        this.src = src;
        this.inStyleTable = inStyleTable;
        if (src != null) {
            this.alignment = src.getAlignment();
            this.verticalAlignment = src.getVerticalAlignment();
            this.wrapText = src.isWrapText();
            this.dataFormat = src.getDataFormat();
            this.directFormat = src.isDirectDataFormat();
            this.locked = src.isLocked();
            this.hidden = src.isHidden();
            this.rotation = src.getRotation();
            this.indention = src.getIndention();
        } else {
            this.alignment = DefaultStyle.CELL_ALIGNMENT;
            this.verticalAlignment = DefaultStyle.CELL_VERTICAL_ALIGNMENT;
            this.wrapText = false;
            this.dataFormat = "General";
            this.locked = true;
            this.hidden = false;
        }
    }

    @Override
    public SCellStyleBuilder font(SFont font) {
        Validations.argInstance(font, AbstractFontAdv.class);
        this.font = (AbstractFontAdv)font;
        return this;
    }

    @Override
    public SCellStyleBuilder backColor(String backColor) {
        this.getOrCreateFill().backColor(backColor);
        return this;
    }

    @Override
    public SCellStyleBuilder fillColor(String fillColor) {
        this.getOrCreateFill().fillColor(fillColor);
        return this;
    }

    @Override
    public SCellStyleBuilder fillPattern(SFill.FillPattern fillPattern) {
        this.getOrCreateFill().fillPattern(fillPattern);
        return this;
    }

    @Override
    public SCellStyleBuilder borderLeft(SBorder.BorderType borderLeft) {
        this.getOrCreateBorder().borderLeft(borderLeft);
        return this;
    }

    @Override
    public SCellStyleBuilder borderLeftColor(String color) {
        this.getOrCreateBorder().borderLeftColor(color);
        return this;
    }

    @Override
    public SCellStyleBuilder borderTop(SBorder.BorderType borderTop) {
        this.getOrCreateBorder().borderTop(borderTop);
        return this;
    }

    @Override
    public SCellStyleBuilder borderTopColor(String color) {
        this.getOrCreateBorder().borderTopColor(color);
        return this;
    }

    @Override
    public SCellStyleBuilder borderRight(SBorder.BorderType borderRight) {
        this.getOrCreateBorder().borderRight(borderRight);
        return this;
    }

    @Override
    public SCellStyleBuilder borderRightColor(String color) {
        this.getOrCreateBorder().borderRightColor(color);
        return this;
    }

    @Override
    public SCellStyleBuilder borderBottom(SBorder.BorderType borderBottom) {
        this.getOrCreateBorder().borderBottom(borderBottom);
        return this;
    }

    @Override
    public SCellStyleBuilder borderBottomColor(String color) {
        this.getOrCreateBorder().borderBottomColor(color);
        return this;
    }

    private BorderBuilderImpl getOrCreateBorder() {
        if (this.borderBuilder == null) {
            this.borderBuilder = new BorderBuilderImpl(this.inStyleTable ? this.bookImpl : null, this.src != null ? this.src.getBorder() : null);
        }
        return this.borderBuilder;
    }

    private FillBuilderImpl getOrCreateFill() {
        if (this.fillBuilder == null) {
            this.fillBuilder = new FillBuilderImpl(this.inStyleTable ? this.bookImpl : null, this.src != null ? this.src.getFill() : null);
        }
        return this.fillBuilder;
    }

    @Override
    public SCellStyleBuilder alignment(SCellStyle.Alignment alignment) {
        this.alignment = alignment;
        return this;
    }

    @Override
    public SCellStyleBuilder verticalAlignment(SCellStyle.VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    @Override
    public SCellStyleBuilder wrapText(boolean wrapText) {
        this.wrapText = wrapText;
        return this;
    }

    @Override
    public SCellStyleBuilder dataFormat(String dataFormat) {
        this.dataFormat = Strings.isBlank(dataFormat) ? "General" : dataFormat;
        return this;
    }

    @Override
    public SCellStyleBuilder directFormat(boolean directFormat) {
        this.directFormat = directFormat;
        return this;
    }

    @Override
    public SCellStyleBuilder locked(boolean locked) {
        this.locked = locked;
        return this;
    }

    @Override
    public SCellStyleBuilder hidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Override
    public SCellStyleBuilder rotation(int rotation) {
        this.rotation = rotation;
        return this;
    }

    @Override
    public SCellStyleBuilder indention(int indention) {
        this.indention = indention;
        return this;
    }

    @Override
    public SCellStyle build() {
        AbstractFontAdv font = this.getFont();
        SFill fill = this.getFill();
        SBorder border = this.getBorder();
        if (this.inStyleTable) {
            ImmutableCellStyleImpl style = new ImmutableCellStyleImpl(font == null ? this.bookImpl.getDefaultImmutableFont() : font.cloneFont(this.bookImpl), fill, border, this.alignment, this.verticalAlignment, this.wrapText, this.dataFormat, this.directFormat, this.locked, this.hidden, this.rotation, this.indention);
            return this.bookImpl.getOrAddCellStyle(style);
        }
        return new ImmutableCellStyleImpl(font == null ? this.bookImpl.getDefaultImmutableFont() : font, fill, border, this.alignment, this.verticalAlignment, this.wrapText, this.dataFormat, this.directFormat, this.locked, this.hidden, this.rotation, this.indention);
    }

    private SBorder getBorder() {
        if (this.borderBuilder != null) {
            return this.borderBuilder.build();
        }
        if (this.src != null) {
            return this.src.getBorder();
        }
        return null;
    }

    private SFill getFill() {
        if (this.fillBuilder != null) {
            return this.fillBuilder.build();
        }
        if (this.src != null) {
            return this.src.getFill();
        }
        return null;
    }

    private AbstractFontAdv getFont() {
        if (this.font != null) {
            return this.font;
        }
        if (this.src != null) {
            return (AbstractFontAdv)this.src.getFont();
        }
        return null;
    }
}

