/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SComment;
import io.keikai.model.SConditionalFormatting;
import io.keikai.model.SDataValidation;
import io.keikai.model.SHyperlink;
import io.keikai.model.SName;
import io.keikai.model.impl.AbstractCellAdv;
import io.keikai.model.impl.AbstractCommentAdv;
import io.keikai.model.impl.AbstractHyperlinkAdv;
import io.keikai.model.impl.AbstractSheetAdv;
import io.keikai.model.impl.sys.formula.ParsingBook;
import io.keikai.range.impl.StyleUtil;
import java.io.Serializable;
import java.util.Set;
import org.apache.poi.ss.formula.FormulaRenderer;
import org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import org.apache.poi.ss.formula.ptg.Ptg;

public class CellBuffer
implements Serializable {
    private static final long serialVersionUID = -364582164612926619L;
    private boolean _null = true;
    private SCell.CellType _type;
    private Object _value;
    private String _formula;
    private Set<SName> _names;
    private SCellStyle _style;
    private SComment _comment;
    private SDataValidation _validation;
    private SHyperlink _hyperlink;
    private int rowIndex;
    private int colIndex;
    private SConditionalFormatting _cfmt;

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int row) {
        this.rowIndex = row;
    }

    public int getColIndex() {
        return this.colIndex;
    }

    public void setColIndex(int col) {
        this.colIndex = col;
    }

    public boolean isNull() {
        return this._null;
    }

    public void setNull(boolean isNull) {
        this._null = isNull;
    }

    public SCell.CellType getType() {
        return this._type;
    }

    public void setType(SCell.CellType type) {
        this._type = type;
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object value) {
        this._value = value;
    }

    public String getFormula() {
        return this._formula;
    }

    public void setFormula(String formula) {
        this._formula = formula;
    }

    public void setNames(Set<SName> names) {
        this._names = names;
    }

    public Set<SName> getNames() {
        return this._names;
    }

    public SCellStyle getStyle() {
        return this._style;
    }

    public void setStyle(SCellStyle style) {
        this._style = style;
    }

    public SComment getComment() {
        return this._comment;
    }

    public void setComment(SComment comment) {
        this._comment = comment;
    }

    public SDataValidation getValidation() {
        return this._validation;
    }

    public void setValidation(SDataValidation validation) {
        this._validation = validation;
    }

    public SHyperlink getHyperlink() {
        return this._hyperlink;
    }

    public void setHyperlink(SHyperlink hyperlink) {
        this._hyperlink = hyperlink;
    }

    public static CellBuffer bufferAll(SCell cell) {
        CellBuffer buffer = new CellBuffer();
        if (!cell.isNull()) {
            buffer.setNull(false);
            buffer.setType(cell.getType());
            if (cell.getType() == SCell.CellType.FORMULA) {
                String formula = cell.getFormulaValue();
                ParsingBook parsingBook = new ParsingBook(cell.getSheet().getBook());
                Ptg[] tokens = ((AbstractCellAdv)cell).getFormulaExpression().getPtgs();
                String result = FormulaRenderer.toFormulaCopyText((FormulaRenderingWorkbook)parsingBook, (Ptg[])tokens, (String)formula);
                buffer.setFormula(result);
            } else {
                buffer.setValue(cell.getValue());
            }
            buffer.setStyle(StyleUtil.prepareStyle(cell));
            buffer.setHyperlink(cell.getHyperlink());
            buffer.setComment(cell.getComment());
            int row = cell.getRowIndex();
            int col = cell.getColumnIndex();
            buffer.setValidation(cell.getSheet().getDataValidation(row, col));
            AbstractSheetAdv sheet = (AbstractSheetAdv)cell.getSheet();
            buffer.setConditionalFormatting(sheet.getConditionalFormatting(row, col));
        }
        return buffer;
    }

    public void applyStyle(SCell destCell) {
        destCell.setCellStyle(this.getStyle());
    }

    public void applyValue(SCell destCell) {
        if (this.getType() == SCell.CellType.FORMULA) {
            destCell.setFormulaValue(this.getFormula());
        } else {
            destCell.setValue(this.getValue());
        }
    }

    public void applyComment(SCell destCell) {
        SComment comment = this.getComment();
        destCell.setComment(comment == null ? null : ((AbstractCommentAdv)comment).clone());
    }

    public void applyHyperlink(SCell destCell) {
        SHyperlink link = this.getHyperlink();
        destCell.setHyperlink(link == null ? null : ((AbstractHyperlinkAdv)link).clone());
    }

    public SConditionalFormatting getConditionalFormatting() {
        return this._cfmt;
    }

    public void setConditionalFormatting(SConditionalFormatting cfmt) {
        this._cfmt = cfmt;
    }
}

