/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SBorder;
import io.keikai.model.SBorderBuilder;
import io.keikai.model.SBorderLine;
import io.keikai.model.impl.BookImpl;
import io.keikai.model.impl.ColorImpl;
import io.keikai.model.impl.DefaultStyle;
import io.keikai.model.impl.ImmutableBorderImpl;
import io.keikai.model.impl.ImmutableBorderLineImpl;

public class BorderBuilderImpl
implements SBorderBuilder {
    private final BookImpl bookImpl;
    private final boolean inStyleTable;
    private SBorder.BorderType borderLeft;
    private String borderLeftColor;
    private SBorder.BorderType borderTop;
    private String borderTopColor;
    private SBorder.BorderType borderRight;
    private String borderRightColor;
    private SBorder.BorderType borderBottom;
    private String borderBottomColor;
    private SBorder.BorderType borderVertical;
    private String borderVerticalColor;
    private SBorder.BorderType borderHorizontal;
    private String borderHorizontalColor;
    private SBorder.BorderType borderDiagonal;
    private String borderDiagonalColor;
    private boolean showDiagonalDown;
    private boolean showDiagonalUp;

    public BorderBuilderImpl(BookImpl bookImpl, SBorder src) {
        this.bookImpl = bookImpl;
        boolean bl = this.inStyleTable = bookImpl != null;
        if (src != null) {
            this.borderLeft = src.getBorderLeft();
            this.borderLeftColor = src.getBorderLeftColor().getHtmlColor();
            this.borderTop = src.getBorderTop();
            this.borderTopColor = src.getBorderTopColor().getHtmlColor();
            this.borderRight = src.getBorderRight();
            this.borderRightColor = src.getBorderRightColor().getHtmlColor();
            this.borderBottom = src.getBorderBottom();
            this.borderBottomColor = src.getBorderBottomColor().getHtmlColor();
            this.borderVertical = src.getBorderVertical();
            this.borderVerticalColor = src.getBorderVerticalColor().getHtmlColor();
            this.borderHorizontal = src.getBorderHorizontal();
            this.borderHorizontalColor = src.getBorderHorizontalColor().getHtmlColor();
            this.borderDiagonal = src.getBorderDiagonal();
            this.borderDiagonalColor = src.getBorderDiagonalColor().getHtmlColor();
            this.showDiagonalUp = src.isShowDiagonalUpBorder();
            this.showDiagonalDown = src.isShowDiagonalDownBorder();
        } else {
            this.borderLeft = DefaultStyle.BORDER_TYPE;
            this.borderLeftColor = DefaultStyle.BORDER_COLOR.getHtmlColor();
            this.borderTop = DefaultStyle.BORDER_TYPE;
            this.borderTopColor = DefaultStyle.BORDER_COLOR.getHtmlColor();
            this.borderRight = DefaultStyle.BORDER_TYPE;
            this.borderRightColor = DefaultStyle.BORDER_COLOR.getHtmlColor();
            this.borderBottom = DefaultStyle.BORDER_TYPE;
            this.borderBottomColor = DefaultStyle.BORDER_COLOR.getHtmlColor();
            this.borderVertical = DefaultStyle.BORDER_TYPE;
            this.borderVerticalColor = DefaultStyle.BORDER_COLOR.getHtmlColor();
            this.borderHorizontal = DefaultStyle.BORDER_TYPE;
            this.borderHorizontalColor = DefaultStyle.BORDER_COLOR.getHtmlColor();
            this.borderDiagonal = DefaultStyle.BORDER_TYPE;
            this.borderDiagonalColor = DefaultStyle.BORDER_COLOR.getHtmlColor();
            this.showDiagonalUp = false;
            this.showDiagonalDown = false;
        }
    }

    private static SBorderLine toBorderLine(SBorder.BorderType type, String htmlColor) {
        if (type == SBorder.BorderType.NONE) {
            return ImmutableBorderLineImpl.BLANK_BORDER_LINE;
        }
        return new ImmutableBorderLineImpl(type, new ColorImpl(htmlColor));
    }

    private static SBorderLine toBorderLine(BookImpl book, SBorder.BorderType type, String htmlColor) {
        if (type == SBorder.BorderType.NONE) {
            return ImmutableBorderLineImpl.BLANK_BORDER_LINE;
        }
        return new ImmutableBorderLineImpl(type, book.createColor(htmlColor));
    }

    @Override
    public SBorder build() {
        boolean showDiagonal;
        boolean bl = showDiagonal = (this.showDiagonalDown || this.showDiagonalUp) && this.borderDiagonal != SBorder.BorderType.NONE;
        if (this.inStyleTable) {
            SBorderLine diagonalLine = showDiagonal ? new ImmutableBorderLineImpl(this.borderDiagonal, this.bookImpl.createColor(this.borderDiagonalColor), this.showDiagonalUp, this.showDiagonalDown) : ImmutableBorderLineImpl.BLANK_BORDER_LINE;
            return new ImmutableBorderImpl(BorderBuilderImpl.toBorderLine(this.bookImpl, this.borderLeft, this.borderLeftColor), BorderBuilderImpl.toBorderLine(this.bookImpl, this.borderTop, this.borderTopColor), BorderBuilderImpl.toBorderLine(this.bookImpl, this.borderRight, this.borderRightColor), BorderBuilderImpl.toBorderLine(this.bookImpl, this.borderBottom, this.borderBottomColor), diagonalLine, BorderBuilderImpl.toBorderLine(this.bookImpl, this.borderVertical, this.borderVerticalColor), BorderBuilderImpl.toBorderLine(this.bookImpl, this.borderHorizontal, this.borderHorizontalColor));
        }
        SBorderLine diagonalLine = showDiagonal ? new ImmutableBorderLineImpl(this.borderDiagonal, new ColorImpl(this.borderDiagonalColor), this.showDiagonalUp, this.showDiagonalDown) : ImmutableBorderLineImpl.BLANK_BORDER_LINE;
        return new ImmutableBorderImpl(BorderBuilderImpl.toBorderLine(this.borderLeft, this.borderLeftColor), BorderBuilderImpl.toBorderLine(this.borderTop, this.borderTopColor), BorderBuilderImpl.toBorderLine(this.borderRight, this.borderRightColor), BorderBuilderImpl.toBorderLine(this.borderBottom, this.borderBottomColor), diagonalLine, BorderBuilderImpl.toBorderLine(this.borderVertical, this.borderVerticalColor), BorderBuilderImpl.toBorderLine(this.borderHorizontal, this.borderHorizontalColor));
    }

    @Override
    public SBorderBuilder borderLeft(SBorder.BorderType type) {
        this.borderLeft = type;
        return this;
    }

    @Override
    public SBorderBuilder borderLeftColor(String color) {
        this.borderLeftColor = color;
        return this;
    }

    @Override
    public SBorderBuilder borderTop(SBorder.BorderType type) {
        this.borderTop = type;
        return this;
    }

    @Override
    public SBorderBuilder borderTopColor(String color) {
        this.borderTopColor = color;
        return this;
    }

    @Override
    public SBorderBuilder borderRight(SBorder.BorderType type) {
        this.borderRight = type;
        return this;
    }

    @Override
    public SBorderBuilder borderRightColor(String color) {
        this.borderRightColor = color;
        return this;
    }

    @Override
    public SBorderBuilder borderBottom(SBorder.BorderType type) {
        this.borderBottom = type;
        return this;
    }

    @Override
    public SBorderBuilder borderBottomColor(String color) {
        this.borderBottomColor = color;
        return this;
    }

    @Override
    public SBorderBuilder borderVertical(SBorder.BorderType type) {
        this.borderVertical = type;
        return this;
    }

    @Override
    public SBorderBuilder borderVerticalColor(String color) {
        this.borderVerticalColor = color;
        return this;
    }

    @Override
    public SBorderBuilder borderHorizontal(SBorder.BorderType type) {
        this.borderHorizontal = type;
        return this;
    }

    @Override
    public SBorderBuilder borderHorizontalColor(String color) {
        this.borderHorizontalColor = color;
        return this;
    }

    @Override
    public SBorderBuilder borderDiagonal(SBorder.BorderType type) {
        this.borderDiagonal = type;
        return this;
    }

    @Override
    public SBorderBuilder borderDiagonalColor(String color) {
        this.borderDiagonalColor = color;
        return this;
    }

    @Override
    public SBorderBuilder showDiagonalUpBorder(boolean show) {
        this.showDiagonalUp = show;
        return this;
    }

    @Override
    public SBorderBuilder showDiagonalDownBorder(boolean show) {
        this.showDiagonalDown = show;
        return this;
    }
}

