/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model;

import io.keikai.model.SPictureData;
import io.keikai.model.SSheet;
import io.keikai.model.ViewAnchor;

public interface SPicture {
    public SSheet getSheet();

    public String getId();

    public Format getFormat();

    public byte[] getData();

    public ViewAnchor getAnchor();

    public void setAnchor(ViewAnchor var1);

    public SPictureData getPictureData();

    public static enum Format {
        DIB,
        EMF,
        GIF,
        JPG,
        PICT,
        PNG,
        WMF;


        public String getFileExtension() {
            return this.name().toLowerCase();
        }

        public static Format valueOfFileExtension(String fileExtension) {
            if ("dib".equalsIgnoreCase(fileExtension)) {
                return DIB;
            }
            if ("emf".equalsIgnoreCase(fileExtension)) {
                return EMF;
            }
            if ("gif".equalsIgnoreCase(fileExtension)) {
                return GIF;
            }
            if ("jpg".equalsIgnoreCase(fileExtension) || "jpeg".equalsIgnoreCase(fileExtension)) {
                return JPG;
            }
            if ("pct".equalsIgnoreCase(fileExtension) || "pict".equalsIgnoreCase(fileExtension) || "pic".equalsIgnoreCase(fileExtension)) {
                return PICT;
            }
            if ("png".equalsIgnoreCase(fileExtension)) {
                return PNG;
            }
            if ("wmf".equalsIgnoreCase(fileExtension)) {
                return WMF;
            }
            return null;
        }
    }
}

