/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model;

import io.keikai.model.CellRegion;
import io.keikai.model.SColorScale;
import io.keikai.model.SConditionalFormatting;
import io.keikai.model.SDataBar;
import io.keikai.model.SExtraStyle;
import io.keikai.model.SIconSet;
import io.keikai.model.SSheet;
import java.util.Collection;

public interface SConditionalFormattingRule {
    public RuleType getType();

    public RuleOperator getOperator();

    public Integer getPriority();

    public SExtraStyle getExtraStyle();

    public boolean isStopIfTrue();

    public RuleTimePeriod getTimePeriod();

    public Long getRank();

    public boolean isPercent();

    public boolean isBottom();

    public SColorScale getColorScale();

    public SDataBar getDataBar();

    public SIconSet getIconSet();

    public String getText();

    public boolean isAboveAverage();

    public boolean isEqualAverage();

    public Integer getStandardDeviation();

    public void copyFrom(SConditionalFormattingRule var1, int var2, int var3);

    public void destroy();

    public Collection<CellRegion> getRegions();

    public boolean isFormulaParsingError();

    public String getFormula1();

    public String getFormula2();

    public String getFormula3();

    public void setFormula1(String var1);

    public void setFormula2(String var1);

    public void setFormula3(String var1);

    public void setFormulas(String var1, String var2, String var3);

    public void setEscapedFormulas(String var1, String var2, String var3);

    public String getEscapedFormula1();

    public String getEscapedFormula2();

    public String getEscapedFormula3();

    public SSheet getSheet();

    public void clearFormulaResultCache();

    public SConditionalFormatting getFormatting();

    public void shiftFormulas(int var1, int var2);

    public String getId();

    public void setId(String var1);

    public void setExtId(String var1);

    public String getExtId();

    public static enum RuleOperator {
        LESS_THAN("lessThan", 1),
        LESS_THAN_OR_EQUAL("lessThanOrEqual", 2),
        EQUAL("equal", 3),
        NOT_EQUAL("notEqual", 4),
        GREATER_THAN_OR_EQUAL("greaterThanOrEqual", 5),
        GREATER_THAN("greaterThan", 6),
        BETWEEN("between", 7),
        NOT_BETWEEN("notBetween", 8),
        CONTAINS_TEXT("containsText", 9),
        NOT_CONTAINS("notContains", 10),
        BEGINS_WITH("beginsWith", 11),
        ENDS_WITH("endsWith", 12);

        public final String name;
        public final int value;

        private RuleOperator(String name, int value) {
            this.name = name;
            this.value = value;
        }
    }

    public static enum RuleType {
        EXPRESSION("expression", 1),
        CELL_IS("cellIs", 2),
        COLOR_SCALE("colorScale", 3),
        DATA_BAR("dataBar", 4),
        ICON_SET("iconSet", 5),
        TOP_10("top10", 6),
        UNIQUE_VALUES("uniqueValues", 7),
        DUPLICATE_VALUES("duplicateValues", 8),
        CONTAINS_TEXT("containsText", 9),
        NOT_CONTAINS_TEXT("notContainsText", 10),
        BEGINS_WITH("beginsWith", 11),
        ENDS_WITH("endsWith", 12),
        CONTAINS_BLANKS("containsBlanks", 13),
        NOT_CONTAINS_BLANKS("notContainsBlanks", 14),
        CONTAINS_ERRORS("containsErrors", 15),
        NOT_CONTAINS_ERRORS("containsErrors", 16),
        TIME_PERIOD("timePeriod", 17),
        ABOVE_AVERAGE("aboveAverage", 18);

        public final String name;
        public final int value;

        private RuleType(String name, int value) {
            this.name = name;
            this.value = value;
        }
    }

    public static enum RuleTimePeriod {
        TODAY("today", 1),
        YESTERDAY("yesterday", 2),
        TOMORROW("Tomorrow", 3),
        LAST_7_DAYS("last7Days", 4),
        THIS_MONTH("thisMonth", 5),
        LAST_MONTH("lastMonth", 6),
        NEXT_MONTH("nextMonth", 7),
        THIS_WEEK("thisWeek", 8),
        LAST_WEEK("lastWeek", 9),
        NEXT_WEEK("nextWeek", 10);

        public final String name;
        public final int value;

        private RuleTimePeriod(String name, int value) {
            this.name = name;
            this.value = value;
        }
    }
}

