/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.json;

import io.keikai.json.JSONAware;
import io.keikai.json.JSONValue;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class JSONObject<K, V>
extends LinkedHashMap<K, V>
implements Map<K, V>,
JSONAware {
    private static final long serialVersionUID = -503443796854799292L;

    public JSONObject() {
    }

    public JSONObject(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public JSONObject(int initialCapacity) {
        super(initialCapacity);
    }

    public JSONObject(Map<? extends K, ? extends V> m) {
        super(m);
    }

    public JSONObject(int initialCapacity, float loadFactor, boolean accessOrder) {
        super(initialCapacity, loadFactor, accessOrder);
    }

    public JSONObject(K key, V value) {
        super(1);
        this.put(key, value);
    }

    public static String toJSONString(Map map) {
        if (map == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        Iterator iter = map.entrySet().iterator();
        sb.append('{');
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            Map.Entry entry = iter.next();
            JSONObject.toJSONString(String.valueOf(entry.getKey()), entry.getValue(), sb);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public String toJSONString() {
        return JSONObject.toJSONString(this);
    }

    private static String toJSONString(String key, Object value, StringBuilder sb) {
        sb.append('\"');
        if (key == null) {
            sb.append("null");
        } else {
            JSONValue.escape(key, sb);
        }
        sb.append('\"').append(':');
        sb.append(JSONValue.toJSONString(value));
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toJSONString();
    }

    public static String toString(String key, Object value) {
        StringBuilder sb = new StringBuilder();
        JSONObject.toJSONString(key, value, sb);
        return sb.toString();
    }
}

