/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.importer;

import io.keikai.importer.xml.Cell;
import io.keikai.importer.xml.JSONNode;
import io.keikai.importer.xml.Row;
import io.keikai.importer.xml.SheetData;
import io.keikai.json.JSONArray;
import io.keikai.json.JSONAware;
import io.keikai.json.JSONObject;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.jsoup.nodes.Document;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;

public class XlsxParser {
    private static final Map<String, Map<String, Supplier<JSONNode>>> _xmlSchema = new HashMap<String, Map<String, Supplier<JSONNode>>>(1);
    private static final String EMPTY_STRING = "";
    private static final String UNDERSCORE_STRING = "_";
    private static final String XMLNS_STRING = "xmlns";

    public static JSONObject parse(String name, ZipInputStream zipFile) throws IOException, XMLStreamException {
        ZipEntry entry;
        HashMap<String, InputStream> mapping = new HashMap<String, InputStream>(12);
        while ((entry = zipFile.getNextEntry()) != null) {
            mapping.put(entry.getName(), XlsxParser.convertZipInputStreamToInputStream(zipFile));
        }
        JSONObject<String, Object> json = new JSONObject<String, Object>();
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        factory.setProperty("javax.xml.stream.supportDTD", false);
        for (Map.Entry me : mapping.entrySet()) {
            String key = (String)me.getKey();
            InputStream is = (InputStream)me.getValue();
            if (key.endsWith(".rels") || key.endsWith(".xml")) {
                if (key.endsWith("calcChain.xml") || key.startsWith("docProps/")) continue;
                XMLStreamReader reader = factory.createXMLStreamReader(is);
                json.put(key, XlsxParser.parseXML(reader));
            } else if (key.endsWith(".vml")) {
                BufferedInputStream inputStream = null;
                try {
                    inputStream = new BufferedInputStream(is);
                    inputStream.mark(inputStream.available());
                    XMLStreamReader reader = factory.createXMLStreamReader(inputStream);
                    json.put(key, XlsxParser.parseXML(reader));
                }
                catch (XMLStreamException e) {
                    Parser parser = Parser.htmlParser();
                    parser.settings(new ParseSettings(true, true));
                    inputStream.reset();
                    Document document = parser.parseInput(IOUtils.toString((InputStream)inputStream, (String)"UTF-8"), EMPTY_STRING);
                    document.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
                    StringReader sreader = new StringReader(document.body().html());
                    XMLStreamReader reader = factory.createXMLStreamReader(sreader);
                    json.put(key, XlsxParser.parseXML(reader));
                }
            } else {
                String s = Base64.getEncoder().encodeToString(IOUtils.toByteArray((InputStream)is));
                json.put(key, s);
            }
            is.close();
        }
        return new JSONObject(name, json);
    }

    public static JSONObject parseXML(XMLStreamReader reader) throws XMLStreamException {
        JSONObject json = new JSONObject(1);
        while (reader.hasNext()) {
            int tag = reader.next();
            switch (tag) {
                case 1: {
                    QName qname = reader.getName();
                    String tagName = qname.getPrefix().isEmpty() ? qname.getLocalPart() : qname.getPrefix() + ":" + qname.getLocalPart();
                    Map<String, Supplier<JSONNode>> schemaNodes = _xmlSchema.get(tagName);
                    XlsxParser.parseElement(reader, json, schemaNodes);
                }
            }
        }
        return json;
    }

    public static void parseElement(XMLStreamReader reader, JSONAware json, Map<String, Supplier<JSONNode>> schemaNodes) throws XMLStreamException {
        int ac;
        int nc;
        QName qname;
        JSONObject pObj = json instanceof JSONObject ? (JSONObject)json : null;
        JSONNode pNode = json instanceof JSONNode ? (JSONNode)json : null;
        JSONObject<String, String> attr = null;
        JSONObject<String, Object> cnt = null;
        if (pObj != null && !pObj.isEmpty()) {
            pObj.remove(UNDERSCORE_STRING);
        }
        String tagName = (qname = reader.getName()).getPrefix().isEmpty() ? qname.getLocalPart() : qname.getPrefix() + ":" + qname.getLocalPart();
        Supplier<JSONNode> nodeSupplier = schemaNodes != null ? schemaNodes.get(tagName) : null;
        JSONNode cNode = null;
        if (nodeSupplier != null) {
            cNode = nodeSupplier.get();
        }
        if ((nc = reader.getNamespaceCount()) + (ac = reader.getAttributeCount()) > 0) {
            int i;
            attr = new JSONObject<String, String>(nc + ac);
            if (nc > 0) {
                for (i = 0; i < nc; ++i) {
                    String prefix = reader.getNamespacePrefix(i);
                    String url = reader.getNamespaceURI(i);
                    attr.put((String)(prefix == null ? XMLNS_STRING : "xmlns:" + prefix), url == null ? EMPTY_STRING : url);
                }
            }
            if (ac > 0) {
                for (i = 0; i < ac; ++i) {
                    QName name = reader.getAttributeName(i);
                    String value = reader.getAttributeValue(i);
                    if (!name.getPrefix().isEmpty()) {
                        attr.put(name.getPrefix() + ":" + name.getLocalPart(), value);
                        continue;
                    }
                    attr.put(name.getLocalPart(), value);
                }
            }
            if (cNode != null) {
                cNode.addAttributes(attr);
            }
        }
        int state = -1;
        while (reader.hasNext()) {
            int tag = reader.next();
            switch (tag) {
                case 2: {
                    JSONArray jsonArray;
                    if (pObj != null) {
                        Object result;
                        if (cNode != null) {
                            if (pObj.containsKey(tagName)) {
                                result = pObj.get(tagName);
                                if (result instanceof JSONArray) {
                                    ((JSONArray)result).add(cNode);
                                } else {
                                    Object obj = pObj.remove(tagName);
                                    JSONArray jsonArray2 = new JSONArray();
                                    pObj.put(tagName, jsonArray2);
                                    jsonArray2.add(obj);
                                }
                            } else {
                                pObj.put(tagName, cNode);
                            }
                        } else if (pObj.containsKey(tagName)) {
                            result = pObj.get(tagName);
                            JSONObject<String, Object> temp = null;
                            if (cnt == null) {
                                temp = attr;
                            } else if (attr == null) {
                                temp = cnt;
                            } else {
                                JSONArray jsonArray3 = new JSONArray();
                                attr.forEach((k, v) -> jsonArray3.add(k));
                                attr.put(EMPTY_STRING, (String)((Object)jsonArray3));
                                attr.putAll(cnt);
                                temp = attr;
                            }
                            if (result instanceof JSONArray) {
                                ((JSONArray)result).add(temp);
                            } else {
                                JSONAware v2 = (JSONAware)pObj.remove(tagName);
                                JSONArray array = new JSONArray();
                                array.add(v2);
                                array.add(temp);
                                pObj.put(tagName, array);
                            }
                        } else if (cnt == null) {
                            pObj.put(tagName, attr);
                        } else if (attr == null) {
                            pObj.put(tagName, cnt);
                        } else {
                            jsonArray = new JSONArray();
                            attr.forEach((k, v) -> jsonArray.add(k));
                            attr.put(EMPTY_STRING, (String)((Object)jsonArray));
                            attr.putAll(cnt);
                            pObj.put(tagName, attr);
                        }
                    } else if (cNode != null) {
                        pNode.addElement(tagName, cNode);
                    } else if (cnt == null) {
                        pNode.addElement(tagName, attr);
                    } else if (attr == null) {
                        pNode.addElement(tagName, cnt);
                    } else {
                        jsonArray = new JSONArray();
                        attr.forEach((k, v) -> jsonArray.add(k));
                        attr.put(EMPTY_STRING, (String)((Object)jsonArray));
                        attr.putAll(cnt);
                        pNode.addElement(tagName, attr);
                    }
                    return;
                }
                case 4: {
                    String text = reader.getText();
                    if (state == 2) {
                        if (cNode != null) {
                            cNode.addContent(text);
                            break;
                        }
                        if (text.trim().isEmpty() && !cnt.isEmpty()) break;
                        cnt.put(UNDERSCORE_STRING, cnt.get(UNDERSCORE_STRING) + text);
                        break;
                    }
                    state = 2;
                    if (cNode != null) {
                        cNode.addContent(text);
                        break;
                    }
                    if (cnt == null) {
                        cnt = new JSONObject(3);
                    }
                    if (!text.trim().isEmpty()) {
                        cnt.put(UNDERSCORE_STRING, text);
                        break;
                    }
                    if (!cnt.isEmpty()) break;
                    cnt.put(UNDERSCORE_STRING, text);
                    break;
                }
                case 1: {
                    if (state == -1) {
                        state = 1;
                    }
                    if (cNode != null) {
                        XlsxParser.parseElement(reader, cNode, schemaNodes);
                        break;
                    }
                    if (cnt == null) {
                        cnt = new JSONObject<String, Object>(3);
                    }
                    XlsxParser.parseElement(reader, cnt, schemaNodes);
                }
            }
        }
    }

    private static InputStream convertZipInputStreamToInputStream(ZipInputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)out);
        ByteArrayInputStream is = new ByteArrayInputStream(out.toByteArray());
        return is;
    }

    static {
        _xmlSchema.put("worksheet", (Map<String, Supplier<JSONNode>>)new HashMap<String, Supplier<JSONNode>>(3){
            {
                this.put("sheetData", () -> new SheetData());
                this.put("row", () -> new Row());
                this.put("c", () -> new Cell());
            }
        });
    }
}

