/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.importer;

import io.keikai.model.ViewAnchor;
import io.keikai.util.XlsxJsonHelper;
import java.util.Map;

abstract class ShapeJson {
    final Map viewAnchor;

    ShapeJson(Map viewAnchor) {
        this.viewAnchor = viewAnchor;
    }

    abstract String getUuid();

    abstract String getName();

    boolean isOneCell() {
        return XlsxJsonHelper.$(this.viewAnchor, "xdr:to") == null;
    }

    int getFromCol() {
        return XlsxJsonHelper.toInt((Map)XlsxJsonHelper.$(this.viewAnchor, "xdr:from"), "xdr:col");
    }

    int getFromColOff() {
        return XlsxJsonHelper.toInt((Map)XlsxJsonHelper.$(this.viewAnchor, "xdr:from"), "xdr:colOff");
    }

    int getFromRow() {
        return XlsxJsonHelper.toInt((Map)XlsxJsonHelper.$(this.viewAnchor, "xdr:from"), "xdr:row");
    }

    int getFromRowOff() {
        return XlsxJsonHelper.toInt((Map)XlsxJsonHelper.$(this.viewAnchor, "xdr:from"), "xdr:rowOff");
    }

    int getToCol() {
        return XlsxJsonHelper.toInt((Map)XlsxJsonHelper.$(this.viewAnchor, "xdr:to"), "xdr:col");
    }

    int getToColOff() {
        return XlsxJsonHelper.toInt((Map)XlsxJsonHelper.$(this.viewAnchor, "xdr:to"), "xdr:colOff");
    }

    int getToRow() {
        return XlsxJsonHelper.toInt((Map)XlsxJsonHelper.$(this.viewAnchor, "xdr:to"), "xdr:row");
    }

    int getToRowOff() {
        return XlsxJsonHelper.toInt((Map)XlsxJsonHelper.$(this.viewAnchor, "xdr:to"), "xdr:rowOff");
    }

    ViewAnchor.AnchorType getAnchorType() {
        String TWO_CELL = "twoCell";
        String ONE_CELL = "oneCell";
        String ABSOLUTE = "absolute";
        String editAsValue = XlsxJsonHelper.toStringValue(this.viewAnchor, "editAs", "twoCell");
        ViewAnchor.AnchorType anchorType = ViewAnchor.AnchorType.MOVE_AND_RESIZE;
        if (editAsValue.equals("oneCell")) {
            anchorType = ViewAnchor.AnchorType.MOVE_DONT_RESIZE;
        } else if (editAsValue.equals("absolute")) {
            anchorType = ViewAnchor.AnchorType.DONT_MOVE_AND_RESIZE;
        }
        return anchorType;
    }
}

