/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.importer;

import io.keikai.importer.ChartType;
import io.keikai.importer.DataPointJson;
import io.keikai.util.XlsxJsonHelper;
import java.util.Map;

abstract class SeriesJson {
    private final ChartType _chartType;
    protected final Map _jsonMap;
    private final Map _titleMap;
    private final DataPointJson _dataPoint;

    SeriesJson(ChartType chartType, Map jsonMap) {
        this._chartType = chartType;
        this._jsonMap = jsonMap;
        this._titleMap = (Map)XlsxJsonHelper.$(this._jsonMap, "c:tx");
        this._dataPoint = new DataPointJson(jsonMap);
    }

    ChartType getChartType() {
        return this._chartType;
    }

    boolean hasTitle() {
        return this._titleMap != null;
    }

    boolean isReference() {
        return XlsxJsonHelper.$(this._titleMap, "c:strRef") != null;
    }

    String getTitleText() {
        return XlsxJsonHelper.toStringValue(this._titleMap, "c:v", "");
    }

    String getTitleFormula() {
        Object result = XlsxJsonHelper.getValue((Map)XlsxJsonHelper.$(this._titleMap, "c:strRef"), "c:f");
        if (result == null || result instanceof Map) {
            return null;
        }
        if (result instanceof String) {
            return (String)result;
        }
        return result.toString();
    }

    int getIndex() {
        return XlsxJsonHelper.toInt(this._jsonMap, "c:idx");
    }

    int getOrder() {
        return XlsxJsonHelper.toInt(this._jsonMap, "c:order");
    }

    DataPointJson getDataPoint() {
        return this._dataPoint;
    }
}

