/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.importer;

import io.keikai.model.SFill;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Fills {
    private Map<Fill, Fill> _fillsMap = new HashMap<Fill, Fill>();
    private List<Fill> _fills = new ArrayList<Fill>();

    public <T extends Fill> T getFillAt(int index) {
        return (T)(this._fills.size() > index ? this._fills.get(index) : null);
    }

    public void addFill(Fill fill) {
        Fill exist = this._fillsMap.get(fill);
        if (exist != null) {
            this._fills.add(exist);
        } else {
            this._fillsMap.put(fill, fill);
            this._fills.add(fill);
        }
    }

    public static class PatternFill
    extends Fill {
        private SFill.FillPattern type;
        private String fgColor;
        private String bgColor;

        public PatternFill(String type, String fgColor, String bgColor) {
            switch (type == null ? "none" : type) {
                case "none": {
                    this.type = SFill.FillPattern.NONE;
                    break;
                }
                case "solid": {
                    this.type = SFill.FillPattern.SOLID;
                    break;
                }
                case "mediumGray": {
                    this.type = SFill.FillPattern.MEDIUM_GRAY;
                    break;
                }
                case "darkGray": {
                    this.type = SFill.FillPattern.DARK_GRAY;
                    break;
                }
                case "lightGray": {
                    this.type = SFill.FillPattern.LIGHT_GRAY;
                    break;
                }
                case "darkHorizontal": {
                    this.type = SFill.FillPattern.DARK_HORIZONTAL;
                    break;
                }
                case "darkVertical": {
                    this.type = SFill.FillPattern.DARK_VERTICAL;
                    break;
                }
                case "darkDown": {
                    this.type = SFill.FillPattern.DARK_DOWN;
                    break;
                }
                case "darkUp": {
                    this.type = SFill.FillPattern.DARK_UP;
                    break;
                }
                case "darkGrid": {
                    this.type = SFill.FillPattern.DARK_GRID;
                    break;
                }
                case "darkTrellis": {
                    this.type = SFill.FillPattern.DARK_TRELLIS;
                    break;
                }
                case "lightHorizontal": {
                    this.type = SFill.FillPattern.LIGHT_HORIZONTAL;
                    break;
                }
                case "lightVertical": {
                    this.type = SFill.FillPattern.LIGHT_VERTICAL;
                    break;
                }
                case "lightDown": {
                    this.type = SFill.FillPattern.LIGHT_DOWN;
                    break;
                }
                case "lightUp": {
                    this.type = SFill.FillPattern.LIGHT_UP;
                    break;
                }
                case "lightGrid": {
                    this.type = SFill.FillPattern.LIGHT_GRID;
                    break;
                }
                case "lightTrellis": {
                    this.type = SFill.FillPattern.LIGHT_TRELLIS;
                    break;
                }
                case "gray125": {
                    this.type = SFill.FillPattern.GRAY125;
                    break;
                }
                case "gray0625": {
                    this.type = SFill.FillPattern.GRAY0625;
                }
            }
            this.fgColor = fgColor;
            this.bgColor = bgColor;
        }

        public SFill.FillPattern getType() {
            return this.type;
        }

        public String getFgColor() {
            return this.fgColor;
        }

        public String getBgColor() {
            return this.bgColor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PatternFill that = (PatternFill)o;
            return this.type == that.type && Objects.equals(this.fgColor, that.fgColor) && Objects.equals(this.bgColor, that.bgColor);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.fgColor, this.bgColor});
        }
    }

    public static abstract class Fill {
    }
}

