/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.importer;

import io.keikai.importer.PictureJson;
import io.keikai.importer.ShapeJson;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class Drawings
implements Iterable<ShapeJson> {
    List<ShapeJson> _drawingsJson;
    int _shapeIdCount = 2;

    public Drawings(List<ShapeJson> drawingsJson) {
        if (drawingsJson == null) {
            this._drawingsJson = new LinkedList<ShapeJson>();
        } else {
            this._drawingsJson = drawingsJson;
            this._findMaxId();
        }
    }

    @Override
    public Iterator<ShapeJson> iterator() {
        return this._drawingsJson.iterator();
    }

    List<PictureJson> getPictures() {
        List<PictureJson> picList = this._drawingsJson.stream().filter(t -> t instanceof PictureJson).map(t -> (PictureJson)t).collect(Collectors.toList());
        return picList;
    }

    void _findMaxId() {
        this.getPictures().forEach(pic -> {
            int id = Integer.parseInt(pic.getUuid());
            if (id >= this._shapeIdCount) {
                this._shapeIdCount = id + 1;
            }
        });
    }
}

