/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.importer;

import io.keikai.importer.DrawingShapeType;
import io.keikai.importer.ShapeJson;
import io.keikai.util.XlsxJsonHelper;
import java.util.List;
import java.util.Map;

class DrawingShapeJson
extends ShapeJson {
    DrawingShapeType _type;

    DrawingShapeJson(Map viewAnchor) {
        super(viewAnchor);
    }

    @Override
    String getName() {
        return XlsxJsonHelper.toStringValue((Map)XlsxJsonHelper.$x(this.viewAnchor, "xdr:sp/xdr:nvSpPr/xdr:cNvPr"), "name");
    }

    @Override
    String getUuid() {
        return XlsxJsonHelper.toStringValue((Map)XlsxJsonHelper.$x(this.viewAnchor, "xdr:sp/xdr:nvSpPr/xdr:cNvPr"), "id");
    }

    String getText() {
        List list = XlsxJsonHelper.toList(this.viewAnchor, "xdr:sp/xdr:txBody/a:p");
        if (list == null) {
            return "";
        }
        String v = XlsxJsonHelper.toStringValue((Map)XlsxJsonHelper.$((Map)list.iterator().next(), "a:r"), "a:T");
        return v != null ? v : "";
    }

    boolean hasFill() {
        Map map = (Map)XlsxJsonHelper.$x(this.viewAnchor, "xdr:sp/xdr:spPr");
        return map != null && !map.containsKey("a:noFill");
    }

    String getHlinkTooltip() {
        String v = XlsxJsonHelper.toStringValue((Map)XlsxJsonHelper.$x(this.viewAnchor, "xdr:sp/xdr:nvSpPr/xdr:cNvPr/a:hlinkClick"), "tooltip");
        return v == null ? "" : v;
    }

    boolean hasLine() {
        Map map = (Map)XlsxJsonHelper.$x(this.viewAnchor, "xdr:sp/xdr:spPr/a:ln");
        return map != null && !map.containsKey("a:noFill");
    }

    String getFillClr() {
        String v = XlsxJsonHelper.toStringValue((Map)XlsxJsonHelper.$x(this.viewAnchor, "xdr:sp/xdr:spPr/a:solidFill/a:schemeClr"), "val");
        if (v != null) {
            return v;
        }
        return XlsxJsonHelper.toStringValue((Map)XlsxJsonHelper.$x(this.viewAnchor, "xdr:sp/xdr:style/a:fillRef/a:schemeClr"), "val");
    }

    String getFillAlpha() {
        String v = XlsxJsonHelper.toStringValue((Map)XlsxJsonHelper.$x(this.viewAnchor, "xdr:sp/xdr:spPr/a:solidFill/a:schemeClr"), "a:alpha");
        if (v != null) {
            return v;
        }
        return XlsxJsonHelper.toStringValue((Map)XlsxJsonHelper.$x(this.viewAnchor, "xdr:sp/xdr:style/a:fillRef/a:schemeClr"), "a:alpha");
    }

    String getFontClr() {
        String v = XlsxJsonHelper.toStringValue((Map)XlsxJsonHelper.$x(this.viewAnchor, "xdr:sp/xdr:txBody/a:p/a:r/a:rPr/a:solidFill/a:schemeClr"), "val");
        if (v != null) {
            return v;
        }
        return XlsxJsonHelper.toStringValue((Map)XlsxJsonHelper.$x(this.viewAnchor, "xdr:sp/xdr:style/a:fontRef/a:schemeClr"), "val");
    }

    int getFontSize() {
        String sz = XlsxJsonHelper.toStringValue((Map)XlsxJsonHelper.$x(this.viewAnchor, "xdr:sp/xdr:txBody/a:p/a:r/a:rPr"), "sz");
        if (sz != null) {
            return (int)Math.ceil(Double.parseDouble(sz) / 100.0);
        }
        return 0;
    }

    boolean isFontBold() {
        return "1".equals(XlsxJsonHelper.toStringValue((Map)XlsxJsonHelper.$x(this.viewAnchor, "xdr:sp/xdr:txBody/a:p/a:r/a:rPr"), "b"));
    }

    boolean isFontItalic() {
        return "1".equals(XlsxJsonHelper.toStringValue((Map)XlsxJsonHelper.$x(this.viewAnchor, "xdr:sp/xdr:txBody/a:p/a:r/a:rPr"), "i"));
    }

    String getFontAlign() {
        return XlsxJsonHelper.toStringValue((Map)XlsxJsonHelper.$x(this.viewAnchor, "xdr:sp/xdr:txBody/a:p/a:pPr"), "algn");
    }

    String getFontVAlign() {
        return XlsxJsonHelper.toStringValue((Map)XlsxJsonHelper.$x(this.viewAnchor, "xdr:sp/xdr:txBody/a:bodyPr"), "anchor");
    }

    String getFontFamily() {
        return XlsxJsonHelper.toStringValue((Map)XlsxJsonHelper.$x(this.viewAnchor, "xdr:sp/xdr:style/a:fontRef"), "idx");
    }

    boolean getHidden() {
        return "1".equals(XlsxJsonHelper.toStringValue((Map)XlsxJsonHelper.$x(this.viewAnchor, "xdr:sp/xdr:nvSpPr/xdr:cNvPr"), "hidden"));
    }

    DrawingShapeType getType() {
        if (this._type == null) {
            this._type = this._getType();
        }
        return this._type;
    }

    String getTypeString() {
        return XlsxJsonHelper.toStringValue((Map)XlsxJsonHelper.$x(this.viewAnchor, "xdr:sp/xdr:spPr/a:prstGeom"), "prst");
    }

    private DrawingShapeType _getType() {
        String prst = this.getTypeString();
        if (prst == null) {
            return null;
        }
        switch (prst) {
            case "accentBorderCallout1": {
                return DrawingShapeType.accentBorderCallout1;
            }
            case "accentBorderCallout2": {
                return DrawingShapeType.accentBorderCallout2;
            }
            case "accentBorderCallout3": {
                return DrawingShapeType.accentBorderCallout3;
            }
            case "accentCallout1": {
                return DrawingShapeType.accentCallout1;
            }
            case "accentCallout2": {
                return DrawingShapeType.accentCallout2;
            }
            case "accentCallout3": {
                return DrawingShapeType.accentCallout3;
            }
            case "actionButtonBackPrevious": {
                return DrawingShapeType.actionButtonBackPrevious;
            }
            case "actionButtonBeginning": {
                return DrawingShapeType.actionButtonBeginning;
            }
            case "actionButtonBlank": {
                return DrawingShapeType.actionButtonBlank;
            }
            case "actionButtonDocument": {
                return DrawingShapeType.actionButtonDocument;
            }
            case "actionButtonEnd": {
                return DrawingShapeType.actionButtonEnd;
            }
            case "actionButtonForwardNext": {
                return DrawingShapeType.actionButtonForwardNext;
            }
            case "actionButtonHelp": {
                return DrawingShapeType.actionButtonHelp;
            }
            case "actionButtonHome": {
                return DrawingShapeType.actionButtonHome;
            }
            case "actionButtonInformation": {
                return DrawingShapeType.actionButtonInformation;
            }
            case "actionButtonMovie": {
                return DrawingShapeType.actionButtonMovie;
            }
            case "actionButtonReturn": {
                return DrawingShapeType.actionButtonReturn;
            }
            case "actionButtonSound": {
                return DrawingShapeType.actionButtonSound;
            }
            case "arc": {
                return DrawingShapeType.arc;
            }
            case "bentArrow": {
                return DrawingShapeType.bentArrow;
            }
            case "bentConnector2": {
                return DrawingShapeType.bentConnector2;
            }
            case "bentConnector3": {
                return DrawingShapeType.bentConnector3;
            }
            case "bentConnector4": {
                return DrawingShapeType.bentConnector4;
            }
            case "bentConnector5": {
                return DrawingShapeType.bentConnector5;
            }
            case "bentUpArrow": {
                return DrawingShapeType.bentUpArrow;
            }
            case "bevel": {
                return DrawingShapeType.bevel;
            }
            case "blockArc": {
                return DrawingShapeType.blockArc;
            }
            case "borderCallout1": {
                return DrawingShapeType.borderCallout1;
            }
            case "borderCallout2": {
                return DrawingShapeType.borderCallout2;
            }
            case "borderCallout3": {
                return DrawingShapeType.borderCallout3;
            }
            case "bracePair": {
                return DrawingShapeType.bracePair;
            }
            case "bracketPair": {
                return DrawingShapeType.bracketPair;
            }
            case "callout1": {
                return DrawingShapeType.callout1;
            }
            case "callout2": {
                return DrawingShapeType.callout2;
            }
            case "callout3": {
                return DrawingShapeType.callout3;
            }
            case "can": {
                return DrawingShapeType.can;
            }
            case "chartPlus": {
                return DrawingShapeType.chartPlus;
            }
            case "chartStar": {
                return DrawingShapeType.chartStar;
            }
            case "chartX": {
                return DrawingShapeType.chartX;
            }
            case "chevron": {
                return DrawingShapeType.chevron;
            }
            case "chord": {
                return DrawingShapeType.chord;
            }
            case "circularArrow": {
                return DrawingShapeType.circularArrow;
            }
            case "cloud": {
                return DrawingShapeType.cloud;
            }
            case "cloudCallout": {
                return DrawingShapeType.cloudCallout;
            }
            case "corner": {
                return DrawingShapeType.corner;
            }
            case "cornerTabs": {
                return DrawingShapeType.cornerTabs;
            }
            case "cube": {
                return DrawingShapeType.cube;
            }
            case "curvedConnector2": {
                return DrawingShapeType.curvedConnector2;
            }
            case "curvedConnector3": {
                return DrawingShapeType.curvedConnector3;
            }
            case "curvedConnector4": {
                return DrawingShapeType.curvedConnector4;
            }
            case "curvedConnector5": {
                return DrawingShapeType.curvedConnector5;
            }
            case "curvedDownArrow": {
                return DrawingShapeType.curvedDownArrow;
            }
            case "curvedLeftArrow": {
                return DrawingShapeType.curvedLeftArrow;
            }
            case "curvedRightArrow": {
                return DrawingShapeType.curvedRightArrow;
            }
            case "curvedUpArrow": {
                return DrawingShapeType.curvedUpArrow;
            }
            case "decagon": {
                return DrawingShapeType.decagon;
            }
            case "diagStripe": {
                return DrawingShapeType.diagStripe;
            }
            case "diamond": {
                return DrawingShapeType.diamond;
            }
            case "dodecagon": {
                return DrawingShapeType.dodecagon;
            }
            case "donut": {
                return DrawingShapeType.donut;
            }
            case "doubleWave": {
                return DrawingShapeType.doubleWave;
            }
            case "downArrow": {
                return DrawingShapeType.downArrow;
            }
            case "downArrowCallout": {
                return DrawingShapeType.downArrowCallout;
            }
            case "ellipse": {
                return DrawingShapeType.ellipse;
            }
            case "ellipseRibbon": {
                return DrawingShapeType.ellipseRibbon;
            }
            case "ellipseRibbon2": {
                return DrawingShapeType.ellipseRibbon2;
            }
            case "flowChartAlternateProcess": {
                return DrawingShapeType.flowChartAlternateProcess;
            }
            case "flowChartCollate": {
                return DrawingShapeType.flowChartCollate;
            }
            case "flowChartConnector": {
                return DrawingShapeType.flowChartConnector;
            }
            case "flowChartDecision": {
                return DrawingShapeType.flowChartDecision;
            }
            case "flowChartDelay": {
                return DrawingShapeType.flowChartDelay;
            }
            case "flowChartDisplay": {
                return DrawingShapeType.flowChartDisplay;
            }
            case "flowChartDocument": {
                return DrawingShapeType.flowChartDocument;
            }
            case "flowChartExtract": {
                return DrawingShapeType.flowChartExtract;
            }
            case "flowChartInputOutput": {
                return DrawingShapeType.flowChartInputOutput;
            }
            case "flowChartInternalStorage": {
                return DrawingShapeType.flowChartInternalStorage;
            }
            case "flowChartMagneticDisk": {
                return DrawingShapeType.flowChartMagneticDisk;
            }
            case "flowChartMagneticDrum": {
                return DrawingShapeType.flowChartMagneticDrum;
            }
            case "flowChartMagneticTape": {
                return DrawingShapeType.flowChartMagneticTape;
            }
            case "flowChartManualInput": {
                return DrawingShapeType.flowChartManualInput;
            }
            case "flowChartManualOperation": {
                return DrawingShapeType.flowChartManualOperation;
            }
            case "flowChartMerge": {
                return DrawingShapeType.flowChartMerge;
            }
            case "flowChartMultidocument": {
                return DrawingShapeType.flowChartMultidocument;
            }
            case "flowChartOfflineStorage": {
                return DrawingShapeType.flowChartOfflineStorage;
            }
            case "flowChartOffpageConnector": {
                return DrawingShapeType.flowChartOffpageConnector;
            }
            case "flowChartOnlineStorage": {
                return DrawingShapeType.flowChartOnlineStorage;
            }
            case "flowChartOr": {
                return DrawingShapeType.flowChartOr;
            }
            case "flowChartPredefinedProcess": {
                return DrawingShapeType.flowChartPredefinedProcess;
            }
            case "flowChartPreparation": {
                return DrawingShapeType.flowChartPreparation;
            }
            case "flowChartProcess": {
                return DrawingShapeType.flowChartProcess;
            }
            case "flowChartPunchedCard": {
                return DrawingShapeType.flowChartPunchedCard;
            }
            case "flowChartPunchedTape": {
                return DrawingShapeType.flowChartPunchedTape;
            }
            case "flowChartSort": {
                return DrawingShapeType.flowChartSort;
            }
            case "flowChartSummingJunction": {
                return DrawingShapeType.flowChartSummingJunction;
            }
            case "flowChartTerminator": {
                return DrawingShapeType.flowChartTerminator;
            }
            case "folderCorner": {
                return DrawingShapeType.folderCorner;
            }
            case "frame": {
                return DrawingShapeType.frame;
            }
            case "funnel": {
                return DrawingShapeType.funnel;
            }
            case "gear6": {
                return DrawingShapeType.gear6;
            }
            case "gear9": {
                return DrawingShapeType.gear9;
            }
            case "halfFrame": {
                return DrawingShapeType.halfFrame;
            }
            case "heart": {
                return DrawingShapeType.heart;
            }
            case "heptagon": {
                return DrawingShapeType.heptagon;
            }
            case "hexagon": {
                return DrawingShapeType.hexagon;
            }
            case "homePlate": {
                return DrawingShapeType.homePlate;
            }
            case "horizontalScroll": {
                return DrawingShapeType.horizontalScroll;
            }
            case "irregularSeal1": {
                return DrawingShapeType.irregularSeal1;
            }
            case "irregularSeal2": {
                return DrawingShapeType.irregularSeal2;
            }
            case "leftArrow": {
                return DrawingShapeType.leftArrow;
            }
            case "leftArrowCallout": {
                return DrawingShapeType.leftArrowCallout;
            }
            case "leftBrace": {
                return DrawingShapeType.leftBrace;
            }
            case "leftBracket": {
                return DrawingShapeType.leftBracket;
            }
            case "leftCircularArrow": {
                return DrawingShapeType.leftCircularArrow;
            }
            case "leftRightArrow": {
                return DrawingShapeType.leftRightArrow;
            }
            case "leftRightArrowCallout": {
                return DrawingShapeType.leftRightArrowCallout;
            }
            case "leftRightCircularArrow": {
                return DrawingShapeType.leftRightCircularArrow;
            }
            case "leftRightRibbon": {
                return DrawingShapeType.leftRightRibbon;
            }
            case "leftRightUpArrow": {
                return DrawingShapeType.leftRightUpArrow;
            }
            case "leftUpArrow": {
                return DrawingShapeType.leftUpArrow;
            }
            case "lightningBolt": {
                return DrawingShapeType.lightningBolt;
            }
            case "line": {
                return DrawingShapeType.line;
            }
            case "lineInv": {
                return DrawingShapeType.lineInv;
            }
            case "mathDivide": {
                return DrawingShapeType.mathDivide;
            }
            case "mathEqual": {
                return DrawingShapeType.mathEqual;
            }
            case "mathMinus": {
                return DrawingShapeType.mathMinus;
            }
            case "mathMultiply": {
                return DrawingShapeType.mathMultiply;
            }
            case "mathNotEqual": {
                return DrawingShapeType.mathNotEqual;
            }
            case "mathPlus": {
                return DrawingShapeType.mathPlus;
            }
            case "moon": {
                return DrawingShapeType.moon;
            }
            case "nonIsoscelesTrapezoid": {
                return DrawingShapeType.nonIsoscelesTrapezoid;
            }
            case "noSmoking": {
                return DrawingShapeType.noSmoking;
            }
            case "notchedRightArrow": {
                return DrawingShapeType.notchedRightArrow;
            }
            case "octagon": {
                return DrawingShapeType.octagon;
            }
            case "parallelogram": {
                return DrawingShapeType.parallelogram;
            }
            case "pentagon": {
                return DrawingShapeType.pentagon;
            }
            case "pie": {
                return DrawingShapeType.pie;
            }
            case "pieWedge": {
                return DrawingShapeType.pieWedge;
            }
            case "plaque": {
                return DrawingShapeType.plaque;
            }
            case "plaqueTabs": {
                return DrawingShapeType.plaqueTabs;
            }
            case "plus": {
                return DrawingShapeType.plus;
            }
            case "quadArrow": {
                return DrawingShapeType.quadArrow;
            }
            case "quadArrowCallout": {
                return DrawingShapeType.quadArrowCallout;
            }
            case "rect": {
                return DrawingShapeType.rect;
            }
            case "ribbon": {
                return DrawingShapeType.ribbon;
            }
            case "ribbon2": {
                return DrawingShapeType.ribbon2;
            }
            case "rightArrow": {
                return DrawingShapeType.rightArrow;
            }
            case "rightArrowCallout": {
                return DrawingShapeType.rightArrowCallout;
            }
            case "rightBrace": {
                return DrawingShapeType.rightBrace;
            }
            case "rightBracket": {
                return DrawingShapeType.rightBracket;
            }
            case "round1Rect": {
                return DrawingShapeType.round1Rect;
            }
            case "round2DiagRect": {
                return DrawingShapeType.round2DiagRect;
            }
            case "round2SameRect": {
                return DrawingShapeType.round2SameRect;
            }
            case "roundRect": {
                return DrawingShapeType.roundRect;
            }
            case "rtTriangle": {
                return DrawingShapeType.rtTriangle;
            }
            case "smileyFace": {
                return DrawingShapeType.smileyFace;
            }
            case "snip1Rect": {
                return DrawingShapeType.snip1Rect;
            }
            case "snip2DiagRect": {
                return DrawingShapeType.snip2DiagRect;
            }
            case "snip2SameRect": {
                return DrawingShapeType.snip2SameRect;
            }
            case "snipRoundRect": {
                return DrawingShapeType.snipRoundRect;
            }
            case "squareTabs": {
                return DrawingShapeType.squareTabs;
            }
            case "star10": {
                return DrawingShapeType.star10;
            }
            case "star12": {
                return DrawingShapeType.star12;
            }
            case "star16": {
                return DrawingShapeType.star16;
            }
            case "star24": {
                return DrawingShapeType.star24;
            }
            case "star32": {
                return DrawingShapeType.star32;
            }
            case "star4": {
                return DrawingShapeType.star4;
            }
            case "star5": {
                return DrawingShapeType.star5;
            }
            case "star6": {
                return DrawingShapeType.star6;
            }
            case "star7": {
                return DrawingShapeType.star7;
            }
            case "star8": {
                return DrawingShapeType.star8;
            }
            case "straightConnector1": {
                return DrawingShapeType.straightConnector1;
            }
            case "stripedRightArrow": {
                return DrawingShapeType.stripedRightArrow;
            }
            case "sun": {
                return DrawingShapeType.sun;
            }
            case "swooshArrow": {
                return DrawingShapeType.swooshArrow;
            }
            case "teardrop": {
                return DrawingShapeType.teardrop;
            }
            case "trapezoid": {
                return DrawingShapeType.trapezoid;
            }
            case "triangle": {
                return DrawingShapeType.triangle;
            }
            case "upArrow": {
                return DrawingShapeType.upArrow;
            }
            case "upArrowCallout": {
                return DrawingShapeType.upArrowCallout;
            }
            case "upDownArrow": {
                return DrawingShapeType.upDownArrow;
            }
            case "upDownArrowCallout": {
                return DrawingShapeType.upDownArrowCallout;
            }
            case "uturnArrow": {
                return DrawingShapeType.uturnArrow;
            }
            case "verticalScroll": {
                return DrawingShapeType.verticalScroll;
            }
            case "wave": {
                return DrawingShapeType.wave;
            }
            case "wedgeEllipseCallout": {
                return DrawingShapeType.wedgeEllipseCallout;
            }
            case "wedgeRectCallout": {
                return DrawingShapeType.wedgeRectCallout;
            }
            case "wedgeRoundRectCallout": {
                return DrawingShapeType.wedgeRoundRectCallout;
            }
        }
        return null;
    }
}

