/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.importer;

import io.keikai.importer.CategorySeriesJson;
import io.keikai.importer.ChartType;
import io.keikai.importer.ScatterSeriesJson;
import io.keikai.importer.SeriesJson;
import io.keikai.importer.SingleValueSeriesJson;
import io.keikai.importer.XYZSeriesJson;
import io.keikai.util.XlsxJsonHelper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ChartTypeJson {
    final Map jsonMap;
    final ChartType chartType;

    ChartTypeJson(ChartType chartType, Map jsonMap) {
        this.chartType = chartType;
        this.jsonMap = jsonMap;
    }

    ChartType getChartType() {
        return this.chartType;
    }

    String getGrouping() {
        return XlsxJsonHelper.toStringValue(this.jsonMap, "c:grouping");
    }

    Integer getBarOverlap() {
        return XlsxJsonHelper.toInt(this.jsonMap, "c:overlap");
    }

    List<? extends SeriesJson> getSeriesList() {
        Stream stream = XlsxJsonHelper.toList(this.jsonMap, "c:ser").stream();
        switch (this.chartType) {
            case AREA: 
            case AREA_3D: 
            case LINE: 
            case LINE_3D: 
            case BAR: 
            case BAR_3D: 
            case COLUMN: 
            case COLUMN_3D: 
            case DOUGHNUT: 
            case RADAR: {
                return stream.map(data -> new CategorySeriesJson(this.chartType, (Map)data)).collect(Collectors.toList());
            }
            case PIE: 
            case PIE_3D: {
                return stream.map(data -> new SingleValueSeriesJson(this.chartType, (Map)data)).collect(Collectors.toList());
            }
            case BUBBLE: {
                return stream.map(data -> new XYZSeriesJson(this.chartType, (Map)data)).collect(Collectors.toList());
            }
            case SCATTER: {
                return stream.map(data -> new ScatterSeriesJson(this.chartType, (Map)data)).collect(Collectors.toList());
            }
        }
        System.out.println("Not implemented yet! Chart type: [ " + this.chartType + "]");
        return null;
    }

    List<Long> getAxIds() {
        return XlsxJsonHelper.toList(this.jsonMap, "c:axId").stream().map(v -> XlsxJsonHelper.toLong(v, "val")).collect(Collectors.toList());
    }

    boolean isSmooth() {
        if (XlsxJsonHelper.$(this.jsonMap, "c:smooth") == null) {
            return false;
        }
        return XlsxJsonHelper.toBoolean(XlsxJsonHelper.toValue(this.jsonMap, "c:smooth"), true);
    }

    Boolean hasMarker() {
        if (XlsxJsonHelper.$(this.jsonMap, "c:marker") == null) {
            return null;
        }
        return XlsxJsonHelper.toBoolean(XlsxJsonHelper.toValue(this.jsonMap, "c:marker"), true);
    }
}

