/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.xml;

import io.keikaiex.xml.PersistenceServiceException;
import io.keikaiex.xml.XMLConstants;
import java.beans.Encoder;
import java.beans.ExceptionListener;
import java.beans.PersistenceDelegate;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.Map;

public class PersistenceService
implements XMLConstants {
    private static final HashMap ALL_P_DS = new HashMap();
    public static int BUFSIZE = 10240;

    private static final ExceptionListener createExceptionListener() {
        return new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception exc) {
                throw exc instanceof UndeclaredThrowableException ? (UndeclaredThrowableException)exc : new UndeclaredThrowableException(exc);
            }
        };
    }

    public static final synchronized void setPersistenceDelegate(Class clazz, PersistenceDelegate persistenceDelegate) {
        ALL_P_DS.put(clazz, persistenceDelegate);
    }

    protected static synchronized void installPersistenceDelegates(Encoder encoder) {
        for (Map.Entry entry : ALL_P_DS.entrySet()) {
            encoder.setPersistenceDelegate((Class)entry.getKey(), (PersistenceDelegate)entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(Object root, OutputStream xmlOut) throws NullPointerException, PersistenceServiceException {
        block19: {
            if (xmlOut == null) {
                throw new NullPointerException();
            }
            try {
                BufferedOutputStream bufOut = null;
                XMLEncoder encoder = null;
                try {
                    bufOut = new BufferedOutputStream(xmlOut, BUFSIZE);
                    encoder = new XMLEncoder(bufOut);
                    PersistenceService.installPersistenceDelegates(encoder);
                    encoder.setExceptionListener(PersistenceService.createExceptionListener());
                    if (root != null) {
                        Object object = root;
                        synchronized (object) {
                            encoder.writeObject(root);
                            break block19;
                        }
                    }
                    encoder.writeObject(root);
                }
                finally {
                    if (encoder != null) {
                        try {
                            encoder.close();
                        }
                        catch (Throwable paranoid) {
                            ((OutputStream)bufOut).close();
                            throw paranoid;
                        }
                    } else if (bufOut != null) {
                        ((OutputStream)bufOut).close();
                    } else {
                        xmlOut.close();
                    }
                }
            }
            catch (UndeclaredThrowableException exc) {
                throw new PersistenceServiceException(exc.getCause());
            }
            catch (Throwable thr) {
                throw new PersistenceServiceException(thr);
            }
        }
    }

    public static void store(Object root, File file) throws NullPointerException, PersistenceServiceException {
        if (file == null) {
            throw new NullPointerException();
        }
        File backup = null;
        boolean renamed = false;
        try {
            backup = PersistenceService.getRenamedFile(file);
            renamed = file.renameTo(backup);
            PersistenceService.store(root, new FileOutputStream(file));
            if (renamed) {
                backup.delete();
            }
        }
        catch (Throwable thr) {
            if (renamed) {
                try {
                    file.delete();
                }
                catch (Throwable paranoid) {
                    thr = paranoid;
                }
                try {
                    backup.renameTo(file);
                }
                catch (Throwable paranoid) {
                    thr = paranoid;
                }
            }
            throw thr instanceof PersistenceServiceException ? (PersistenceServiceException)thr : new PersistenceServiceException(thr);
        }
    }

    private static File getRenamedFile(File plainFile) {
        File renamedFile;
        Object path = plainFile.getPath();
        while ((renamedFile = new File((String)(path = (String)path + "~"))).exists()) {
        }
        return renamedFile;
    }

    public static byte[] store2ByteArray(Object root) throws PersistenceServiceException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PersistenceService.store(root, out);
            return out.toByteArray();
        }
        catch (PersistenceServiceException exc) {
            throw exc;
        }
        catch (Throwable thr) {
            throw new PersistenceServiceException(thr);
        }
    }

    public static String store2String(Object root) throws PersistenceServiceException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PersistenceService.store(root, out);
            return out.toString("UTF-8");
        }
        catch (UnsupportedEncodingException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
        catch (PersistenceServiceException exc) {
            throw exc;
        }
        catch (Throwable thr) {
            throw new PersistenceServiceException(thr);
        }
    }

    public static Object load(InputStream xmlIn) throws NullPointerException, PersistenceServiceException {
        if (xmlIn == null) {
            throw new NullPointerException();
        }
        XMLDecoder decoder = null;
        try {
            decoder = new XMLDecoder(new BufferedInputStream(xmlIn, BUFSIZE), null, PersistenceService.createExceptionListener());
            Object object = decoder.readObject();
            return object;
        }
        catch (UndeclaredThrowableException exc) {
            throw new PersistenceServiceException(exc.getCause());
        }
        catch (Throwable thr) {
            throw new PersistenceServiceException(thr);
        }
        finally {
            if (decoder != null) {
                try {
                    decoder.close();
                }
                catch (Throwable paranoid) {
                    throw new PersistenceServiceException(paranoid);
                }
            }
        }
    }

    public static Object load(File file) throws NullPointerException, PersistenceServiceException {
        if (file == null) {
            throw new NullPointerException();
        }
        try {
            return PersistenceService.load(new FileInputStream(file));
        }
        catch (PersistenceServiceException exc) {
            throw exc;
        }
        catch (Throwable thr) {
            throw new PersistenceServiceException(thr);
        }
    }

    public static Object load(byte[] encoded) throws NullPointerException, PersistenceServiceException {
        if (encoded == null) {
            throw new NullPointerException();
        }
        try {
            return PersistenceService.load(new ByteArrayInputStream(encoded));
        }
        catch (PersistenceServiceException exc) {
            throw exc;
        }
        catch (Throwable thr) {
            throw new PersistenceServiceException(thr);
        }
    }

    public static Object load(String encoded) throws NullPointerException, PersistenceServiceException {
        if (encoded == null) {
            throw new NullPointerException();
        }
        try {
            return PersistenceService.load(encoded.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
        catch (PersistenceServiceException exc) {
            throw exc;
        }
        catch (Throwable thr) {
            throw new PersistenceServiceException(thr);
        }
    }

    protected PersistenceService() {
    }
}

