/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.rt;

import io.keikaiex.license.LicenseContent;
import io.keikaiex.license.LicenseManager;
import io.keikaiex.license.LicenseParam;
import io.keikaiex.rt.Refresh;
import io.keikaiex.rt.Runtime;
import io.keikaiex.util.ObfuscatedString;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.util.Cleanups;
import org.zkoss.util.Dates;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.WebApps;

public final class RuntimeLicenseManager
extends LicenseManager {
    private static final long serialVersionUID = 5893038887521539973L;
    private static final String ZK_FRAMEWORK = new ObfuscatedString(new long[]{1155035670506610891L, -6277540554980205858L, 1737211322686313071L}).toString();
    private final Object _lock = new Object();
    private volatile Timer _timer;
    private volatile WebApp _wapp;
    private List _contents;
    private volatile URL _dirUrl;
    private volatile long _latest;
    private final Refresh _refresh;
    private SimpleDateFormat _dateFormat = new SimpleDateFormat("MMMM dd, yyyy", Locale.US);
    private static int HOUR = 3600000;
    private volatile boolean _inJarLicense;

    private RuntimeLicenseManager(LicenseParam param, Refresh refresh) {
        super(param);
        this._refresh = refresh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean install(URL url) {
        URLConnection conn = null;
        try {
            conn = this.createConnection(url);
            Key[] keys = this.getKeys(conn, url);
            if (keys == null) {
                boolean bl = false;
                return bl;
            }
            this._dirUrl = url;
            this.install0(keys);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            RuntimeLicenseManager.log("Create connection failed: " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    LicenseContent install(byte[] b) throws Exception {
        return this.install(b, this.getLicenseNotary());
    }

    private synchronized LicenseContent install(Key key) throws Exception {
        return this.install(RuntimeLicenseManager.loadLicenseKey(key), this.getLicenseNotary());
    }

    private URLConnection createConnection(URL url) throws IOException {
        if ("jar".equals(url.getProtocol())) {
            return url.openConnection();
        }
        return null;
    }

    private void closeConnection(URLConnection conn) {
        try {
            JarURLConnection jarConn;
            if (conn instanceof JarURLConnection && !(jarConn = (JarURLConnection)conn).getUseCaches()) {
                jarConn.getJarFile().close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Key[] getKeys(URLConnection conn, URL url) {
        if (conn instanceof JarURLConnection) {
            try {
                return this.getKeysFromJar((JarURLConnection)conn);
            }
            catch (IOException e) {
                RuntimeLicenseManager.log("Get keys from jar error: " + e.getMessage());
                return null;
            }
        }
        return this.getKeysFromFileSystem(url.getPath());
    }

    private Key[] getKeysFromJar(JarURLConnection conn) throws IOException {
        JarFile jarFile = conn.getJarFile();
        JarEntry jarDir = conn.getJarEntry();
        String dir = jarDir.getName();
        ArrayList<JarKey> keys = new ArrayList<JarKey>(2);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !entry.getName().startsWith(dir)) continue;
            keys.add(new JarKey(jarFile, entry));
        }
        return keys.toArray(new Key[keys.size()]);
    }

    private Key[] getKeysFromFileSystem(String dirName) {
        File dir = new File(dirName);
        File[] files = dir.listFiles();
        if (files == null) {
            return null;
        }
        Key[] result = new Key[files.length];
        for (int i = 0; i < files.length; ++i) {
            result[i] = new FileKey(files[i]);
        }
        return result;
    }

    public static void info(String msg) {
        msg = "\n" + (String)msg + "\n";
        Logger log = LoggerFactory.getLogger((String)"global");
        if (log.isInfoEnabled()) {
            log.info((String)msg);
        } else {
            System.out.println((String)msg);
        }
    }

    public static void log(String msg) {
        msg = "\n" + (String)msg + "\n";
        Logger log = LoggerFactory.getLogger((String)"root");
        if (log.isErrorEnabled()) {
            log.error((String)msg);
        } else {
            System.err.println((String)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void install0(Key[] files) {
        Object object = this._lock;
        synchronized (object) {
            this._contents = new ArrayList(files.length);
            String uid = "7.0.0.FL.20240816";
            HashMap<String, Boolean> _certMap = new HashMap<String, Boolean>();
            this._latest = 0L;
            for (Key f : files) {
                long length = f.lastModified() + f.length();
                this._latest += length;
                try {
                    LicenseContent lc = this.install(f);
                    if (lc == null) continue;
                    Object extra = lc.getExtra();
                    if (!(extra instanceof Map)) {
                        RuntimeLicenseManager.log(Runtime.WARNING_INVALID_FILE + f.getPath());
                        continue;
                    }
                    Map mapInfo = (Map)extra;
                    if (!this._refresh.isTargetSubject(mapInfo)) {
                        this._latest -= length;
                        continue;
                    }
                    String number = (String)mapInfo.get(Runtime.VERIFICATION_NUMBER);
                    if (number == null || _certMap.containsKey(number)) {
                        RuntimeLicenseManager.log(mapInfo.get(Runtime.WARNING_NUMBER) + f.getPath());
                        continue;
                    }
                    _certMap.put(number, Boolean.TRUE);
                    if (!this._refresh.checkPackage(mapInfo)) {
                        RuntimeLicenseManager.log(mapInfo.get(Runtime.WARNING_PACKAGE) + f.getPath());
                        continue;
                    }
                    if (!this._refresh.checkVersion(mapInfo)) {
                        RuntimeLicenseManager.log(mapInfo.get(Runtime.WARNING_VERSION) + f.getPath());
                        continue;
                    }
                    if (Dates.today().after(this.getExpiryDate(lc))) {
                        RuntimeLicenseManager.log(mapInfo.get(Runtime.WARNING_EXPIRY) + f.getPath());
                        continue;
                    }
                    this._contents.add(lc);
                }
                catch (Exception e) {
                    RuntimeLicenseManager.log(new ObfuscatedString(new long[]{-4397841585268573860L, 7877048898996164071L, -132580205755043738L, 1125451740335404766L, -6469931242159645093L, 3393925981821334524L, 1778084550283478471L, 1124782299675776678L, -4876443852155389168L, -23870921474540022L, -1483729972743057955L, -1020498778952356760L, -1437310358024790598L, 5901415581177529086L, -864708291472413570L, 1769178185701901170L, -2178067556886547749L, -4417353456917457085L, -4494752762290861861L, -4615352486542767004L, 7778508507407377738L}).toString() + f.getPath());
                }
            }
            this._latest *= (long)files.length;
            if (this._refresh != null) {
                this._refresh.refresh(this._contents);
            }
            if (this._contents.isEmpty() && this._latest == 0L) {
                RuntimeLicenseManager.log(new ObfuscatedString(new long[]{4893792250553725337L, 2060190193476653149L, -3708297069395369370L, -3456966786235011987L, 5027701124810887276L, 3018356160583109449L, -3000420050107870660L, 1496381368034259716L, -3189285806558455476L, -8773714992521065696L, -7750238665770040173L, 7846485903310903453L, -6900378735968960665L, 8457765932711616170L, 3552574991531545097L, -6212985910734487648L, 2272158139744321034L, 8027519415863291904L}).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] loadLicenseKey(Key keyFile) throws IOException {
        int size = Math.min((int)keyFile.length(), 0x100000);
        byte[] b = new byte[size];
        try (InputStream in = keyFile.inputStream();){
            int count;
            int n = 0;
            int len = b.length;
            do {
                if ((count = in.read(b, n, len - n)) >= 0) continue;
                throw new EOFException();
            } while ((n += count) < len);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDelay() {
        Object object = this._lock;
        synchronized (object) {
            if (this._contents.isEmpty()) {
                return HOUR;
            }
            int delay = 0;
            for (int i = 0; i < this._contents.size(); ++i) {
                int d = (Integer)((Map)((LicenseContent)this._contents.get(i)).getExtra()).get(Runtime.CHECK_PERIOD);
                if (delay == 0) {
                    delay = d;
                    continue;
                }
                if (delay <= d) continue;
                delay = d;
            }
            return delay * HOUR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startScheduler() {
        if (this._timer != null) {
            return;
        }
        Object object = this._lock;
        synchronized (object) {
            if (this._timer == null) {
                this._timer = new Timer();
                Cleanups.add((Cleanups.Cleanup)new Cleanups.Cleanup(){

                    public void cleanup() {
                        RuntimeLicenseManager.this.stopScheduler();
                    }
                });
            }
        }
        this.check();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopScheduler() {
        Object object = this._lock;
        synchronized (object) {
            if (this._timer != null) {
                this._timer.cancel();
                this._timer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LicenseContent getMaximum() {
        LicenseContent lc = null;
        Object object = this._lock;
        synchronized (object) {
            for (int i = 0; i < this._contents.size(); ++i) {
                LicenseContent lc1 = (LicenseContent)this._contents.get(i);
                if (lc != null && !this.getExpiryDate(lc).before(this.getExpiryDate(lc1))) continue;
                lc = lc1;
            }
        }
        return lc;
    }

    private Date getNotBefore(LicenseContent lc) {
        try {
            return this._dateFormat.parse((String)((Map)lc.getExtra()).get(Runtime.ISSUE_DATE));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private Date getExpiryDate(LicenseContent lc) {
        try {
            return this._dateFormat.parse((String)((Map)lc.getExtra()).get(Runtime.EXPIRY_DATE));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LicenseContent checkLatest() {
        URLConnection conn = null;
        try {
            conn = this.createConnection(this._dirUrl);
            Key[] keys = this.getKeys(conn, this._dirUrl);
            if (keys == null) {
                LicenseContent licenseContent = null;
                return licenseContent;
            }
            long latest = 0L;
            for (Key f : keys) {
                latest += f.lastModified() + f.length();
            }
            LicenseContent lc = this.getMaximum();
            if (this._latest != (latest *= (long)keys.length) || lc != null && Dates.now().after(this.getExpiryDate(lc))) {
                this.install0(keys);
                LicenseContent licenseContent = this.getMaximum();
                return licenseContent;
            }
            LicenseContent licenseContent = lc;
            return licenseContent;
        }
        catch (IOException e) {
            RuntimeLicenseManager.log("Create connection failed: " + e.getMessage());
            LicenseContent licenseContent = null;
            return licenseContent;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    private void check() {
        try {
            this.checkLatest();
            if (this._timer != null) {
                this._timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        RuntimeLicenseManager.this.check();
                    }
                }, this.getDelay());
            }
        }
        catch (Exception e) {
            RuntimeLicenseManager.log(Runtime.EVAL_ONLY + ". " + Runtime.WARNING_EVALUATION);
            if (this._wapp != null) {
                this._wapp.setAttribute(Runtime.ZK_NOTICE, (Object)Runtime.getDefaultEvalNotice(this._wapp));
            }
            this.stopScheduler();
        }
    }

    public static RuntimeLicenseManager getInstance(LicenseParam param) {
        return new RuntimeLicenseManager(param, new Refresh(){

            @Override
            public Object refresh(List contents) {
                this.printInfo(contents);
                return null;
            }

            @Override
            public boolean checkPackage(Map mapInfo) {
                return this.isValidPackage(this.getPackage(), (String)mapInfo.get(Runtime.PACKAGE));
            }

            @Override
            public boolean checkVersion(Map mapInfo) {
                String version = (String)mapInfo.get(Runtime.VERSION);
                return version == null || "7.0.0.FL.20240816".startsWith(version);
            }

            private boolean isValidPackage(String runtime, String license) {
                if (license == null) {
                    return false;
                }
                return !runtime.equals(license) && license.equals("EP") ? runtime.equals("PP") : false;
            }

            private String getPackage() {
                return WebApps.getFeature((String)"ee") ? "EP" : "PP";
            }

            @Override
            public boolean isTargetSubject(Map map) {
                String licver = (String)map.get(Runtime.LICENSE_VERSION);
                if ("1.0".equals(licver)) {
                    return true;
                }
                String subject = (String)map.get(Runtime.LICENSE_SUBJECT);
                return ZK_FRAMEWORK.equals(subject);
            }

            private void printInfo(List contents) {
                for (int i = 0; i < contents.size(); ++i) {
                    Map map;
                    LicenseContent lc = (LicenseContent)contents.get(i);
                    Object mapObj = lc.getExtra();
                    if (!(mapObj instanceof Map) || !this.isTargetSubject(map = (Map)mapObj)) continue;
                    RuntimeLicenseManager.log((String)((Map)lc.getExtra()).get(Runtime.INFORMATION));
                }
            }
        });
    }

    public static RuntimeLicenseManager getInstance(LicenseParam param, Refresh refresh) {
        return new RuntimeLicenseManager(param, refresh);
    }

    public void setWapp(WebApp wapp) {
        this._wapp = wapp;
    }

    private static class JarKey
    implements Key {
        private final JarFile jar;
        private final JarEntry entry;

        public JarKey(JarFile jar, JarEntry entry) {
            this.jar = jar;
            this.entry = entry;
        }

        @Override
        public InputStream inputStream() throws IOException {
            return this.jar.getInputStream(this.entry);
        }

        @Override
        public long lastModified() {
            return this.entry.getTime();
        }

        @Override
        public long length() {
            return this.entry.getSize();
        }

        @Override
        public String getPath() {
            return this.jar.getName() + "/" + this.entry.getName();
        }
    }

    private static class FileKey
    implements Key {
        private final File file;

        public FileKey(File file) {
            this.file = file;
        }

        @Override
        public InputStream inputStream() throws IOException {
            return new FileInputStream(this.file);
        }

        @Override
        public long lastModified() {
            return this.file.lastModified();
        }

        @Override
        public long length() {
            return this.file.length();
        }

        @Override
        public String getPath() {
            return this.file.getPath();
        }
    }

    private static interface Key {
        public InputStream inputStream() throws IOException;

        public long lastModified();

        public long length();

        public String getPath();
    }
}

