/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.rt;

import io.keikaiex.license.CipherParam;
import io.keikaiex.license.KeyStoreParam;
import io.keikaiex.license.LicenseParam;
import io.keikaiex.rt.RuntimeInfo;
import io.keikaiex.rt.RuntimeLicenseManager;
import io.keikaiex.util.ObfuscatedString;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.prefs.Preferences;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Library;
import org.zkoss.util.resource.Locator;
import org.zkoss.util.resource.Locators;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.WebApp;

public abstract class Runtime {
    static final String UNIVERSAL_ACTIVE_CODE = new ObfuscatedString(new long[]{-8406957250436102276L, 7739080853276730995L, 2446544582485916568L, 4141763441450886800L, 9163385588230618037L, 3078723322430394289L}).toString();
    static final String ACTIVE_CODE = new ObfuscatedString(new long[]{2927261568102559820L, 5003116366233426486L, -19977163214018644L}).toString();
    static final String LICENSE_SUBJECT = new ObfuscatedString(new long[]{3902422651215371349L, 8624385350820619417L, -642393240400619653L}).toString();
    static final String UP_TIME = new ObfuscatedString(new long[]{7735875781470822017L, 7449797441543358756L}).toString();
    static final String SESSION_COUNT = new ObfuscatedString(new long[]{3229559844559651902L, 4507837234696327046L, 7727269190283665611L}).toString();
    static final String USER_NAME = new ObfuscatedString(new long[]{-7156956517562311570L, -4569457626895068567L, -9130454531809692735L}).toString();
    static final String COMPANY_ID = new ObfuscatedString(new long[]{-3429614419320347732L, 5284083613633888871L, -2962259370126176133L}).toString();
    static final String COMPANY_UNIT = new ObfuscatedString(new long[]{4535911707703337843L, -5339041739265159617L, -8006648055853745059L}).toString();
    static final String COMPANY_NAME = new ObfuscatedString(new long[]{-7340139527016707886L, -5203243759892677212L, 8714822623115369524L}).toString();
    static final String COMPANY_CITY = new ObfuscatedString(new long[]{-6925611054058810462L, 2143563004714040551L, 1994584055053707741L}).toString();
    static final String COMPANY_ADDRESS = new ObfuscatedString(new long[]{-8691848786421899489L, -4370996558863340632L, -2709933490946981238L}).toString();
    static final String COMPANY_ZIPCODE = new ObfuscatedString(new long[]{-4934501068656857753L, -6913828373145765012L, 1063193634233753528L}).toString();
    static final String COUNTRY = new ObfuscatedString(new long[]{-4504969373906269801L, 5248137891553083335L}).toString();
    static final String PROJECT_NAME = new ObfuscatedString(new long[]{830623621279886032L, 459360910074040759L, 4178520520701877821L}).toString();
    static final String PRODUCT_NAME = new ObfuscatedString(new long[]{5504882338648710617L, -4761731334749763195L, 996375918662338065L}).toString();
    static final String PACKAGE = new ObfuscatedString(new long[]{-8439029564924938530L, -4878278112849633009L}).toString();
    static final String VERSION = new ObfuscatedString(new long[]{-4847689528984584834L, 2493253216426408014L}).toString();
    static final String ISSUE_DATE = new ObfuscatedString(new long[]{-4228764154858292882L, -6898004159031332466L, 6328666951570048917L}).toString();
    static final String EXPIRY_DATE = new ObfuscatedString(new long[]{-7233890858958970371L, -3423973165832030856L, -5810612950970282077L}).toString();
    static final String TERM = new ObfuscatedString(new long[]{-6725301182108235475L, -8691110408124621856L}).toString();
    static final String VERIFICATION_NUMBER = new ObfuscatedString(new long[]{3823288740853721680L, -6436340937747658512L, 891079956768101415L, 751513662528431611L}).toString();
    static final String INFORMATION = new ObfuscatedString(new long[]{378870925371295609L, 1418863983102047429L, -5017007170548372422L}).toString();
    static final String KEY_SIGNATURE = new ObfuscatedString(new long[]{-2573177027008659676L, 5066716785755217927L, 5769746383701090690L}).toString();
    static final String CHECK_PERIOD = new ObfuscatedString(new long[]{-2439022525501632135L, 6139476070014855270L, -297657911147084449L}).toString();
    static final String LICENSE_DIRECTORY_PROPERTY = new ObfuscatedString(new long[]{-8064738947919832249L, -4807466137976322367L, -9209570101003301650L, 2999473706873399208L, -8669804619934126744L}).toString();
    static final String LICENSE_VERSION = new ObfuscatedString(new long[]{-7080462743270045357L, 6928867389785115158L, -154565539896996742L}).toString();
    static final String WARNING_EXPIRY = new ObfuscatedString(new long[]{-2088056424898980973L, -3616911578495445651L, -8353968737700076168L}).toString();
    static final String WARNING_PACKAGE = new ObfuscatedString(new long[]{7436618834759965309L, 8220698497085578148L, -6394078374620879850L}).toString();
    static final String WARNING_VERSION = new ObfuscatedString(new long[]{7417971821667979026L, 7464186339852802771L, 7986314911006223431L}).toString();
    static final String WARNING_COUNT = new ObfuscatedString(new long[]{-1510608780643214737L, 6313704540210276937L, 4115504365890483558L}).toString();
    static final String WARNING_NUMBER = new ObfuscatedString(new long[]{8367990676393660796L, -7163797910637480555L, -8349581027556623805L}).toString();
    public static final String WARNING_EVALUATION = new ObfuscatedString(new long[]{-8662480834070507359L, -9126935707592987746L, -6402207909079331257L, 5885585836689339697L, 301548201960002039L, 3023224871254431697L, -2105097797630983438L, 9085864544924227884L, -7716160290431932358L, 540051162007720535L, -5316200942049750486L, 9135498188829987158L, 2193128634908113659L, -8911043590076697519L, -2433761049212319899L, -4955001547596233259L, 2700353122615076838L, 6537850271245723438L, 7498088840197013242L, 2198759401188186996L, -1785359998937500106L, -4814091909858588872L, -2170635468312152764L, 1596368171631912334L, 2992279895308219716L, -4583076015441362012L}).toString();
    public static final String WARNING_INVALID_FILE = new ObfuscatedString(new long[]{8834541650204010310L, 7255593707796909911L, 3251857412635123957L, -9141769420932127513L, -6673671752429869322L, 5907591279554987547L, -6667461161980870155L, 7647413990692369888L, -3102856361982201319L, -7459237147326971162L, -8408698707433149854L, -5454375322443154005L, 7693463111476100376L, -8345486342017577119L, 1202853407536605222L, 2395853416302995437L, 1141065888121529081L, 782805040799645387L, 8601203350782238981L, 6378473893025107049L, -7563091529040114522L, -1054792481233817550L, -6695389033828513487L, 2293232692912736635L, 318282052599186848L, 1731392064102254491L}).toString();
    protected static final String PROPRIETARY_GENERIAL_LICENSE_MESSAGE = new ObfuscatedString(new long[]{756099398747980433L, -6397364254964330739L, -6627379220948485797L, -3580053302360875611L, 3582054482233654873L, -2093372875780092002L, -145530010546292962L, -3068505575201025531L, 2428512643718592300L, -7458559885690338986L, 7421295073199780996L, 2786596323764583907L, -6825649540317085454L, -8853490758845253397L, 1600187505482390335L, 4733632197802830041L, -3969047861030565535L, 2477362071214118128L, -720847216807991965L, 4547356103384757277L, -6592157152875435618L, 1630558104219510617L, -3627615684169893576L, -3269539860501172396L, -8749153343186744928L, -1970701590891240697L, -2543413082328625098L, -8483772383186202806L, -6761261989231010434L, 6774029394259423713L, -7342013726595897725L, 3618502318828491128L, -8466069004112939193L, 903241204040671835L, 7855616961417268621L, -1753317534689059593L, 317022768645053441L, -2793484823862248198L, -5096430616418502502L, 4756014901734227232L, 4391569788786881178L, -9058494054274052937L, 2398871820091535490L, 4629618011153782315L, -1177701079653361648L, -3385792016029952224L, -7991111214258867713L, 1580348348412782553L, -8522745789600858255L, 3512913982886266178L}).toString();
    private static final String V0 = new ObfuscatedString(new long[]{6780048183396145217L, -3514785424911510459L}).toString();
    private static final String V1 = new ObfuscatedString(new long[]{-8556922120573852888L, 708543790670807158L}).toString();
    private static final String MD5STR = new ObfuscatedString(new long[]{-5121064899839768052L, 3334273322282769989L}).toString();
    protected static final ThreadLocal<Boolean> _pass = new ThreadLocal();
    static final String ZK_NOTICE = new ObfuscatedString(new long[]{-8347842002405430398L, 3574087500300642980L, -6273607823570371127L, -5524402949239665762L}).toString();
    static final String EVAL_ONLY = new ObfuscatedString(new long[]{8330515038476062730L, -435229286498387605L, -3853053404258091660L}).toString();
    protected static final String DEFAULT_LICENSE_DIRECTORY = new ObfuscatedString(new long[]{8583868614545226585L, 9012315641974977732L, 8860594231437724947L, -4266371299090993879L, -5401551951563471418L}).toString();
    protected static final String MD = new ObfuscatedString(new long[]{2345590606122015185L, -5069608179148319545L}).toString();
    private static final String UTEST = new ObfuscatedString(new long[]{-8293016695787473683L, -1183785803767335620L, 8915910794513718561L, 4544934471560061531L, 3086892296759781036L, 4496793341751389781L, 5570280657620952074L}).toString();
    private static final String ESCHERAGGREGATE_IMPL = new ObfuscatedString(new long[]{2345626495836856025L, -2044190564505965958L, -8808996750041915995L, -7819475230995892905L, -5238183623808307344L, -4363918525214731539L}).toString();
    private static final Map<Class<? extends Runtime>, Boolean> _installedMap = new HashMap<Class<? extends Runtime>, Boolean>(2);
    private static final Map<Class<? extends Runtime>, Runtime> _runtimeMap = new HashMap<Class<? extends Runtime>, Runtime>(2);
    protected static final Locator LOCATOR = Locators.getDefault();
    protected static LicenseParam _licenseParam = new LicenseParam(){

        @Override
        public String getSubject() {
            return new ObfuscatedString(new long[]{316282811321577434L, -5964851136934036754L, -4141153524264298566L, 7015884390181394804L}).toString();
        }

        @Override
        public Preferences getPreferences() {
            return null;
        }

        @Override
        public KeyStoreParam getKeyStoreParam() {
            return _keystoreParam;
        }

        @Override
        public CipherParam getCipherParam() {
            return _cipherParam;
        }
    };
    private static final long[] KEY_SIG_CONST = new long[]{3380918436902026428L, 7198460148122556679L, 8746048298123095958L, -3382887546410202231L};
    private static final String PUB_STORE = new ObfuscatedString(new long[]{-8483424215100358668L, 5185225220334723473L, 7672877587634070407L, -165475400927543516L}).toString();
    private static final String KEY_NODE = new ObfuscatedString(new long[]{5908501495198661117L, 38698407203575288L, 8211481452130397453L}).toString();
    private static final String ALIAS = new ObfuscatedString(new long[]{-2751357802016299199L, 4066217211348802619L, -2064662869185498634L, 4043793295118034741L, 6227175189710674534L}).toString();
    private static final String STORE_PASS = new ObfuscatedString(new long[]{-8677088790027852212L, 4602056908258993522L, 8019503246186939872L, -1944004741470673738L, -7033589056015316549L}).toString();
    private static KeyStoreParam _keystoreParam = new KeyStoreParam(){

        @Override
        public InputStream getStream() throws IOException {
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(PUB_STORE);
            if (in == null) {
                throw new FileNotFoundException(PUB_STORE);
            }
            return in;
        }

        @Override
        public String getAlias() {
            return ALIAS;
        }

        @Override
        public String getStorePwd() {
            return STORE_PASS;
        }

        @Override
        public String getKeyPwd() {
            return null;
        }
    };
    private static CipherParam _cipherParam = new CipherParam(){

        @Override
        public String getKeyPwd() {
            return new ObfuscatedString(new long[]{-9017617134232705315L, -3067316756544620689L, -7174741455541659722L, 9223059116147577819L, -7389013047307896124L}).toString();
        }
    };

    public static final synchronized boolean init(WebApp wapp, boolean ck, Runtime rt) {
        boolean b = true;
        Class<?> cls = rt.getClass();
        if (ck && !_installedMap.containsKey(cls)) {
            _installedMap.put(cls, Boolean.TRUE);
            _runtimeMap.put(cls, rt);
            wapp.setAttribute(ACTIVE_CODE, (Object)Runtime.getActiveCode());
            try {
                b = rt.init1(wapp);
                b = b && _pass.get() != false;
                _pass.remove();
            }
            catch (Exception e) {
                b = false;
            }
            if (!b && wapp != null) {
                wapp.setAttribute(ZK_NOTICE, (Object)rt.getEvalNotice(wapp));
                wapp.setAttribute(EVAL_ONLY, (Object)Boolean.TRUE);
            }
        }
        return b;
    }

    public static String getDefaultEvalNotice(WebApp wapp) {
        StringBuilder sb = new StringBuilder();
        for (Runtime rt : _runtimeMap.values()) {
            sb.append(rt.getEvalNotice(wapp)).append("\n");
        }
        return sb.toString();
    }

    protected abstract String getEvalNotice(WebApp var1);

    protected abstract boolean init1(WebApp var1) throws Exception;

    protected abstract void refresh(List var1);

    protected abstract Class getInitClass();

    public boolean isTargetSubject(String subject) {
        return new ObfuscatedString(new long[]{-4587782202284743L, -639179873308564561L, 8743137536465430602L}).toString().equals(subject);
    }

    private static String getActiveCode() {
        Preferences pref = _licenseParam.getPreferences();
        if (pref != null) {
            long leastv = pref.getLong(V0, 0L);
            long mostv = pref.getLong(V1, 0L);
            if (leastv == 0L && mostv == 0L) {
                UUID uuid = UUID.randomUUID();
                long most = uuid.getMostSignificantBits();
                long least = uuid.getLeastSignificantBits();
                pref.putLong(V0, least);
                pref.putLong(V1, most);
                if (least == pref.getLong(V0, 0L) && most == pref.getLong(V1, 0L)) {
                    return Runtime.uuidToMD5(most, least);
                }
            } else {
                return Runtime.uuidToMD5(mostv, leastv);
            }
        }
        return null;
    }

    private static final String uuidToMD5(long most, long least) {
        String hostname = null;
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                InetAddress ia;
                NetworkInterface ni = nis.nextElement();
                if (!Runtime.isUp(ni) || Runtime.isVirtual(ni)) continue;
                Enumeration<InetAddress> ias = ni.getInetAddresses();
                while (ias.hasMoreElements() && "localhost".equals(hostname = (ia = ias.nextElement()).getHostName())) {
                    hostname = null;
                }
                if (hostname == null) continue;
                break;
            }
        }
        catch (SocketException nis) {
            // empty catch block
        }
        try {
            int j;
            long mostsalt = -8556922120573852888L;
            long leastsalt = -7110043422976597898L;
            if (hostname == null) {
                hostname = "ZK Host";
            }
            byte[] hostbytes = hostname.getBytes("UTF-8");
            long host = 0L;
            for (j = 0; j < hostbytes.length && j < 8; ++j) {
                host |= ((long)hostbytes[j] & 0xFFL) << j * 8;
            }
            leastsalt ^= host;
            if (hostbytes.length > 8) {
                host = 0L;
                int len = hostbytes.length - 8;
                for (j = 0; j < len && j < 8; ++j) {
                    host |= ((long)hostbytes[j + 8] & 0xFFL) << j * 8;
                }
                mostsalt ^= host;
            }
            String uuidStr = new UUID(most ^ mostsalt, least ^ leastsalt).toString();
            MessageDigest digest = MessageDigest.getInstance(MD5STR);
            if (digest != null) {
                digest.reset();
                digest.update(uuidStr.getBytes("UTF-8"));
                byte[] digested = digest.digest();
                BigInteger bigInt = new BigInteger(1, digested);
                String result = bigInt.toString(36);
                StringBuffer sb = new StringBuffer(32);
                for (int j2 = 0; j2 < result.length(); ++j2) {
                    if (j2 > 0 && j2 % 5 == 0) {
                        sb.append("-");
                    }
                    sb.append(result.charAt(j2));
                }
                return sb.toString().toUpperCase();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return null;
    }

    private static boolean isUp(NetworkInterface ni) {
        Class[] noParams = new Class[]{};
        try {
            Class<?> c = Class.forName("java.net.NetworkInterface");
            Method isUp = c.getDeclaredMethod("isUp", noParams);
            return (Boolean)isUp.invoke((Object)ni, (Object[])null);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isVirtual(NetworkInterface ni) {
        Class[] noParams = new Class[]{};
        try {
            Class<?> c = Class.forName("java.net.NetworkInterface");
            Method isVirtual = c.getDeclaredMethod("isVirtual", noParams);
            return (Boolean)isVirtual.invoke((Object)ni, (Object[])null);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static int stringHash(String value) {
        if (value == null) {
            return 0;
        }
        int off = 0;
        int len = value.length();
        int h = 0;
        for (int i = 0; i < len; ++i) {
            h = 31 * h + value.charAt(off++);
        }
        return h;
    }

    public static long getCheckSum(RuntimeInfo result) {
        long checksum = 0L;
        X500Principal hobj = result.getHolder();
        checksum += hobj == null ? 0L : (long)Runtime.stringHash(hobj.getName());
        X500Principal iobj = result.getIssuer();
        checksum += iobj == null ? 0L : (long)Runtime.stringHash(iobj.getName());
        int count = result.getConsumerAmount();
        checksum += (long)count;
        String type = result.getConsumerType();
        checksum += (long)Runtime.stringHash(type);
        String info = result.getInfo();
        checksum += (long)Runtime.stringHash(info);
        Date issued = result.getIssued();
        checksum += issued.getTime();
        Date start = result.getNotBefore();
        checksum += start == null ? 0L : start.getTime();
        Date end = result.getNotAfter();
        checksum += end == null ? 0L : end.getTime();
        String subject = result.getSubject();
        checksum += (long)Runtime.stringHash(subject);
        String licId = result.getLicId();
        checksum += (long)Runtime.stringHash(licId);
        String licVer = result.getLicVer();
        checksum += (long)Runtime.stringHash(licVer);
        String userId = result.getUserId();
        checksum += (long)Runtime.stringHash(userId);
        String userName = result.getUserName();
        checksum += (long)Runtime.stringHash(userName);
        String companyId = result.getCompanyId();
        checksum += (long)Runtime.stringHash(companyId);
        String companyName = result.getCompanyName();
        checksum += (long)Runtime.stringHash(companyName);
        long sessionCount = result.getSessionCount();
        checksum += sessionCount;
        String zssVer = result.getZssVer();
        return checksum += (long)Runtime.stringHash(zssVer);
    }

    protected abstract RuntimeLicenseManager getLicenseManager();

    public static final void token(Object exec, Object exec2) {
        Runtime.token0(exec, exec2);
    }

    public static final boolean token(Object exec) {
        return Runtime.token0(exec);
    }

    protected static void init0(Object obj, Class<? extends Runtime> cls) {
        if (obj instanceof WebApp) {
            try {
                Runtime rt = _runtimeMap.get(cls);
                ((WebApp)obj).getConfiguration().removeListener(rt.getInitClass());
                ((WebApp)obj).getConfiguration().addListener(rt.getInitClass());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected static final void token0(Object exec, Object exec2) {
        if (exec instanceof Execution) {
            ((Execution)exec2).setAttribute(Runtime.token1(exec), (Object)Boolean.TRUE);
        }
    }

    protected static final boolean token0(Object exec) {
        if (exec instanceof Execution) {
            return ((Execution)exec).getAttribute(Runtime.token1(exec)) != null;
        }
        return exec == null && ESCHERAGGREGATE_IMPL.equals(Library.getProperty((String)UTEST));
    }

    protected static final String token1(Object exec) {
        Desktop desktop;
        MessageDigest digest;
        String plaintext = "mgws" + (exec instanceof Execution ? ((Execution)exec).getDesktop().getId() : ((Desktop)exec).getId()) + "wysb";
        Execution exec0 = Executions.getCurrent();
        if (exec0 != null && (digest = (MessageDigest)(desktop = exec0.getDesktop()).getAttribute(MD + desktop.getId())) != null) {
            digest.reset();
            try {
                digest.update(plaintext.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            byte[] digested = digest.digest();
            BigInteger bigInt = new BigInteger(1, digested);
            return bigInt.toString(36);
        }
        return plaintext;
    }

    protected static final void initToken(Desktop desktop) {
        try {
            MessageDigest digest = MessageDigest.getInstance(MD5STR);
            desktop.setAttribute(MD + desktop.getId(), (Object)digest);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    protected static byte[] longToByteArray(long l) {
        return ByteBuffer.allocate(8).putLong(l).array();
    }

    protected static final void error(String msg) {
        Logger log = LoggerFactory.getLogger((String)"global");
        if (log.isErrorEnabled()) {
            log.error(msg);
        } else {
            System.err.println(msg);
        }
    }

    protected static URL getURLFromString(String dir) {
        try {
            return new File(dir).toURI().toURL();
        }
        catch (IOException e) {
            Runtime.error("getURLFromString: " + e.getMessage());
            return null;
        }
    }
}

