/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.jsp.ui;

import io.keikai.api.model.Book;
import io.keikai.jsp.BookProvider;
import io.keikai.jsp.ui.ComposerHandler;
import io.keikai.ui.Spreadsheet;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.DynamicAttributes;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.reflect.Fields;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.GenericRichlet;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Richlet;
import org.zkoss.zk.ui.ext.AfterCompose;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zkplus.embed.Renders;

public class SpreadsheetTag
extends SimpleTagSupport
implements DynamicAttributes,
Serializable {
    private static final long serialVersionUID = 6306465247069736585L;
    private static final Logger log = LoggerFactory.getLogger(SpreadsheetTag.class);
    private Spreadsheet _spreadsheet;
    private Map _attrMap = new LinkedHashMap();
    private String _use;
    private ComposerHandler _composehandler;
    private Object _bookProvider;

    public void doTag() throws JspException, IOException {
        PageContext pgCtx = (PageContext)this.getJspContext();
        final ServletContext svlctx = pgCtx.getServletContext();
        final HttpServletRequest request = (HttpServletRequest)pgCtx.getRequest();
        final HttpServletResponse response = (HttpServletResponse)pgCtx.getResponse();
        StringWriter writer = new StringWriter();
        final HashMap arg = new HashMap();
        try {
            Renders.render((ServletContext)svlctx, (HttpServletRequest)request, (HttpServletResponse)response, (Richlet)new GenericRichlet(){

                public void service(Page page) throws Exception {
                    SpreadsheetTag.this.initComponent(page);
                    BookProvider bp = SpreadsheetTag.this.getRealBookProvider();
                    if (bp != null) {
                        Book book = bp.loadBook(svlctx, request, response);
                        SpreadsheetTag.this._spreadsheet.setBook(book);
                    }
                    arg.put("zssId", SpreadsheetTag.this._spreadsheet.getId());
                    arg.put("zssUuid", SpreadsheetTag.this._spreadsheet.getUuid());
                    arg.put("desktopId", page.getDesktop().getId());
                    SpreadsheetTag.this.doAfterComposeComponent();
                }
            }, null, (Writer)writer);
            writer.append("<script type=\"text/javascript\">");
            String identify = "zssjsp['" + String.valueOf(arg.get("zssId")) + "']";
            writer.append("zk.afterLoad('zssjsp',function(){");
            writer.append(identify + "={};");
            writer.append(identify + ".uuid='" + String.valueOf(arg.get("zssUuid")) + "';");
            writer.append(identify + ".desktopId='" + String.valueOf(arg.get("desktopId")) + "';");
            writer.append("});");
            writer.append("</script>\n");
        }
        catch (ServletException e) {
            throw new JspException(e.getMessage(), (Throwable)e);
        }
        this.getJspContext().getOut().write(writer.toString());
    }

    protected void initComponent(Page page) throws Exception {
        String tagName = this.getComponentName();
        ComponentDefinition compdef = page.getComponentDefinition(tagName, true);
        if (compdef == null) {
            throw new JspException("can't find this Component's definition:" + tagName);
        }
        this._spreadsheet = (Spreadsheet)compdef.resolveImplementationClass(page, this.getUse()).newInstance();
        this._spreadsheet.setPage(page);
        this._composehandler = new ComposerHandler(this._attrMap.remove("apply"));
        this.evaluateDynaAttributes((Component)this._spreadsheet, this._attrMap);
    }

    protected String getComponentName() {
        return "spreadsheet";
    }

    protected void doAfterComposeComponent() throws JspException {
        if (this._spreadsheet instanceof AfterCompose) {
            this._spreadsheet.afterCompose();
        }
        this._composehandler.doAfterCompose((Component)this._spreadsheet);
    }

    protected void evaluateDynaAttributes(Component target, Map attrs) throws NoSuchMethodException {
        for (Map.Entry entry : attrs.entrySet()) {
            String attnm = (String)entry.getKey();
            Object value = entry.getValue();
            SpreadsheetTag.evaluateDynaAttribute(target, attnm, value);
        }
    }

    public static void evaluateDynaAttribute(Component target, String attnm, Object value) throws NoSuchMethodException {
        Fields.setByCompound((Object)target, (String)attnm, (Object)value, (boolean)true);
    }

    public void setDynamicAttribute(String uri, String localName, Object value) throws JspException {
        this._attrMap.put(localName, value);
    }

    public String getUse() {
        return this._use;
    }

    public void setUse(String use) {
        this._use = use;
    }

    public Object getBookProvider() {
        return this._bookProvider;
    }

    public void setBookProvider(Object bookProvider) {
        this._bookProvider = bookProvider;
    }

    private BookProvider getRealBookProvider() throws JspException {
        if (this._bookProvider == null || this._bookProvider instanceof BookProvider) {
            return (BookProvider)this._bookProvider;
        }
        Object p = null;
        if (this._bookProvider instanceof Class) {
            try {
                return (BookProvider)((Class)this._bookProvider).newInstance();
            }
            catch (Exception e) {
                throw new JspException(e.getMessage(), (Throwable)e);
            }
        }
        if (this._bookProvider instanceof String) {
            try {
                this.getClass();
                return (BookProvider)Class.forName((String)this._bookProvider).newInstance();
            }
            catch (Exception e) {
                throw new JspException(e.getMessage(), (Throwable)e);
            }
        }
        throw new JspException("can't initialize book provider by " + String.valueOf(this._bookProvider));
    }
}

