/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.jsp;

import io.keikai.api.model.Book;
import io.keikai.jsp.JsonUpdateBridge;
import io.keikai.ui.Spreadsheet;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.json.JSONObject;
import org.zkoss.zk.ui.Desktop;

public class SmartUpdateBridge
extends JsonUpdateBridge {
    private static String KEY_DESKTOP = "$dtid";
    private static String KEY_COMPONENT = "$uid";
    private String uuid;
    private Builder builder;

    private SmartUpdateBridge(Builder builder, ServletContext servletContext, HttpServletRequest req, HttpServletResponse resp, String desktopId, String uuid) {
        super(servletContext, req, resp, desktopId);
        this.uuid = uuid;
        this.builder = builder;
    }

    protected void process(Desktop desktop) throws Exception {
        Spreadsheet ss = (Spreadsheet)desktop.getComponentByUuidIfAny(this.uuid);
        if (this.builder._withComp != null) {
            this.builder._withComp.accept(ss);
        }
        Book book = ss.getBook();
        if (this.builder._withBook != null) {
            this.builder._withBook.accept(book);
        }
    }

    public static final class Builder {
        private SmartUpdateBridge _bridge;
        Consumer<Spreadsheet> _withComp;
        Consumer<Book> _withBook;

        private Builder(ServletContext servletContext, HttpServletRequest req, HttpServletResponse resp, Map requestData) {
            String desktopId = (String)(requestData != null ? requestData.get(KEY_DESKTOP) : req.getParameter(KEY_DESKTOP));
            String uuid = (String)(requestData != null ? requestData.get(KEY_COMPONENT) : req.getParameter(KEY_COMPONENT));
            this._bridge = new SmartUpdateBridge(this, servletContext, req, resp, desktopId, uuid);
        }

        public static Builder create(ServletContext servletContext, HttpServletRequest req, HttpServletResponse resp) {
            return Builder.create(servletContext, req, resp, null);
        }

        public static Builder create(ServletContext servletContext, HttpServletRequest req, HttpServletResponse resp, Map data) {
            return new Builder(servletContext, req, resp, data);
        }

        public Builder withComponent(Consumer<Spreadsheet> consumer) {
            this._withComp = consumer;
            return this;
        }

        public Builder withBook(Consumer<Book> consumer) {
            this._withBook = consumer;
            return this;
        }

        public Map build() {
            return this.build(Collections.emptyMap());
        }

        public Map build(Map result) {
            JSONObject map = new JSONObject();
            this._bridge.process(map);
            map.putAll(result);
            return map;
        }
    }
}

