/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.jsf.ui.impl;

import io.keikai.jsf.ui.impl.ObjectHolder;

public abstract class ObjectHolderContext {
    private static ThreadLocal<ObjectHolder> holder = new ThreadLocal();

    public static ObjectHolderContext setHolder(ObjectHolder pool) {
        ObjectHolderContext old = holder.get();
        holder.set(pool);
        return old;
    }

    public static boolean hasHolder() {
        return holder.get() != null;
    }

    public static ObjectHolderContext removeHolder() {
        ObjectHolderContext old = holder.get();
        holder.remove();
        return old;
    }

    public static Object getObjectIfAny(String desktopId, String objId) {
        ObjectHolder holder = ObjectHolderContext.holder.get();
        if (holder == null) {
            return null;
        }
        return holder.get(desktopId + "." + objId);
    }

    public static void putObject(String desktopId, String objId, Object object) {
        ObjectHolder holder = ObjectHolderContext.holder.get();
        if (holder != null) {
            holder.put(desktopId + "." + objId, object);
        }
    }
}

