/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.jsf.ui.impl;

import io.keikai.jsf.Action;
import io.keikai.jsf.ActionBridge;
import io.keikai.jsf.ui.impl.FacesUtil;
import io.keikai.jsf.ui.impl.JSFComponentBase;
import io.keikaiex.ui.impl.BridgeFix;
import java.io.Serializable;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.Desktop;

public class ActionBridgeImpl
implements ActionBridge,
Serializable {
    private static final long serialVersionUID = -5308561049234051800L;
    String clientId;
    String compUuid;

    public ActionBridgeImpl(String clientId, String compUuid) {
        this.clientId = clientId;
        this.compUuid = compUuid;
    }

    @Override
    public void execute(Action action) {
        this.execute(action, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(Action action, boolean auto) {
        FacesContext context = FacesContext.getCurrentInstance();
        ServletContext svlctx = (ServletContext)context.getExternalContext().getContext();
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        UIComponent uicomp = FacesUtil.searchComponent(null, this.clientId);
        if (!(uicomp instanceof JSFComponentBase)) {
            throw new ComponentNotFoundException("(" + this.clientId + ") component is not a zkcomponentbase, is " + String.valueOf(uicomp));
        }
        Desktop desktop = ((JSFComponentBase)uicomp).getZKDesktop();
        if (desktop == null) {
            if (!auto) throw new ComponentNotFoundException("can't find any desktop " + ((JSFComponentBase)uicomp).getZKDesktopId() + " to excute inside it");
            action.execute();
            return;
        }
        BridgeFix zbridge = new BridgeFix();
        zbridge.start(svlctx, request, response, desktop);
        try {
            action.execute();
            String zkjs = zbridge.getResult();
            if (Strings.isEmpty((String)zkjs)) return;
            zkjs = this.getCheckComponentJS(zkjs);
            FacesUtil.addUpdateScript(this.clientId, zkjs);
            return;
        }
        finally {
            zbridge.close();
        }
    }

    private String getCheckComponentJS(String zkjs) {
        StringBuilder sb = new StringBuilder();
        sb.append("if(zssjsf.isDomExist('").append(this.compUuid).append("')){\n").append(zkjs).append("\n}\n");
        return sb.toString();
    }
}

