/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.jsf;

import io.keikai.jsf.ui.impl.ObjectHolder;
import io.keikai.jsf.ui.impl.ObjectHolderContext;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ObjectHolderFilter
implements Filter,
Serializable {
    private static final long serialVersionUID = 3007219598969201384L;
    int millisecondToRemove = 6000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpSession session = req.getSession(false);
        if (session != null) {
            ObjectHolder holder = new ObjectHolder(session, this.millisecondToRemove);
            ObjectHolderContext.setHolder(holder);
            try {
                chain.doFilter(request, response);
            }
            finally {
                holder.kick();
                ObjectHolderContext.removeHolder();
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig config) throws ServletException {
        String arg = config.getInitParameter("millisecondToRemove");
        if (arg != null) {
            this.millisecondToRemove = Integer.parseInt(arg);
        }
    }

    public void destroy() {
    }
}

