/* Commentpopup.js

	Purpose:
		
	Description:
		
	History:
		Tue Dec 16, 2014 15:36:18 AM , Created by JerryChen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
*/

(function () {
  var zssctrl$override = {},
    zsscell$override = {},
    zssrow$override = {};

  // ZSS-849
  // two cases should be caught. one is on cell, the other is on select mark. 
  zk.override(zss.SSheetCtrl.prototype, zssctrl$override, {
    // hover on select mark
    doMouseOver_: function (evt) {
      zssctrl$override.doMouseOver_.apply(this, arguments);
      var target = evt.target,
        $domTarget = jq(evt.domTarget);
      if ($domTarget.hasClass('zsselecti') || $domTarget.hasClass('zshighlight') || $domTarget.hasClass('zshighlighti')) {
        var mx = evt.pageX,
          my = evt.pageY,
          cellpos = zss.SSheetCtrl._calCellPos(this, mx, my, false),
          row = cellpos[0],
          col = cellpos[1],
          cell = this.getCell(row, col);
        if (cell != null && cell.merr) {
          let mergeCell = this.getCell(cell.mert, cell.merl);
          if (mergeCell) {
            cell = mergeCell;
          }
        }
        if (cell) this._showCellComment(cell);
      }
    },
    // hover on cell. this function will triggered by cell's doMouseOver_
    doCellMouseOver: function (evt) {
      if (zssctrl$override.doCellMouseOver) zssctrl$override.doCellMouseOver.apply(this, arguments);
      var target = evt.target;
      if (target.widgetName === 'Cell') this._showCellComment(target);
    },
    _showCellComment: function (target) {
      if (this._hoverCell !== target) {
        var window = this.commentWindow,
          menuPopup = this.getStyleMenupopup();
        this._hovercell = target;
        if (!(menuPopup && menuPopup.isOpen()) && target.comment) {
          jq(window.$n('cave')).html(target.comment.t);
          window.open(target, null, 'end_before', {
            dodgeRef: true
          });
        } else {
          if (window.isOpen()) window.close();
        }
      }
    },
    bind_: function (desktop, skipper, after) {
      zssctrl$override.bind_.apply(this, arguments);
      this.appendChild(this.commentWindow = new zul.wgt.Popup({
        sclass: 'zscellcomment-popup',
        _zclass: 'zss-popup'
      }));
    },
    unbind_: function () {
      this.commentWindow = null;
      zssctrl$override.unbind_.apply(this, arguments);
    }
  });
  zk.override(zss.Cell.prototype, zsscell$override, {
    // trigger ssheetCtrl's doCellMouseOver
    doMouseOver_: function (evt) {
      this.sheet.doCellMouseOver(evt);
      zsscell$override.doMouseOver_.apply(this, arguments);
    },
    update_: function () {
      zsscell$override.update_.apply(this, arguments);
      var r = this.r,
        c = this.c,
        data = this.src.getRow(r).getCell(c),
        cmt = data.comment;
      if (cmt != this.comment) {
        this.comment = cmt;
        var ncomment = this.$n('comment');
        if (!ncomment) {
          if (cmt) {
            jq(this.$n('real')).before(this.getCommentHtml(true));
            this.clearCache();
          }
        } else {
          //ZSS-849
          jq(ncomment)[cmt ? 'removeClass' : 'addClass']('zscellcomment-hidden');
          // 1. this.comment.t -> string in RichText html form
          // 2. this.comment.v -> boolean. true: always show the comment; false: show when mouse hover on the cell
          // TODO:
        }
      }
    },
    getCommentHtml: function (shown) {
      return shown ? '<div id="' + this.uuid + '-comment" class="zscellcomment"></div>' : '';
    },
    // KEIKAI-200: use elements instead string to reduce html parsing time
    getCommentHtmlDom: function (shown) {
      if (!shown) {
        return null;
      }
      const el = document.createElement('div');
      el.id = this.uuid + '-comment';
      el.className = 'zscellcomment';
      return el;
    }
  });
  zk.override(zss.Row.prototype, zssrow$override, {
    // trigger ssheetCtrl's doCellMouseOver
    doMouseOver_: function (evt) {
      var sheet = this.sheet,
        mx = evt.pageX,
        my = evt.pageY,
        position = zss.SSheetCtrl._calCellPos(sheet, mx, my),
        row = position[0],
        column = position[1],
        cell = sheet.getCell(row, column);
      if (cell) {
        //ZSS-454 Cannot click on hyperlink in the merge cell.
        if (cell.isMerged()) {
          let mergeCell = sheet.getCell(cell.mert, cell.merl);
          if (mergeCell) {
            cell = mergeCell;
          }
        }
        this.sheet._showCellComment(cell);
      }
      zssrow$override.doMouseOver_.apply(this, arguments);
    }
  });
})();