/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.util;

import io.keikai.model.SChart;
import io.keikaiex.util.JFreeChartHelper;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.DefaultOHLCDataset;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.data.xy.OHLCDataItem;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.data.xy.XYZDataset;
import org.zkoss.zul.CategoryModel;
import org.zkoss.zul.ChartModel;
import org.zkoss.zul.HiLoModel;
import org.zkoss.zul.PieModel;
import org.zkoss.zul.XYModel;
import org.zkoss.zul.XYZModel;

public class ZssChartExportEngine
implements Serializable {
    private static final long serialVersionUID = 1634778378984535862L;
    protected final SChart _chartInfo;
    private static final String DEFAULT_HI_LO_SERIES = "High Low Data";
    static final int POS_B = 1;
    static final int POS_TR = 2;
    static final int POS_L = 3;
    static final int POS_R = 4;
    static final int POS_T = 5;

    public ZssChartExportEngine(SChart chartInfo) {
        this._chartInfo = chartInfo;
    }

    public JFreeChart drawJFreeChart() {
        if (this._chartInfo == null) {
            return null;
        }
        JFreeChart jfchart = this.createJFreeChart();
        if (jfchart == null) {
            return null;
        }
        if (!this.prepareJFreeChart(jfchart)) {
            PiePlot pplot;
            LegendTitle title;
            Font lfont;
            TextTitle title2;
            int fgAlpha = 128;
            int[] bgRGB = new int[]{255, 255, 255};
            int bgAlpha = 255;
            Plot plot = jfchart.getPlot();
            float alpha = (float)fgAlpha / 255.0f;
            plot.setForegroundAlpha(alpha);
            alpha = (float)bgAlpha / 255.0f;
            plot.setBackgroundAlpha(alpha);
            plot.setBackgroundPaint((Paint)new Color(bgRGB[0], bgRGB[1], bgRGB[2], bgAlpha));
            jfchart.setBackgroundPaint((Paint)Color.WHITE);
            Font tfont = JFreeChartHelper.getCustomFont("io.keikai.chart.title.font");
            if (tfont != null && (title2 = jfchart.getTitle()) != null) {
                title2.setFont(tfont);
            }
            if ((lfont = JFreeChartHelper.getCustomFont("io.keikai.chart.legend.font")) != null && (title = jfchart.getLegend()) != null) {
                title.setItemFont(lfont);
            }
            if (plot instanceof PiePlot) {
                pplot = (PiePlot)plot;
                Font xlbfont = JFreeChartHelper.getCustomFont("io.keikai.chart.xAxisTick.font");
                if (xlbfont != null) {
                    pplot.setLabelFont(xlbfont);
                }
            } else if (plot instanceof CategoryPlot) {
                ValueAxis axis;
                CategoryAxis axis2;
                CategoryPlot cplot = (CategoryPlot)plot;
                cplot.setRangeGridlinePaint((Paint)new Color(192, 192, 192));
                Font xlbfont = JFreeChartHelper.getCustomFont("io.keikai.chart.xAxisTick.font");
                Font xtkfont = JFreeChartHelper.getCustomFont("io.keikai.chart.xAxisTick.font");
                if (xlbfont != null && (axis2 = cplot.getDomainAxis()) != null) {
                    axis2.setLabelFont(xlbfont);
                }
                if (xtkfont != null && (axis2 = cplot.getDomainAxis()) != null) {
                    axis2.setTickLabelFont(xtkfont);
                }
                Font ylbfont = JFreeChartHelper.getCustomFont("io.keikai.chart.yAxisTick.font");
                Font ytkfont = JFreeChartHelper.getCustomFont("io.keikai.chart.yAxisTick.font");
                if (ylbfont != null && (axis = cplot.getRangeAxis()) != null) {
                    axis.setLabelFont(ylbfont);
                }
                if (ytkfont != null && (axis = cplot.getRangeAxis()) != null) {
                    axis.setTickLabelFont(ytkfont);
                }
            } else if (plot instanceof XYPlot) {
                ValueAxis axis;
                ValueAxis axis3;
                XYPlot xyplot = (XYPlot)plot;
                xyplot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
                xyplot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
                Font xlbfont = JFreeChartHelper.getCustomFont("io.keikai.chart.xAxisTick.font");
                Font xtkfont = JFreeChartHelper.getCustomFont("io.keikai.chart.xAxisTick.font");
                if (xlbfont != null && (axis3 = xyplot.getDomainAxis()) != null) {
                    axis3.setLabelFont(xlbfont);
                }
                if (xtkfont != null && (axis3 = xyplot.getDomainAxis()) != null) {
                    axis3.setTickLabelFont(xtkfont);
                }
                Font ylbfont = JFreeChartHelper.getCustomFont("io.keikai.chart.yAxisTick.font");
                Font ytkfont = JFreeChartHelper.getCustomFont("io.keikai.chart.yAxisTick.font");
                if (ylbfont != null && (axis = xyplot.getRangeAxis()) != null) {
                    axis.setLabelFont(ylbfont);
                }
                if (ytkfont != null && (axis = xyplot.getRangeAxis()) != null) {
                    axis.setTickLabelFont(ytkfont);
                }
            } else if (plot instanceof PolarPlot) {
                pplot = (PolarPlot)plot;
                pplot.setAngleGridlinePaint((Paint)Color.LIGHT_GRAY);
                pplot.setRadiusGridlinePaint((Paint)Color.LIGHT_GRAY);
                Font xlbfont = JFreeChartHelper.getCustomFont("io.keikai.chart.xAxisTick.font");
                if (xlbfont != null) {
                    pplot.setAngleLabelFont(xlbfont);
                }
            }
        }
        return jfchart;
    }

    protected boolean prepareJFreeChart(JFreeChart jfchart) {
        jfchart.getPlot().setOutlineVisible(false);
        jfchart.getLegend().setFrame((BlockFrame)BlockBorder.NONE);
        if (this.hasLegend()) {
            RectangleEdge edge = null;
            switch (this.getLegendPos()) {
                case 1: {
                    edge = RectangleEdge.BOTTOM;
                    break;
                }
                case 3: {
                    edge = RectangleEdge.LEFT;
                    break;
                }
                case 5: {
                    edge = RectangleEdge.TOP;
                    break;
                }
                default: {
                    edge = RectangleEdge.RIGHT;
                }
            }
            jfchart.getLegend().setPosition(edge);
        } else {
            jfchart.getLegend().setVisible(false);
        }
        JFreeChartHelper.prepareAxis(jfchart, this._chartInfo);
        return false;
    }

    protected JFreeChart createJFreeChart() {
        JFreeChart jfchart = null;
        String type = JFreeChartHelper.getChartType(this._chartInfo);
        if (type.equals("area")) {
            ChartModel model = JFreeChartHelper.prepareCategoryModel(this._chartInfo.getData());
            jfchart = ChartFactory.createAreaChart((String)this._chartInfo.getTitle(), (String)this._chartInfo.getXAxisTitle(), (String)this._chartInfo.getYAxisTitle(), (CategoryDataset)this.CategoryModelToCategoryDataset((CategoryModel)model), (PlotOrientation)JFreeChartHelper.getOrientation(this._chartInfo), (boolean)true, (boolean)true, (boolean)true);
        } else if (type.equals("stacked_area")) {
            ChartModel model = JFreeChartHelper.prepareCategoryModel(this._chartInfo.getData());
            jfchart = ChartFactory.createStackedAreaChart((String)this._chartInfo.getTitle(), (String)this._chartInfo.getXAxisTitle(), (String)this._chartInfo.getYAxisTitle(), (CategoryDataset)this.CategoryModelToCategoryDataset((CategoryModel)model), (PlotOrientation)JFreeChartHelper.getOrientation(this._chartInfo), (boolean)true, (boolean)true, (boolean)true);
        } else if (type.equals("stacked_bar")) {
            ChartModel model = JFreeChartHelper.prepareCategoryModel(this._chartInfo.getData());
            jfchart = this._chartInfo.isThreeD() ? ChartFactory.createStackedBarChart((String)this._chartInfo.getTitle(), (String)this._chartInfo.getXAxisTitle(), (String)this._chartInfo.getYAxisTitle(), (CategoryDataset)this.CategoryModelToCategoryDataset((CategoryModel)model), (PlotOrientation)JFreeChartHelper.getOrientation(this._chartInfo), (boolean)true, (boolean)true, (boolean)true) : ChartFactory.createStackedBarChart((String)this._chartInfo.getTitle(), (String)this._chartInfo.getXAxisTitle(), (String)this._chartInfo.getYAxisTitle(), (CategoryDataset)this.CategoryModelToCategoryDataset((CategoryModel)model), (PlotOrientation)JFreeChartHelper.getOrientation(this._chartInfo), (boolean)true, (boolean)true, (boolean)true);
        } else if (type.equals("bar")) {
            ChartModel model = JFreeChartHelper.prepareCategoryModel(this._chartInfo.getData());
            jfchart = this._chartInfo.isThreeD() ? ChartFactory.createBarChart((String)this._chartInfo.getTitle(), (String)this._chartInfo.getXAxisTitle(), (String)this._chartInfo.getYAxisTitle(), (CategoryDataset)this.CategoryModelToCategoryDataset((CategoryModel)model), (PlotOrientation)JFreeChartHelper.getOrientation(this._chartInfo), (boolean)true, (boolean)true, (boolean)true) : ChartFactory.createBarChart((String)this._chartInfo.getTitle(), (String)this._chartInfo.getXAxisTitle(), (String)this._chartInfo.getYAxisTitle(), (CategoryDataset)this.CategoryModelToCategoryDataset((CategoryModel)model), (PlotOrientation)JFreeChartHelper.getOrientation(this._chartInfo), (boolean)true, (boolean)true, (boolean)true);
        } else if (type.equals("line")) {
            ChartModel model = JFreeChartHelper.prepareCategoryModel(this._chartInfo.getData());
            jfchart = this._chartInfo.isThreeD() ? ChartFactory.createLineChart((String)this._chartInfo.getTitle(), (String)this._chartInfo.getXAxisTitle(), (String)this._chartInfo.getYAxisTitle(), (CategoryDataset)this.CategoryModelToCategoryDataset((CategoryModel)model), (PlotOrientation)JFreeChartHelper.getOrientation(this._chartInfo), (boolean)true, (boolean)true, (boolean)true) : ChartFactory.createLineChart((String)this._chartInfo.getTitle(), (String)this._chartInfo.getXAxisTitle(), (String)this._chartInfo.getYAxisTitle(), (CategoryDataset)this.CategoryModelToCategoryDataset((CategoryModel)model), (PlotOrientation)JFreeChartHelper.getOrientation(this._chartInfo), (boolean)true, (boolean)true, (boolean)true);
        } else if (type.equals("pie")) {
            ChartModel model = JFreeChartHelper.preparePieModel(this._chartInfo.getData());
            jfchart = this._chartInfo.isThreeD() ? ChartFactory.createPieChart3D((String)this._chartInfo.getTitle(), (PieDataset)this.PieModelToPieDataset((PieModel)model), (boolean)true, (boolean)true, (boolean)true) : ChartFactory.createPieChart((String)this._chartInfo.getTitle(), (PieDataset)this.PieModelToPieDataset((PieModel)model), (boolean)true, (boolean)true, (boolean)true);
        } else if (type.equals("scatter")) {
            XYModel model = JFreeChartHelper.prepareXYModel(this._chartInfo.getData());
            jfchart = ChartFactory.createScatterPlot((String)this._chartInfo.getTitle(), (String)this._chartInfo.getXAxisTitle(), (String)this._chartInfo.getYAxisTitle(), (XYDataset)this.XYModelToXYDataset(model), (PlotOrientation)JFreeChartHelper.getOrientation(this._chartInfo), (boolean)true, (boolean)true, (boolean)true);
        } else if (!type.equals("candlestick")) {
            if (type.equals("bubble")) {
                XYZModel model = JFreeChartHelper.prepareXYZModel(this._chartInfo.getData());
                jfchart = ChartFactory.createBubbleChart((String)this._chartInfo.getTitle(), (String)this._chartInfo.getXAxisTitle(), (String)this._chartInfo.getYAxisTitle(), (XYZDataset)this.XYZModelToXYZDataset(model), (PlotOrientation)JFreeChartHelper.getOrientation(this._chartInfo), (boolean)true, (boolean)true, (boolean)true);
            } else if (type.equals("highlow")) {
                ChartModel model = JFreeChartHelper.prepareHiLoModel(this._chartInfo.getData());
                jfchart = ChartFactory.createHighLowChart((String)this._chartInfo.getTitle(), (String)this._chartInfo.getXAxisTitle(), (String)this._chartInfo.getYAxisTitle(), (OHLCDataset)this.HiLoModelToOHLCDataset((HiLoModel)model), (boolean)true);
            } else if (type.equals("ring")) {
                ChartModel model = JFreeChartHelper.preparePieModel(this._chartInfo.getData());
                jfchart = ChartFactory.createRingChart((String)this._chartInfo.getTitle(), (PieDataset)this.PieModelToPieDataset((PieModel)model), (boolean)true, (boolean)true, (boolean)true);
            }
        }
        return jfchart;
    }

    protected PieDataset PieModelToPieDataset(PieModel model) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        for (Comparable category : model.getCategories()) {
            Number value = model.getValue(category);
            dataset.setValue(category, value);
        }
        return dataset;
    }

    protected CategoryDataset CategoryModelToCategoryDataset(CategoryModel model) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (List key : model.getKeys()) {
            Comparable series = (Comparable)key.get(0);
            Comparable category = (Comparable)key.get(1);
            Number value = model.getValue(series, category);
            dataset.setValue(value, series, category);
        }
        return dataset;
    }

    protected XYDataset XYModelToXYDataset(XYModel model) {
        XYSeriesCollection dataset = new XYSeriesCollection();
        for (Comparable series : model.getSeries()) {
            XYSeries xyser = new XYSeries(series, model.isAutoSort());
            int size = model.getDataCount(series);
            for (int j = 0; j < size; ++j) {
                xyser.add(model.getX(series, j), model.getY(series, j), false);
            }
            dataset.addSeries(xyser);
        }
        return dataset;
    }

    protected XYZDataset XYZModelToXYZDataset(XYZModel model) {
        DefaultXYZDataset dataset = new DefaultXYZDataset();
        for (Comparable seriesKey : model.getSeries()) {
            int size = model.getDataCount(seriesKey);
            double[][] data = new double[3][size];
            for (int j = 0; j < size; ++j) {
                data[0][j] = model.getX(seriesKey, j).doubleValue();
                data[1][j] = model.getY(seriesKey, j).doubleValue();
                data[2][j] = model.getZ(seriesKey, j).doubleValue();
            }
            dataset.addSeries(seriesKey, data);
        }
        return dataset;
    }

    protected OHLCDataset HiLoModelToOHLCDataset(HiLoModel model) {
        int size = model.getDataCount();
        OHLCDataItem[] items = new OHLCDataItem[size];
        for (int j = 0; j < size; ++j) {
            OHLCDataItem item;
            Date date = model.getDate(j);
            Number open = model.getOpen(j);
            Number high = model.getHigh(j);
            Number low = model.getLow(j);
            Number close = model.getClose(j);
            Number volume = model.getVolume(j);
            items[j] = item = new OHLCDataItem(date, this.doubleValue(open), this.doubleValue(high), this.doubleValue(low), this.doubleValue(close), this.doubleValue(volume));
        }
        Object series = model.getSeries();
        if (series == null) {
            series = DEFAULT_HI_LO_SERIES;
        }
        return new DefaultOHLCDataset((Comparable)series, items);
    }

    protected double doubleValue(Number n) {
        return n == null ? 0.0 : n.doubleValue();
    }

    private boolean hasLegend() {
        return this._chartInfo.getLegendPosition() != null;
    }

    private int getLegendPos() {
        switch (this._chartInfo.getLegendPosition()) {
            case BOTTOM: {
                return 1;
            }
            case LEFT: {
                return 3;
            }
            case TOP: {
                return 5;
            }
            case TOP_RIGHT: {
                return 2;
            }
        }
        return 4;
    }
}

