/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.util;

import io.keikaiex.util.Interval;
import io.keikaiex.util.IntervalContext;
import io.keikaiex.util.IntervalNode;
import io.keikaiex.util.RBNode;
import io.keikaiex.util.RBTree;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class IntervalTree<T>
extends RBTree<Integer, Integer> {
    private static final long serialVersionUID = -2654053199525380277L;
    private static Comparator<Integer> comparator = new MyComparator();
    final int maxLimit;

    public IntervalTree(int maxLimit) {
        super(comparator);
        this.maxLimit = maxLimit;
    }

    IntervalNode<T> getRoot() {
        return (IntervalNode)this.root;
    }

    public Interval<T> insertInterval(Interval<T> interval, Object context) {
        IntervalContext ictx = new IntervalContext(context, null);
        this.insert(new IntervalNode<T>(interval), ictx);
        return ictx.original == null ? interval : ictx.original;
    }

    public Interval<T> deleteInterval(Interval<T> interval, Object context) {
        IntervalContext<T> ictx = new IntervalContext<T>(context, interval);
        return this.delete(interval.getLow(), ictx) == null ? null : ictx.original;
    }

    public Interval<T> searchInterval(Interval<T> interval) {
        RBNode node = this.search(interval.getLow());
        return node == null ? null : ((IntervalNode)node).searchInterval(interval);
    }

    public Collection<Interval<T>> contains(final Interval<T> interval) {
        final ArrayList<Interval<T>> results = new ArrayList<Interval<T>>();
        this._visitContains((IntervalNode)this.root, interval, new ApplyNode<T>(){
            private static final long serialVersionUID = -495009088711483294L;

            @Override
            public void apply(IntervalNode<T> node) {
                node.contains(interval, results);
            }
        });
        return results;
    }

    public Collection<Interval<T>> contained(final Interval<T> interval) {
        final ArrayList<Interval<T>> results = new ArrayList<Interval<T>>();
        this._visitContained((IntervalNode)this.root, interval, new ApplyNode<T>(){
            private static final long serialVersionUID = 4431159001518937204L;

            @Override
            public void apply(IntervalNode<T> node) {
                node.contained(interval, results);
            }
        });
        return results;
    }

    public Collection<Interval<T>> overlaps(final Interval<T> interval) {
        final ArrayList<Interval<T>> results = new ArrayList<Interval<T>>();
        this._visitOverlaps((IntervalNode)this.root, interval, new ApplyNode<T>(){
            private static final long serialVersionUID = -7582337954671821299L;

            @Override
            public void apply(IntervalNode<T> node) {
                node.overlaps(interval, results);
            }
        });
        return results;
    }

    void _visitContains(IntervalNode<T> node, Interval<T> interval, ApplyNode<T> visitNode) {
        if (node == null || (Integer)node.getValue() < interval.getHigh()) {
            return;
        }
        if (node.getLeft() != null) {
            this._visitContains((IntervalNode<T>)node.getLeft(), interval, visitNode);
        }
        if (interval.getLow() > (Integer)node.getKey() && node.getRight() != null) {
            this._visitContains((IntervalNode<T>)node.getRight(), interval, visitNode);
        }
        visitNode.apply(node);
    }

    void _visitContained(IntervalNode<T> node, Interval<T> interval, ApplyNode<T> visitNode) {
        if (node == null || (Integer)node.getValue() < interval.getLow()) {
            return;
        }
        if ((Integer)node.getKey() > interval.getLow() && node.getLeft() != null) {
            this._visitContained((IntervalNode<T>)node.getLeft(), interval, visitNode);
        }
        if (interval.getHigh() >= (Integer)node.getKey() && node.getRight() != null) {
            this._visitContained((IntervalNode<T>)node.getRight(), interval, visitNode);
        }
        visitNode.apply(node);
    }

    void _visitOverlaps(IntervalNode<T> node, Interval<T> interval, ApplyNode<T> visitNode) {
        if (node == null || (Integer)node.getValue() < interval.getLow()) {
            return;
        }
        if (node.getLeft() != null) {
            this._visitOverlaps((IntervalNode<T>)node.getLeft(), interval, visitNode);
        }
        if (interval.getHigh() >= (Integer)node.getKey() && node.getRight() != null) {
            this._visitOverlaps((IntervalNode<T>)node.getRight(), interval, visitNode);
        }
        visitNode.apply(node);
    }

    @Override
    protected void insertDuplicate(RBNode<Integer, Integer> original, RBNode<Integer, Integer> newone, Object context) {
        IntervalNode org = (IntervalNode)original;
        IntervalNode none = (IntervalNode)newone;
        for (Interval intv : none.intervals) {
            org.insertInterval(intv, context);
        }
        org.updateTopHigh();
    }

    @Override
    protected void insertLeft(RBNode<Integer, Integer> parent, RBNode<Integer, Integer> child) {
        super.insertLeft(parent, child);
        this._updateTopHigh((IntervalNode)parent);
    }

    @Override
    protected void insertRight(RBNode<Integer, Integer> parent, RBNode<Integer, Integer> child) {
        super.insertRight(parent, child);
        this._updateTopHigh((IntervalNode)parent);
    }

    @Override
    protected void rightJumpUp(RBNode<Integer, Integer> g) {
        IntervalNode p = (IntervalNode)g.getLeft();
        RBNode n = p.getRight();
        super.rightJumpUp(g);
        this._updateTopHigh(p);
        this._updateTopHigh((IntervalNode)g);
        this._updateTopHigh((IntervalNode<T>)n);
    }

    @Override
    protected void leftJumpUp(RBNode<Integer, Integer> g) {
        IntervalNode p = (IntervalNode)g.getRight();
        RBNode n = p.getLeft();
        super.leftJumpUp(g);
        this._updateTopHigh((IntervalNode)g);
        this._updateTopHigh(p);
        this._updateTopHigh((IntervalNode<T>)n);
    }

    @Override
    protected void rotateRight(RBNode<Integer, Integer> g) {
        IntervalNode p = (IntervalNode)g.getLeft();
        super.rotateRight(g);
        this._updateTopHigh((IntervalNode)g);
        this._updateTopHigh(p);
    }

    @Override
    protected void rotateLeft(RBNode<Integer, Integer> g) {
        IntervalNode p = (IntervalNode)g.getRight();
        super.rotateLeft(g);
        this._updateTopHigh((IntervalNode)g);
        this._updateTopHigh(p);
    }

    @Override
    protected void fixUp(List<RBTree.Traversal<Integer, Integer>> lineal) {
        int j = lineal.size();
        while (--j >= 0) {
            RBTree.Traversal<Integer, Integer> tr = lineal.get(j);
            if (!this._updateTopHigh((IntervalNode)tr.node)) continue;
            break;
        }
    }

    @Override
    protected void replaceNode(RBNode<Integer, Integer> target, RBNode<Integer, Integer> substitute) {
        target.setKey(substitute.getKey());
        ((IntervalNode)target).intervals = ((IntervalNode)substitute).intervals;
        this._updateTopHigh((IntervalNode)target);
    }

    @Override
    protected boolean canDeleteNode(RBNode<Integer, Integer> n, Object ctx) {
        IntervalContext ictx = (IntervalContext)ctx;
        IntervalNode node = (IntervalNode)n;
        if (ictx != null) {
            Interval result = node.deleteInterval(ictx.original, ictx.context);
            ictx.original = result;
        }
        return node.intervals == null || node.intervals.isEmpty();
    }

    boolean _updateTopHigh(IntervalNode<T> p) {
        return p.updateTopHigh();
    }

    private static class MyComparator
    implements Comparator<Integer>,
    Serializable {
        private static final long serialVersionUID = 326442974529571847L;

        private MyComparator() {
        }

        @Override
        public int compare(Integer a, Integer b) {
            return a - b;
        }
    }

    private static interface ApplyNode<T>
    extends Serializable {
        public void apply(IntervalNode<T> var1);
    }
}

