/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.util;

import io.keikaiex.util.Interval;
import io.keikaiex.util.IntervalContext;
import io.keikaiex.util.ParallelIntervals;
import io.keikaiex.util.RBNode;
import java.util.Collection;

class IntervalNode<T>
extends RBNode<Integer, Integer> {
    private static final long serialVersionUID = 2234929561334842768L;
    ParallelIntervals<T> intervals = new ParallelIntervals();

    IntervalNode(Interval<T> interval) {
        super(interval.getLow(), interval.getHigh());
        this.intervals.insertInterval(interval);
    }

    Interval<T> insertInterval(Interval<T> interval, Object context) {
        ParallelIntervals.IntervalResult<T> result = this.intervals.insertInterval(interval);
        if (result.index >= 0) {
            this.insertDuplicateInterval(result.interval, interval, context);
        }
        return result.interval;
    }

    protected void insertDuplicateInterval(Interval<T> original, Interval<T> newone, Object context) {
        if (original.getPayload() == null) {
            original.setPayload(newone.getPayload());
        }
        ((IntervalContext)context).original = original;
    }

    Interval<T> deleteInterval(Interval<T> interval, Object context) {
        ParallelIntervals.IntervalResult<T> result = this.intervals.searchInterval(interval);
        if (result != null && this.canDeleteInterval(result.interval, interval, context)) {
            return this.intervals.deleteInterval(result.index);
        }
        return null;
    }

    boolean canDeleteInterval(Interval<T> original, Interval<T> refernce, Object context) {
        original.setPayload(null);
        return true;
    }

    Interval<T> searchInterval(Interval<T> interval) {
        ParallelIntervals.IntervalResult<T> result = this.intervals.searchInterval(interval);
        return result == null ? null : result.interval;
    }

    int getMaxHigh() {
        return this.intervals.getMax();
    }

    void contains(Interval<T> interval, Collection<Interval<T>> results) {
        this.intervals.contains(interval, results);
    }

    void overlaps(Interval<T> interval, Collection<Interval<T>> results) {
        this.intervals.overlaps(interval, results);
    }

    void contained(Interval<T> interval, Collection<Interval<T>> results) {
        this.intervals.contained(interval, results);
    }

    boolean updateTopHigh() {
        RBNode l = this.getLeft();
        RBNode r = this.getRight();
        int t = this.getMaxHigh();
        if (l != null && (Integer)l.getValue() > t) {
            t = (Integer)l.getValue();
        }
        if (r != null && (Integer)r.getValue() > t) {
            t = (Integer)r.getValue();
        }
        if ((Integer)this.getValue() == t) {
            return true;
        }
        this.setValue(t);
        return false;
    }

    public IntervalNode<T> getLeft() {
        return (IntervalNode)super.getLeft();
    }

    public IntervalNode<T> getRight() {
        return (IntervalNode)super.getRight();
    }
}

