/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.util;

import io.keikai.model.SChart;
import io.keikaiex.ui.ZssCharts;
import io.keikaiex.util.HighchartsHelper;
import io.keikaiex.util.JFreeChartHelper;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.chart.Chart;
import org.zkoss.json.JSONObject;
import org.zkoss.lang.Library;
import org.zkoss.zkex.util.Base64Coder;

public class ChartDrawer {
    private static final Logger logger = LoggerFactory.getLogger(ChartDrawer.class);
    static int count = 1;
    private static String RENDER_SERVER_URL = Optional.ofNullable(Library.getProperty((String)"io.keikai.chart.render.server.url")).orElse(Library.getProperty((String)"org.zkoss.zss.chart.render.server.url"));
    private static String RENDER_SERVER_SCALE = Optional.ofNullable(Library.getProperty((String)"io.keikai.chart.render.server.scale")).orElse(Library.getProperty((String)"org.zkoss.zss.chart.render.server.scale"));
    private static String CONNECTION_TIMEOUT = Optional.ofNullable(Library.getProperty((String)"io.keikai.chart.render.server.timeout")).orElse(Library.getProperty((String)"org.zkoss.zss.chart.render.server.timeout"));

    public static BufferedImage drawChartImage(SChart chartInfo, int transparency) throws IOException {
        BufferedImage bufferedImage = null;
        if (RENDER_SERVER_URL == null) {
            JFreeChart jfchart = JFreeChartHelper.drawJFreeChart(chartInfo);
            bufferedImage = jfchart.createBufferedImage(chartInfo.getAnchor().getWidth(), chartInfo.getAnchor().getHeight(), transparency, new ChartRenderingInfo());
        } else {
            ZssCharts zssCharts = HighchartsHelper.createCharts(chartInfo);
            HighchartsHelper.drawCharts(zssCharts, chartInfo);
            Chart c = zssCharts.getPlotData().getChart();
            c.setWidth((Number)chartInfo.getAnchor().getWidth());
            c.setHeight((Number)chartInfo.getAnchor().getHeight());
            JSONObject obj = new JSONObject();
            String chartJSON = zssCharts.getPlotData().toJSONString();
            chartJSON = chartJSON.replace("';;;;;", "function(){");
            chartJSON = chartJSON.replace(";;;'", ";}");
            chartJSON = chartJSON.replace("\\'", "'");
            obj.put((Object)"infile", (Object)chartJSON);
            if (RENDER_SERVER_SCALE != null) {
                obj.put((Object)"scale", (Object)RENDER_SERVER_SCALE);
            }
            HttpURLConnection connection = null;
            int timeout = CONNECTION_TIMEOUT != null ? Integer.parseInt(CONNECTION_TIMEOUT) : 10000;
            try {
                String output;
                connection = (HttpURLConnection)new URL(RENDER_SERVER_URL).openConnection();
                logger.debug("Fetch chart picture via connection: %s", (Object)RENDER_SERVER_URL);
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                connection.setRequestProperty("Accept", "*/*");
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setConnectTimeout(timeout);
                connection.setReadTimeout(timeout);
                connection.connect();
                DataOutputStream out = new DataOutputStream(connection.getOutputStream());
                out.write(obj.toJSONString().getBytes("UTF-8"));
                out.flush();
                out.close();
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuffer sb = new StringBuffer();
                while ((output = in.readLine()) != null) {
                    sb.append(output);
                }
                in.close();
                ByteArrayInputStream bis = new ByteArrayInputStream(Base64Coder.decode((String)sb.toString()));
                bufferedImage = ImageIO.read(bis);
            }
            catch (IOException e) {
                throw new IOException("Make sure the rendering server and network work well. Server URL: " + RENDER_SERVER_URL, e);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        return bufferedImage;
    }
}

