/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.widget;

import io.keikai.model.SChart;
import io.keikai.model.SSheet;
import io.keikai.model.ViewAnchor;
import io.keikai.ui.Spreadsheet;
import io.keikaiex.ui.ZssCharts;
import io.keikaiex.ui.widget.BaseWidget;
import io.keikaiex.util.HighchartsHelper;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.impl.Utils;

public class ChartsWidget
extends BaseWidget {
    private static final long serialVersionUID = 7841619576255947718L;
    private static String DATA_LABELS_ENABLED_KEY = "io.keikai.chart.dataLabelsEnabled";
    private SSheet _sheet;
    private int _zindex;
    private SChart _chartInfo;
    private ZssCharts _chartComp;
    private boolean _initWhenLoaded = true;

    private ZssCharts inner() {
        return this._chartComp;
    }

    public ChartsWidget(SSheet sheet, SChart chartInfo, String panel, int zindex) {
        super(panel);
        this._sheet = sheet;
        this._chartInfo = chartInfo;
        this._zindex = zindex;
        this._chartComp = this.newChart0();
        this.setId(this._chartInfo.getId());
        this.setSizable(!chartInfo.isSparkline());
        this.setMovable(!chartInfo.isSparkline());
        this.setCtrlKeys("#del");
    }

    @Override
    protected Component getInnerComponent() {
        return this.inner();
    }

    @Override
    void setInClient(boolean inClient) {
        super.setInClient(inClient);
        if (inClient) {
            this._chartComp.setParent((Component)this.getCtrl());
        } else {
            this._chartComp.setParent(null);
        }
    }

    boolean isInitWhenLoaded() {
        return this._initWhenLoaded;
    }

    void setInitWhenLoaded(boolean initWhenLoaded) {
        this._initWhenLoaded = initWhenLoaded;
    }

    public String getType() {
        return this.inner().getType();
    }

    public void setType(String type) {
        this.inner().setType(type);
    }

    public String getTitle() {
        return this.inner().getTitle().getText();
    }

    public void setTitle(String title) {
        this.inner().setTitle(title);
    }

    public boolean isThreeD() {
        return this.inner().isThreeD();
    }

    public void setThreeD(boolean enabled) {
        this.inner().setThreeD(enabled);
    }

    public void setWidth(Number width) {
        this.inner().setWidth(width);
    }

    public Number getWidth() {
        return this.inner().getWidth();
    }

    public void setHeight(Number height) {
        this.inner().setHeight(height);
    }

    public Number getHeight() {
        return this.inner().getHeight();
    }

    private ZssCharts newChart0() {
        ZssCharts chart = this.createChart(this._chartInfo);
        return chart;
    }

    @Override
    public void invalidate() {
        if (this._chartComp != null) {
            this.initChart();
        }
    }

    private void initChart() {
        Spreadsheet spreadsheet;
        String propName = "io.keikai.chart.emptyAsGaps";
        Spreadsheet spreadsheet2 = spreadsheet = this.getHandler() != null ? this.getHandler().getSpreadsheet() : null;
        if (spreadsheet != null) {
            this._chartInfo.setEmptyAsGaps(Utils.testAttribute((Component)spreadsheet, (String)"io.keikai.chart.emptyAsGaps", (boolean)this._chartInfo.isEmptyAsGaps(), (boolean)true));
        }
        boolean dataLabelsEnabled = Utils.testAttribute((Component)spreadsheet, (String)DATA_LABELS_ENABLED_KEY, (boolean)false, (boolean)true);
        HighchartsHelper.drawCharts(this._chartComp, this._chartInfo, dataLabelsEnabled);
        this._chartComp.setSclass("zswidget-chart");
        this._initWhenLoaded = false;
        ViewAnchor anchor = this._chartInfo.getAnchor();
        this._chartComp.setVisible(anchor.getWidth() != 0 && anchor.getHeight() != 0);
    }

    public ZssCharts createChart(SChart chartInfo) {
        return HighchartsHelper.createCharts(chartInfo);
    }

    @Override
    public String getWidgetType() {
        return "chart";
    }
}

